/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.RequiresApi;
import com.instabug.library.ui.custom.MaterialMenu;

@RequiresApi(api=14)
public class MaterialMenuDrawable
extends Drawable
implements MaterialMenu,
Animatable {
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_TRANSFORM_DURATION = 800;
    public static final boolean DEFAULT_VISIBLE = true;
    private static final int BASE_DRAWABLE_WIDTH = 40;
    private static final int BASE_DRAWABLE_HEIGHT = 40;
    private static final int BASE_ICON_WIDTH = 20;
    private static final int BASE_CIRCLE_RADIUS = 18;
    private static final float ARROW_MID_LINE_ANGLE = 180.0f;
    private static final float ARROW_TOP_LINE_ANGLE = 135.0f;
    private static final float ARROW_BOT_LINE_ANGLE = 225.0f;
    private static final float X_TOP_LINE_ANGLE = 44.0f;
    private static final float X_BOT_LINE_ANGLE = -44.0f;
    private static final float X_ROTATION_ANGLE = 90.0f;
    private static final float CHECK_MIDDLE_ANGLE = 135.0f;
    private static final float CHECK_BOTTOM_ANGLE = -90.0f;
    private static final float TRANSFORMATION_START = 0.0f;
    private static final float TRANSFORMATION_MID = 1.0f;
    private static final float TRANSFORMATION_END = 2.0f;
    private static final int DEFAULT_CIRCLE_ALPHA = 200;
    private final float diph;
    private final float dip1;
    private final float dip2;
    private final float dip3;
    private final float dip4;
    private final float dip8;
    private final int width;
    private final int height;
    private final float strokeWidth;
    private final float iconWidth;
    private final float topPadding;
    private final float sidePadding;
    private final float circleRadius;
    private final Stroke stroke;
    private final Object lock;
    private final Paint iconPaint;
    private final Paint circlePaint;
    private float transformationValue;
    private boolean transformationRunning;
    private IconState currentIconState;
    private AnimationState animationState;
    private IconState animatingIconState;
    private boolean visible;
    private boolean rtlEnabled;
    private ObjectAnimator transformation;
    private Animator.AnimatorListener animatorListener;
    private MaterialMenuState materialMenuState;
    private Property<MaterialMenuDrawable, Float> transformationProperty;

    public MaterialMenuDrawable(Context context, int color2, Stroke stroke) {
        this(context, color2, stroke, 1, 800);
    }

    public MaterialMenuDrawable(Context context, int color2, Stroke stroke, int transformDuration) {
        this(context, color2, stroke, 1, transformDuration);
    }

    public MaterialMenuDrawable(Context context2, int color2, Stroke stroke, int scale, int transformDuration) {
        MaterialMenuDrawable materialMenuDrawable = this;
        this.lock = new Object();
        this.iconPaint = new Paint();
        this.circlePaint = new Paint();
        this.transformationValue = 0.0f;
        this.transformationRunning = false;
        this.currentIconState = IconState.BURGER;
        this.animationState = AnimationState.BURGER_ARROW;
        this.transformationProperty = new Property<MaterialMenuDrawable, Float>(Float.class, "transformation"){

            public Float get(MaterialMenuDrawable object) {
                return object.getTransformationValue();
            }

            public void set(MaterialMenuDrawable object, Float value) {
                object.setTransformationValue(value);
            }
        };
        context2 = context2.getResources();
        MaterialMenuDrawable materialMenuDrawable2 = this;
        float context2 = scale;
        this.dip1 = MaterialMenuDrawable.dpToPx((Resources)context2, 1.0f) * context2;
        this.dip2 = MaterialMenuDrawable.dpToPx((Resources)context2, 2.0f) * context2;
        this.dip3 = MaterialMenuDrawable.dpToPx((Resources)context2, 3.0f) * context2;
        this.dip4 = MaterialMenuDrawable.dpToPx((Resources)context2, 4.0f) * context2;
        this.dip8 = MaterialMenuDrawable.dpToPx((Resources)context2, 8.0f) * context2;
        this.diph = this.dip1 / 2.0f;
        materialMenuDrawable2.stroke = stroke;
        materialMenuDrawable2.visible = true;
        this.width = (int)(MaterialMenuDrawable.dpToPx((Resources)context2, 40.0f) * context2);
        this.height = (int)(MaterialMenuDrawable.dpToPx((Resources)context2, 40.0f) * context2);
        this.iconWidth = MaterialMenuDrawable.dpToPx((Resources)context2, 20.0f) * context2;
        this.circleRadius = MaterialMenuDrawable.dpToPx((Resources)context2, 18.0f) * context2;
        materialMenuDrawable.strokeWidth = MaterialMenuDrawable.dpToPx((Resources)context2, stroke.strokeWidth) * context2;
        materialMenuDrawable.sidePadding = ((float)materialMenuDrawable.width - this.iconWidth) / 2.0f;
        materialMenuDrawable.topPadding = ((float)materialMenuDrawable.height - this.dip3 * 5.0f) / 2.0f;
        this.initPaint(color2);
        this.initAnimations(transformDuration);
        this.materialMenuState = new MaterialMenuState();
    }

    private MaterialMenuDrawable(int color2, Stroke stroke, long transformDuration, int width, int height, float iconWidth, float circleRadius, float strokeWidth, float dip1) {
        this.lock = new Object();
        this.iconPaint = new Paint();
        this.circlePaint = new Paint();
        this.transformationValue = 0.0f;
        this.transformationRunning = false;
        this.currentIconState = IconState.BURGER;
        this.animationState = AnimationState.BURGER_ARROW;
        this.transformationProperty = new /* invalid duplicate definition of identical inner class */;
        this.dip1 = dip1;
        this.dip2 = dip1 * 2.0f;
        this.dip3 = dip1 * 3.0f;
        this.dip4 = dip1 * 4.0f;
        this.dip8 = dip1 * 8.0f;
        this.diph = dip1 / 2.0f;
        this.stroke = stroke;
        this.width = width;
        this.height = height;
        this.iconWidth = iconWidth;
        this.circleRadius = circleRadius;
        this.strokeWidth = strokeWidth;
        this.sidePadding = ((float)width - iconWidth) / 2.0f;
        this.topPadding = ((float)height - this.dip3 * 5.0f) / 2.0f;
        this.initPaint(color2);
        this.initAnimations((int)transformDuration);
        this.materialMenuState = new MaterialMenuState();
    }

    private void initPaint(int color2) {
        MaterialMenuDrawable materialMenuDrawable = this_;
        materialMenuDrawable.iconPaint.setAntiAlias(true);
        materialMenuDrawable.iconPaint.setStyle(Paint.Style.STROKE);
        materialMenuDrawable.iconPaint.setStrokeWidth(this_.strokeWidth);
        materialMenuDrawable.iconPaint.setColor(color2);
        materialMenuDrawable.circlePaint.setAntiAlias(true);
        materialMenuDrawable.circlePaint.setStyle(Paint.Style.FILL);
        materialMenuDrawable.circlePaint.setColor(color2);
        materialMenuDrawable.circlePaint.setAlpha(200);
        int this_ = materialMenuDrawable.width;
        color2 = materialMenuDrawable.height;
        materialMenuDrawable.setBounds(0, 0, this_, color2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawMiddleLine(Canvas canvas, float ratio) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this;
        Canvas canvas2 = canvas;
        canvas2.restore();
        canvas2.save();
        float f2 = 0.0f;
        int n = materialMenuDrawable.width;
        float f3 = (float)n / 2.0f;
        float f4 = (float)n / 2.0f;
        float f5 = materialMenuDrawable.sidePadding;
        float f6 = materialMenuDrawable.topPadding;
        float f7 = f6;
        float f8 = this.dip3;
        float f9 = f7 + f8 / 2.0f * 5.0f;
        f7 = (float)n - f5;
        f8 = f6 + f8 / 2.0f * 5.0f;
        int n2 = 255;
        switch (this.animationState) {
            default: {
                break;
            }
            case X_CHECK: {
                float f10;
                void v3 = f10;
                void v4 = f10;
                void v5 = f10;
                n2 = (int)(v5 * 255.0f);
                f2 = v5 * 135.0f;
                f10 = this.dip3;
                f5 += v4 * (this.dip4 + f10 / 2.0f);
                f7 += v3 * this.dip1;
                f3 = (float)this.width / 2.0f + f10 + this.diph;
                break;
            }
            case BURGER_CHECK: {
                float f10;
                void v6 = f10;
                void v7 = f10;
                f2 = f10 * 135.0f;
                f10 = this.dip3;
                f5 += v7 * (this.dip4 + f10 / 2.0f);
                f7 += v6 * this.dip1;
                f3 = (float)this.width / 2.0f + f10 + this.diph;
                break;
            }
            case ARROW_CHECK: {
                float f10;
                f2 = this.isMorphingForward() ? f10 * 135.0f : 135.0f - (1.0f - f10) * 135.0f;
                f3 = this.dip3;
                f5 += f3 / 2.0f + this.dip4 - (1.0f - f10) * this.dip2;
                f7 += f10 * this.dip1;
                f3 = (float)this.width / 2.0f + f3 + this.diph;
                break;
            }
            case ARROW_X: {
                float f10;
                float f11 = 1.0f - f10;
                n2 = (int)(f11 * 255.0f);
                f5 += f11 * this.dip2;
                break;
            }
            case BURGER_X: {
                float f10;
                n2 = (int)((1.0f - f10) * 255.0f);
                break;
            }
            case BURGER_ARROW: {
                float f10;
                f2 = this.isMorphingForward() ? f10 * 180.0f : (1.0f - f10) * 180.0f + 180.0f;
                f7 -= f10 * this.resolveStrokeModifier(f10) / 2.0f;
            }
        }
        this.iconPaint.setAlpha(n2);
        var1_1.rotate(f2, f3, f4);
        var1_1.drawLine(f5, f9, f7, f8, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    /*
     * WARNING - void declaration
     */
    private void drawTopLine(Canvas canvas, float ratio) {
        void var1_1;
        int n;
        MaterialMenuDrawable materialMenuDrawable = this;
        canvas.save();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n2 = materialMenuDrawable.width;
        float f6 = (float)n2 / 2.0f + this.dip3 / 2.0f;
        float f7 = materialMenuDrawable.topPadding;
        float f8 = f7;
        float f9 = this.dip2;
        float f10 = f9;
        float f11 = f8;
        float f12 = f8 + f10;
        f8 = this.sidePadding;
        f10 = f11 + f10;
        float f13 = (float)n2 - f8;
        float f14 = f7 + f9;
        int n3 = 255;
        switch (this.animationState) {
            default: {
                n = n3;
                break;
            }
            case X_CHECK: {
                float f15;
                MaterialMenuDrawable materialMenuDrawable2 = this;
                f2 = 44.0f;
                f5 = 90.0f;
                f3 = materialMenuDrawable2.sidePadding + this.dip4;
                f4 = this.dip3;
                float f16 = materialMenuDrawable2.topPadding + f4;
                f15 = 1.0f - f15;
                float f17 = f4;
                f13 += f17 - f17 * f15;
                f8 += f4;
                n = (int)(f15 * 255.0f);
                f4 = f16;
                break;
            }
            case BURGER_CHECK: {
                float f15;
                n = (int)((1.0f - f15) * 255.0f);
                break;
            }
            case ARROW_CHECK: {
                float f15;
                MaterialMenuDrawable materialMenuDrawable3 = this;
                n = (int)((1.0f - f15) * 255.0f);
                f2 = 225.0f;
                f3 = (float)materialMenuDrawable3.width / 2.0f;
                float f18 = (float)materialMenuDrawable3.height / 2.0f;
                f13 -= materialMenuDrawable3.resolveStrokeModifier(1.0f);
                f8 += this.dip3;
                f4 = f18;
                break;
            }
            case ARROW_X: {
                float f15;
                void v7 = f15;
                MaterialMenuDrawable materialMenuDrawable4 = this;
                void v9 = f15;
                f2 = v9 * -181.0f + 225.0f;
                f5 = v9 * 90.0f;
                int n4 = materialMenuDrawable4.width;
                f3 = (float)n4 / 2.0f + (this.sidePadding + this.dip4 - (float)n4 / 2.0f) * f15;
                int n5 = materialMenuDrawable4.height;
                f15 = (float)n5 / 2.0f + (this.topPadding + this.dip3 - (float)n5 / 2.0f) * f15;
                f13 -= this.resolveStrokeModifier((float)v7);
                f8 += this.dip3;
                f4 = f15;
                n = n3;
                break;
            }
            case BURGER_X: {
                float f15;
                float f19 = f8;
                MaterialMenuDrawable materialMenuDrawable5 = this;
                void v12 = f15;
                f2 = v12 * 44.0f;
                f5 = v12 * 90.0f;
                f3 = materialMenuDrawable5.sidePadding + this.dip4;
                f4 = materialMenuDrawable5.topPadding;
                f8 = materialMenuDrawable5.dip3;
                float f20 = f15;
                f15 = f4 + f8;
                f8 = f19 + f8 * f20;
                f4 = f15;
                n = n3;
                break;
            }
            case BURGER_ARROW: {
                float f15;
                f2 = this.isMorphingForward() ? f15 * 225.0f : (1.0f - f15) * 135.0f + 225.0f;
                MaterialMenuDrawable materialMenuDrawable6 = this;
                f3 = (float)materialMenuDrawable6.width / 2.0f;
                f4 = (float)materialMenuDrawable6.height / 2.0f;
                f13 -= this.resolveStrokeModifier(f15);
                f8 += this.dip3 * f15;
                n = n3;
            }
        }
        this.iconPaint.setAlpha(n);
        var1_1.rotate(f2, f3, f4);
        var1_1.rotate(f5, f6, f12);
        var1_1.drawLine(f8, f10, f13, f14, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    /*
     * WARNING - void declaration
     */
    private void drawBottomLine(Canvas canvas, float ratio) {
        void var1_1;
        float f2;
        MaterialMenuDrawable materialMenuDrawable = this;
        Canvas canvas2 = canvas;
        canvas2.restore();
        canvas2.save();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = materialMenuDrawable.width;
        float f7 = (float)n / 2.0f + this.dip3 / 2.0f;
        int n2 = materialMenuDrawable.height;
        float f8 = this.topPadding;
        float f9 = this.dip2;
        float f10 = (float)n2 - f8 - f9;
        float f11 = materialMenuDrawable.sidePadding;
        float f12 = (float)n2 - f8 - f9;
        float f13 = (float)n - f11;
        f8 = (float)n2 - f8 - f9;
        switch (this.animationState) {
            default: {
                float f14 = f4;
                f2 = f6;
                f4 = f5;
                f5 = f14;
                break;
            }
            case X_CHECK: {
                float f15 = f13;
                f3 = 1.0f - f2;
                MaterialMenuDrawable materialMenuDrawable2 = this;
                f6 = f3 * -90.0f;
                f4 = f2 * 89.0f + -44.0f;
                f5 = materialMenuDrawable2.sidePadding;
                f13 = this.dip4;
                f9 = this.dip3;
                f5 = f5 + f13 + ((float)this.width / 2.0f + f9 - f5 - f13) * f2;
                int n3 = materialMenuDrawable2.height;
                float f16 = this.topPadding;
                f2 = (float)n3 - f16 - f9 + (f16 + (float)n3 / 2.0f - (float)n3) * f2;
                f11 += materialMenuDrawable2.dip8 - (f13 + this.dip1) * f3;
                f13 = f15 - this.resolveStrokeModifier(f3);
                float f17 = f4;
                float f18 = f2;
                f2 = f6;
                f4 = f18;
                f3 = f17;
                break;
            }
            case BURGER_CHECK: {
                MaterialMenuDrawable materialMenuDrawable3 = this;
                f4 = f2 * 45.0f;
                f3 = this.dip3;
                f5 = (float)materialMenuDrawable3.width / 2.0f + f3 * f2;
                f3 = (float)materialMenuDrawable3.height / 2.0f - f3 * f2;
                f11 += materialMenuDrawable3.dip8 * f2;
                f13 -= this.resolveStrokeModifier(f2);
                float f19 = f4;
                f2 = f6;
                f4 = f3;
                f3 = f19;
                break;
            }
            case ARROW_CHECK: {
                MaterialMenuDrawable materialMenuDrawable4 = this;
                f4 = f2 * -90.0f + 135.0f;
                f3 = this.dip3;
                f5 = (float)materialMenuDrawable4.width / 2.0f + f3 * f2;
                f3 = (float)materialMenuDrawable4.height / 2.0f - f3 * f2;
                f13 -= materialMenuDrawable4.resolveStrokeModifier(1.0f);
                f11 += this.dip3 + (this.dip4 + this.dip1) * f2;
                float f20 = f4;
                f2 = f6;
                f4 = f3;
                f3 = f20;
                break;
            }
            case ARROW_X: {
                MaterialMenuDrawable materialMenuDrawable5 = this;
                float f21 = f2;
                f4 = f21 * 181.0f + 135.0f;
                f6 = f21 * -90.0f;
                int n4 = materialMenuDrawable5.width;
                f5 = (float)n4 / 2.0f + (this.sidePadding + this.dip4 - (float)n4 / 2.0f) * f2;
                n4 = materialMenuDrawable5.height;
                f3 = (float)n4 / 2.0f + ((float)n4 / 2.0f - this.topPadding - this.dip3) * f2;
                f13 -= this.resolveStrokeModifier(f2);
                f11 += this.dip3;
                float f22 = f4;
                f2 = f6;
                f4 = f3;
                f3 = f22;
                break;
            }
            case BURGER_X: {
                f3 = this.isMorphingForward() ? f2 * -90.0f : f2 * 90.0f;
                MaterialMenuDrawable materialMenuDrawable6 = this;
                f4 = f2 * -44.0f;
                f5 = materialMenuDrawable6.sidePadding + this.dip4;
                f6 = (float)materialMenuDrawable6.height - this.topPadding;
                f9 = materialMenuDrawable6.dip3;
                float f23 = f2;
                f2 = f6 - f9;
                f11 += f9 * f23;
                float f24 = f4;
                float f25 = f2;
                f2 = f3;
                f4 = f25;
                f3 = f24;
                break;
            }
            case BURGER_ARROW: {
                f3 = this.isMorphingForward() ? f2 * 135.0f : (1.0f - f2) * 225.0f + 135.0f;
                MaterialMenuDrawable materialMenuDrawable7 = this;
                int n5 = materialMenuDrawable7.width;
                f5 = (float)n5 / 2.0f;
                f4 = (float)this.height / 2.0f;
                f13 = (float)n5 - this.sidePadding - this.resolveStrokeModifier(f2);
                f11 = materialMenuDrawable7.sidePadding + this.dip3 * f2;
                f2 = f6;
            }
        }
        var1_1.rotate(f3, f5, f4);
        var1_1.rotate(f2, f7, f10);
        var1_1.drawLine(f11, f12, f13, f8, this.iconPaint);
    }

    private boolean isMorphingForward() {
        return this.transformationValue <= 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private float resolveStrokeModifier(float ratio) {
        void var1_2;
        int n = 3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$Stroke[this.stroke.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return 0.0f;
                }
                AnimationState animationState = this.animationState;
                if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
                    return (float)(var1_2 * this.dip4);
                }
                return this.dip4 - (this.dip3 + this.dip1) * var1_2;
            }
            AnimationState animationState = this.animationState;
            if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
                return (float)(var1_2 * (this.dip3 + this.diph));
            }
            float f2 = this.dip3;
            float f3 = this.diph;
            return f2 + f3 - (f2 + f3) * var1_2;
        }
        AnimationState animationState = this.animationState;
        if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
            return (float)(var1_2 * this.dip3);
        }
        float f4 = this.dip3;
        return f4 - f4 * var1_2;
    }

    private void initAnimations(int transformDuration) {
        MaterialMenuDrawable materialMenuDrawable = this;
        materialMenuDrawable.transformation = ObjectAnimator.ofFloat((Object)materialMenuDrawable, materialMenuDrawable.transformationProperty, (float[])new float[]{0.0f});
        materialMenuDrawable.transformation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(3.0f));
        materialMenuDrawable.transformation.setDuration((long)transformDuration);
        materialMenuDrawable.transformation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                2 v0 = this;
                MaterialMenuDrawable.access$202(v0.MaterialMenuDrawable.this, false);
                MaterialMenuDrawable materialMenuDrawable = v0.MaterialMenuDrawable.this;
                materialMenuDrawable.setIconState(materialMenuDrawable.animatingIconState);
            }
        });
    }

    private boolean resolveTransformation() {
        boolean bl = this.currentIconState == IconState.BURGER;
        boolean bl2 = this.currentIconState == IconState.ARROW;
        boolean bl3 = this.currentIconState == IconState.X;
        boolean bl4 = this.currentIconState == IconState.CHECK;
        boolean bl5 = this.animatingIconState == IconState.BURGER;
        boolean bl6 = this.animatingIconState == IconState.ARROW;
        boolean bl7 = this.animatingIconState == IconState.X;
        boolean bl8 = this.animatingIconState == IconState.CHECK;
        if (bl && bl6 || bl2 && bl5) {
            this.animationState = AnimationState.BURGER_ARROW;
            return bl;
        }
        if (bl2 && bl7 || bl3 && bl6) {
            this.animationState = AnimationState.ARROW_X;
            return bl2;
        }
        if (bl && bl7 || bl3 && bl5) {
            this.animationState = AnimationState.BURGER_X;
            return bl;
        }
        if (bl2 && bl8 || bl4 && bl6) {
            this.animationState = AnimationState.ARROW_CHECK;
            return bl2;
        }
        if (bl && bl8 || bl4 && bl5) {
            this.animationState = AnimationState.BURGER_CHECK;
            return bl;
        }
        if (bl3 && bl8 || bl4 && bl7) {
            this.animationState = AnimationState.X_CHECK;
            return bl3;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.currentIconState;
        objectArray[1] = this.animatingIconState;
        throw new IllegalStateException(String.format("Animating from %s to %s is not supported", objectArray2));
    }

    static float dpToPx(Resources resources, float dp) {
        resources = resources.getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources);
    }

    static /* synthetic */ boolean access$202(MaterialMenuDrawable x0, boolean x1) {
        x0.transformationRunning = x1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Canvas canvas) {
        void var1_1;
        float f2;
        if (!this.visible) {
            return;
        }
        float f3 = this.transformationValue;
        if (!(f2 <= 1.0f)) {
            f3 = 2.0f - f3;
        }
        if (this.rtlEnabled) {
            void v1 = var1_1;
            v1.save();
            v1.scale(-1.0f, 1.0f, 0.0f, 0.0f);
            var1_1.translate((float)(-this.getIntrinsicWidth()), 0.0f);
        }
        MaterialMenuDrawable materialMenuDrawable = this;
        this.drawTopLine((Canvas)var1_1, f3);
        this.drawMiddleLine((Canvas)var1_1, f3);
        materialMenuDrawable.drawBottomLine((Canvas)var1_1, f3);
        if (materialMenuDrawable.rtlEnabled) {
            var1_1.restore();
        }
    }

    public void setAlpha(int alpha) {
        this.iconPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.iconPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    @Override
    public void setColor(int color2) {
        MaterialMenuDrawable materialMenuDrawable = this;
        materialMenuDrawable.iconPaint.setColor(color2);
        materialMenuDrawable.circlePaint.setColor(color2);
        materialMenuDrawable.invalidateSelf();
    }

    @Override
    @RequiresApi(api=11)
    public void setTransformationDuration(int duration) {
        this.transformation.setDuration((long)duration);
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        this.transformation.setInterpolator((TimeInterpolator)interpolator);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAnimationListener(Animator.AnimatorListener listener) {
        void var1_1;
        Animator.AnimatorListener animatorListener = this.animatorListener;
        if (animatorListener != null) {
            this.transformation.removeListener(animatorListener);
        }
        if (var1_1 != null) {
            this.transformation.addListener((Animator.AnimatorListener)var1_1);
        }
        this.animatorListener = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setIconState(IconState iconState) {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            void var1_1;
            if (materialMenuDrawable.transformationRunning) {
                this.transformation.cancel();
                this.transformationRunning = false;
            }
            if (this.currentIconState == var1_1) {
                return;
            }
            switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$IconState[var1_1.ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    MaterialMenuDrawable materialMenuDrawable2 = this;
                    materialMenuDrawable2.animationState = AnimationState.BURGER_CHECK;
                    materialMenuDrawable2.transformationValue = 1.0f;
                    break;
                }
                case 3: {
                    MaterialMenuDrawable materialMenuDrawable3 = this;
                    materialMenuDrawable3.animationState = AnimationState.BURGER_X;
                    materialMenuDrawable3.transformationValue = 1.0f;
                    break;
                }
                case 2: {
                    MaterialMenuDrawable materialMenuDrawable4 = this;
                    materialMenuDrawable4.animationState = AnimationState.BURGER_ARROW;
                    materialMenuDrawable4.transformationValue = 1.0f;
                    break;
                }
                case 1: {
                    MaterialMenuDrawable materialMenuDrawable5 = this;
                    materialMenuDrawable5.animationState = AnimationState.BURGER_ARROW;
                    materialMenuDrawable5.transformationValue = 0.0f;
                }
            }
            this.currentIconState = var1_1;
            this.invalidateSelf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void animateIconState(IconState state) {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            void var1_1;
            if (materialMenuDrawable.transformationRunning) {
                this.transformation.end();
            }
            this.animatingIconState = var1_1;
            this.start();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IconState setTransformationOffset(AnimationState animationState, float offset) {
        Object[] objectArray2;
        void var2_2;
        void cfr_temp_0;
        void n;
        if (!(offset < 0.0f) && (n = (cfr_temp_0 = var2_2 - 2.0f) == 0 ? 0 : (cfr_temp_0 > 0 ? 1 : -1)) <= 0) {
            void var3_6;
            IconState iconState;
            objectArray2.animationState = iconState;
            if (!(var2_2 < 1.0f) && n != false) {
                boolean bl = false;
            } else {
                boolean bl = true;
            }
            IconState iconState2 = var3_6 != false ? ((AnimationState)((Object)iconState)).getFirstState() : ((AnimationState)((Object)iconState)).getSecondState();
            objectArray2.currentIconState = iconState2;
            iconState = var3_6 != false ? ((AnimationState)((Object)iconState)).getSecondState() : ((AnimationState)((Object)iconState)).getFirstState();
            objectArray2.animatingIconState = iconState;
            objectArray2.setTransformationValue(Float.valueOf((float)var2_2));
            return objectArray2.currentIconState;
        }
        Object[] objectArray = new Object[2];
        objectArray2 = objectArray;
        objectArray[0] = Float.valueOf(0.0f);
        objectArray[1] = Float.valueOf(2.0f);
        throw new IllegalArgumentException(String.format("Value must be between %s and %s", objectArray2));
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.invalidateSelf();
    }

    @Override
    public void setRTLEnabled(boolean rtlEnabled) {
        this.rtlEnabled = rtlEnabled;
        this.invalidateSelf();
    }

    @Override
    public IconState getIconState() {
        return this.currentIconState;
    }

    public boolean isDrawableVisible() {
        return this.visible;
    }

    public Float getTransformationValue() {
        return Float.valueOf(this.transformationValue);
    }

    public void setTransformationValue(Float value) {
        this.transformationValue = value.floatValue();
        this.invalidateSelf();
    }

    public void start() {
        if (this.transformationRunning) {
            return;
        }
        IconState iconState = this.animatingIconState;
        if (iconState != null && iconState != this.currentIconState) {
            this.transformationRunning = true;
            boolean n = this.resolveTransformation();
            ObjectAnimator objectAnimator = this.transformation;
            float[] fArray = new float[2];
            int f3 = 0;
            float f2 = n ? 0.0f : 1.0f;
            fArray[f3] = f2;
            int n2 = 1;
            float f4 = n ? 1.0f : 2.0f;
            fArray[n2] = f4;
            objectAnimator.setFloatValues(fArray);
            this.transformation.start();
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (this.isRunning() && this.transformation.isRunning()) {
            this.transformation.end();
        } else {
            this.transformationRunning = false;
            this.invalidateSelf();
        }
    }

    public boolean isRunning() {
        return this.transformationRunning;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public Drawable.ConstantState getConstantState() {
        MaterialMenuDrawable materialMenuDrawable = this;
        MaterialMenuState.access$402(materialMenuDrawable.materialMenuState, this.getChangingConfigurations());
        return materialMenuDrawable.materialMenuState;
    }

    public Drawable mutate() {
        this.materialMenuState = new MaterialMenuState();
        return this;
    }

    private final class MaterialMenuState
    extends Drawable.ConstantState {
        private int changingConfigurations;

        private MaterialMenuState() {
        }

        static /* synthetic */ int access$402(MaterialMenuState x0, int x1) {
            x0.changingConfigurations = x1;
            return x1;
        }

        public Drawable newDrawable() {
            MaterialMenuDrawable materialMenuDrawable;
            MaterialMenuDrawable materialMenuDrawable2 = materialMenuDrawable;
            materialMenuDrawable = new MaterialMenuDrawable(MaterialMenuDrawable.this.circlePaint.getColor(), MaterialMenuDrawable.this.stroke, MaterialMenuDrawable.this.transformation.getDuration(), MaterialMenuDrawable.this.width, MaterialMenuDrawable.this.height, MaterialMenuDrawable.this.iconWidth, MaterialMenuDrawable.this.circleRadius, MaterialMenuDrawable.this.strokeWidth, MaterialMenuDrawable.this.dip1);
            IconState iconState = MaterialMenuDrawable.this.animatingIconState != null ? MaterialMenuDrawable.this.animatingIconState : MaterialMenuDrawable.this.currentIconState;
            MaterialMenuDrawable materialMenuDrawable3 = materialMenuDrawable2;
            materialMenuDrawable2.setIconState(iconState);
            materialMenuDrawable2.setVisible(MaterialMenuDrawable.this.visible);
            materialMenuDrawable3.setRTLEnabled(MaterialMenuDrawable.this.rtlEnabled);
            return materialMenuDrawable3;
        }

        public int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }

    public static enum Stroke {
        REGULAR(3),
        THIN(2),
        EXTRA_THIN(1);

        private final int strokeWidth;

        private Stroke(int strokeWidth) {
            this.strokeWidth = strokeWidth;
        }

        protected static Stroke valueOf(int strokeWidth) {
            if (strokeWidth != 1) {
                int n;
                if (n != 2) {
                    if (n != 3) {
                        return THIN;
                    }
                    return REGULAR;
                }
                return THIN;
            }
            return EXTRA_THIN;
        }
    }

    public static enum AnimationState {
        BURGER_ARROW,
        BURGER_X,
        ARROW_X,
        ARROW_CHECK,
        BURGER_CHECK,
        X_CHECK;


        public IconState getFirstState() {
            switch (this) {
                default: {
                    return null;
                }
                case X_CHECK: {
                    return IconState.X;
                }
                case BURGER_CHECK: {
                    return IconState.BURGER;
                }
                case ARROW_CHECK: {
                    return IconState.ARROW;
                }
                case ARROW_X: {
                    return IconState.ARROW;
                }
                case BURGER_X: {
                    return IconState.BURGER;
                }
                case BURGER_ARROW: 
            }
            return IconState.BURGER;
        }

        public IconState getSecondState() {
            switch (this) {
                default: {
                    return null;
                }
                case X_CHECK: {
                    return IconState.CHECK;
                }
                case BURGER_CHECK: {
                    return IconState.CHECK;
                }
                case ARROW_CHECK: {
                    return IconState.CHECK;
                }
                case ARROW_X: {
                    return IconState.X;
                }
                case BURGER_X: {
                    return IconState.X;
                }
                case BURGER_ARROW: 
            }
            return IconState.ARROW;
        }
    }

    public static enum IconState {
        BURGER,
        ARROW,
        X,
        CHECK;

    }
}

