/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.c;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.logging.f;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDateFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InstabugUserEventLogger {
    private static final long DELAY = 1L;
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 10000;
    private List<UserEvent> userEvents = new ArrayList<UserEvent>();
    private ConcurrentHashMap<String, Integer> userEventsCount = new ConcurrentHashMap();
    private ScheduledExecutorService insertionExecutor;

    private InstabugUserEventLogger() {
    }

    public static InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    /*
     * WARNING - void declaration
     */
    private void runInsertionHandler(String uuid, boolean anonymous) {
        if (this_.insertionExecutor == null) {
            void var2_2;
            void var1_1;
            Runnable runnable = new Runnable((String)var1_1, (boolean)var2_2){
                final /* synthetic */ String a;
                final /* synthetic */ boolean b;
                {
                    this.a = string2;
                    this.b = bl;
                }

                @Override
                public void run() {
                    for (Map.Entry entry : InstabugUserEventLogger.this.userEventsCount.entrySet()) {
                        InstabugUserEventLogger.this.incrementEventLoggingCount((String)entry.getKey(), (Integer)entry.getValue(), this.a, this.b);
                    }
                    a a2 = this;
                    a2.InstabugUserEventLogger.this.userEventsCount.clear();
                    InstabugUserEventLogger.access$202(a2.InstabugUserEventLogger.this, null);
                }
            };
            Object this_ = TimeUnit.SECONDS;
            Executors.newScheduledThreadPool(1).schedule(runnable, 1L, (TimeUnit)((Object)this_));
        }
    }

    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy, String uuid, boolean anonymous) {
        String string2 = eventIdentifier;
        f.a(string2, f.b(string2, b.g()) + incrementBy, uuid, anonymous);
    }

    static /* synthetic */ ScheduledExecutorService access$202(InstabugUserEventLogger x0, ScheduledExecutorService x1) {
        x0.insertionExecutor = x1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class), new Api.Parameter().setName("userEventParams").setType(UserEventParam.class));
        if (c.b().a(Feature.USER_EVENTS) == Feature.State.ENABLED) {
            Integer n;
            void var1_1;
            UserEvent userEvent = new UserEvent().setEventIdentifier((String)var1_1).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
            int n2 = ((void)n).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                userEvent.addParam((UserEventParam)n[i2]);
            }
            if (this.userEvents.size() >= 10000) {
                this.userEvents.remove(0);
            }
            InstabugUserEventLogger instabugUserEventLogger = this;
            instabugUserEventLogger.userEvents.add(userEvent);
            n = instabugUserEventLogger.userEventsCount.get(var1_1);
            if (n != null) {
                this.userEventsCount.put((String)var1_1, n + 1);
            } else {
                this.userEventsCount.put((String)var1_1, 1);
            }
            UserEventsEventBus.getInstance().post(userEvent);
        }
        this.runInsertionHandler(b.g(), b.h() ^ true);
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userEventIdentifier").setType(String.class));
        return f.b(userEventIdentifier, b.g());
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    public void clearAll() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        f.a(b.g());
    }
}

