/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.internal.media.AudioPlayer;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PermissionsUtils;
import com.instabug.library.util.PlaceHolderUtils;
import java.util.Timer;
import java.util.TimerTask;

public class InstabugAudioRecordingFragment
extends Fragment
implements View.OnTouchListener,
View.OnClickListener {
    private static final String EXTRA_FILE_PATH = "com.instabug.library.audio_attachment_path";
    private ImageView mRecordButtonBackground;
    private boolean mIsRecordingActive = false;
    private ImageView mRecordButtonIcon;
    private PorterDuffColorFilter mColorFilter;
    private Timer mRecordingTimer;
    private com.instabug.library.internal.media.a mRecorder;
    private int mCurrentTime;
    private TimerTask mTimerTask = new d();
    private TextView timerTextView;
    private TextView titleTextView;
    private boolean mIsRecordingPermissionGranted;
    private boolean isFirstPermissionRequested = false;
    private Callbacks listener;

    public static InstabugAudioRecordingFragment newInstance(String absolutePath) {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = new InstabugAudioRecordingFragment();
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_FILE_PATH, absolutePath);
        instabugAudioRecordingFragment.setArguments(bundle);
        return instabugAudioRecordingFragment;
    }

    public static InstabugAudioRecordingFragment newInstance(String absolutePath, Callbacks listener) {
        InstabugAudioRecordingFragment.newInstance(absolutePath).listener = listener;
        return InstabugAudioRecordingFragment.newInstance(absolutePath);
    }

    private void requestAudioRecordingPermission() {
        Runnable runnable;
        Runnable runnable2;
        Runnable runnable3 = runnable2;
        runnable2 = new Runnable(){

            @Override
            public void run() {
                if (InstabugAudioRecordingFragment.this.isFirstPermissionRequested) {
                    a a2 = this;
                    InstabugSDKLogger.d((Object)a2.InstabugAudioRecordingFragment.this, "Shouldn't try to explain why get this permission, either first time or never again selected OR permission not in manifest");
                    Toast.makeText((Context)a2.InstabugAudioRecordingFragment.this.getContext(), (CharSequence)InstabugAudioRecordingFragment.this.getPermissionDeniedMessage(), (int)0).show();
                } else {
                    InstabugAudioRecordingFragment.access$002(InstabugAudioRecordingFragment.this, true);
                }
            }
        };
        Runnable runnable4 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                b b2 = this;
                InstabugSDKLogger.d((Object)b2.InstabugAudioRecordingFragment.this, "Audio recording permission already granted before");
                InstabugAudioRecordingFragment.access$202(b2.InstabugAudioRecordingFragment.this, true);
            }
        };
        PermissionsUtils.requestPermission(this, "android.permission.RECORD_AUDIO", 1, runnable3, runnable4);
    }

    private void finishRecording() {
        if (this.listener != null) {
            AudioPlayer audioPlayer;
            final AudioPlayer audioPlayer2 = audioPlayer;
            audioPlayer2();
            audioPlayer.getDurationAsync(this.getArguments().getString(EXTRA_FILE_PATH), new AudioPlayer.e(){

                @Override
                public void a(int n) {
                    c c2 = this;
                    c2.audioPlayer2.release();
                    c2.InstabugAudioRecordingFragment.this.listener.onAudioRecorded(InstabugAudioRecordingFragment.this.getArguments().getString(InstabugAudioRecordingFragment.EXTRA_FILE_PATH), AudioPlayer.getFormattedDurationText(n));
                    c2.InstabugAudioRecordingFragment.this.removeCurrentFragment();
                }
            });
        }
    }

    private boolean stopRecording() {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment2;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment3;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment4;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment5;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment6;
        try {
            InstabugAudioRecordingFragment instabugAudioRecordingFragment7 = this;
            instabugAudioRecordingFragment6 = instabugAudioRecordingFragment7;
            instabugAudioRecordingFragment5 = instabugAudioRecordingFragment7;
            instabugAudioRecordingFragment4 = instabugAudioRecordingFragment7;
            instabugAudioRecordingFragment3 = instabugAudioRecordingFragment7;
            InstabugAudioRecordingFragment instabugAudioRecordingFragment8 = instabugAudioRecordingFragment7;
            instabugAudioRecordingFragment2 = instabugAudioRecordingFragment7;
            instabugAudioRecordingFragment = instabugAudioRecordingFragment7;
            InstabugAudioRecordingFragment instabugAudioRecordingFragment9 = instabugAudioRecordingFragment7;
            InstabugAudioRecordingFragment instabugAudioRecordingFragment10 = instabugAudioRecordingFragment7;
            instabugAudioRecordingFragment7.mTimerTask.cancel();
        }
        catch (RuntimeException runtimeException) {
            if (this.mCurrentTime > 1) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Unknown error occurred", (int)0).show();
            }
            InstabugSDKLogger.e((Object)this, "Error capturing audio stream", runtimeException);
            return false;
        }
        instabugAudioRecordingFragment.mRecordingTimer.cancel();
        instabugAudioRecordingFragment9.mTimerTask = new d();
        instabugAudioRecordingFragment10.mRecordingTimer = new Timer();
        instabugAudioRecordingFragment8.mIsRecordingActive = false;
        instabugAudioRecordingFragment2.setStateInactive();
        TextView textView = instabugAudioRecordingFragment4.timerTextView;
        Object[] objectArray = new Object[1];
        objectArray[0] = 0;
        textView.setText((CharSequence)String.format("00:%02d", objectArray));
        instabugAudioRecordingFragment3.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD, this.getString(R.string.instabug_str_hold_to_record)));
        instabugAudioRecordingFragment6.mRecorder.b();
        return instabugAudioRecordingFragment5.mCurrentTime > 3;
    }

    private void setStateActive() {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
        instabugAudioRecordingFragment.mRecordButtonBackground.setImageResource(R.drawable.instabug_bg_active_record);
        Colorizer.applyTint(-65536, instabugAudioRecordingFragment.mRecordButtonBackground);
        instabugAudioRecordingFragment.mRecordButtonIcon.setColorFilter(null);
        instabugAudioRecordingFragment.timerTextView.setTextColor(-65536);
    }

    private void setStateInactive() {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
        instabugAudioRecordingFragment.mRecordButtonBackground.setImageResource(R.drawable.instabug_bg_default_record);
        instabugAudioRecordingFragment.mRecordButtonBackground.setColorFilter((ColorFilter)this.mColorFilter);
        instabugAudioRecordingFragment.mRecordButtonIcon.setColorFilter((ColorFilter)this.mColorFilter);
        instabugAudioRecordingFragment.timerTextView.setTextColor(Instabug.getPrimaryColor());
    }

    private String getPermissionDeniedMessage() {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.AUDIO_RECORDING_PERMISSION_DENIED, this.getString(R.string.instabug_audio_recorder_permission_denied));
    }

    private void onTimeIsUp() {
        this.finishRecording();
    }

    private void removeCurrentFragment() {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
        instabugAudioRecordingFragment.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
        instabugAudioRecordingFragment.getFragmentManager().popBackStack("Record Audio", 1);
    }

    static /* synthetic */ boolean access$002(InstabugAudioRecordingFragment x0, boolean x1) {
        x0.isFirstPermissionRequested = x1;
        return x1;
    }

    static /* synthetic */ boolean access$202(InstabugAudioRecordingFragment x0, boolean x1) {
        x0.mIsRecordingPermissionGranted = x1;
        return x1;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
        instabugAudioRecordingFragment.mIsRecordingPermissionGranted = false;
        instabugAudioRecordingFragment.mRecordingTimer = new Timer();
        instabugAudioRecordingFragment.mRecorder = new com.instabug.library.internal.media.a(this.getArguments().getString(EXTRA_FILE_PATH));
        View view = inflater.inflate(R.layout.instabug_lyt_record_audio, container, false);
        Object[] objectArray = inflater = view;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment2 = this;
        InstabugAudioRecordingFragment instabugAudioRecordingFragment3 = this;
        inflater.findViewById(R.id.instabug_btn_record_audio).setOnTouchListener((View.OnTouchListener)this);
        this.mRecordButtonBackground = (ImageView)inflater.findViewById(R.id.instabug_bk_record_audio);
        instabugAudioRecordingFragment3.mRecordButtonIcon = (ImageView)inflater.findViewById(R.id.instabug_img_record_audio);
        instabugAudioRecordingFragment3.mColorFilter = new PorterDuffColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
        instabugAudioRecordingFragment3.mRecordButtonBackground.setColorFilter((ColorFilter)this.mColorFilter);
        instabugAudioRecordingFragment3.mRecordButtonIcon.setColorFilter((ColorFilter)this.mColorFilter);
        instabugAudioRecordingFragment2.timerTextView = (TextView)inflater.findViewById(R.id.instabug_txt_timer);
        instabugAudioRecordingFragment2.timerTextView.setTextColor(Instabug.getPrimaryColor());
        Object[] objectArray2 = new Object[1];
        inflater = objectArray2;
        objectArray2[0] = 0;
        instabugAudioRecordingFragment2.timerTextView.setText((CharSequence)String.format("00:%02d", inflater));
        this.titleTextView = (TextView)objectArray.findViewById(R.id.instabug_txt_recording_title);
        this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD, this.getString(R.string.instabug_str_hold_to_record)));
        view.findViewById(R.id.instabug_recording_audio_dialog_container).setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
        super.onViewCreated(view, savedInstanceState);
        instabugAudioRecordingFragment.requestAudioRecordingPermission();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    /*
     * WARNING - void declaration
     */
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        void var3_3;
        if (requestCode != 1) {
            void var2_2;
            void var1_1;
            super.onRequestPermissionsResult((int)var1_1, (String[])var2_2, (int[])var3_3);
        } else if (((void)var3_3).length > 0 && var3_3[0] == false) {
            InstabugSDKLogger.d((Object)this, "Audio recording permission granted by user");
            this.mIsRecordingPermissionGranted = true;
        } else {
            InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
            InstabugSDKLogger.d((Object)instabugAudioRecordingFragment, "Audio recording permission denied by user");
            instabugAudioRecordingFragment.mIsRecordingPermissionGranted = false;
            Toast.makeText((Context)instabugAudioRecordingFragment.getContext(), (CharSequence)this.getPermissionDeniedMessage(), (int)0).show();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouch(View v, MotionEvent event) {
        int n = event.getAction();
        if (n != 0) {
            void var2_3;
            if ((n == 1 || n == 3) && this.mIsRecordingActive && this.mIsRecordingPermissionGranted && this.stopRecording() && var2_3.getAction() == 1) {
                this.finishRecording();
            }
        } else {
            if (!this.mIsRecordingActive && this.mIsRecordingPermissionGranted) {
                InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
                instabugAudioRecordingFragment.mCurrentTime = 0;
                instabugAudioRecordingFragment.mRecordingTimer.scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
                instabugAudioRecordingFragment.mRecorder.a();
                instabugAudioRecordingFragment.mIsRecordingActive = true;
                instabugAudioRecordingFragment.setStateActive();
                instabugAudioRecordingFragment.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_RELEASE_TO_ATTACH, this.getString(R.string.instabug_str_release_stop_record)));
            }
            if (!this.mIsRecordingPermissionGranted) {
                this.requestAudioRecordingPermission();
            }
        }
        return true;
    }

    public void onClick(View v) {
        if (this.getFragmentManager() != null) {
            InstabugAudioRecordingFragment instabugAudioRecordingFragment = this;
            instabugAudioRecordingFragment.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
            instabugAudioRecordingFragment.getFragmentManager().popBackStack();
        }
    }

    class d
    extends TimerTask {
        d() {
        }

        @Override
        public void run() {
            InstabugAudioRecordingFragment.this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (InstabugAudioRecordingFragment.this.mCurrentTime >= 50) {
                        InstabugAudioRecordingFragment.this.timerTextView.setTextColor(Instabug.getPrimaryColor());
                    } else {
                        InstabugAudioRecordingFragment.this.timerTextView.setTextColor(-65536);
                    }
                    if (InstabugAudioRecordingFragment.this.mCurrentTime == 60) {
                        InstabugAudioRecordingFragment.this.onTimeIsUp();
                    }
                    a a2 = this;
                    a2.InstabugAudioRecordingFragment.this.timerTextView.setText((CharSequence)AudioPlayer.getFormattedDurationText(InstabugAudioRecordingFragment.this.mCurrentTime * 1000));
                    a2.InstabugAudioRecordingFragment.this.mCurrentTime++;
                }
            });
        }
    }

    public static interface Callbacks {
        public void onAudioRecorded(String var1, String var2);
    }
}

