/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.AsyncTask;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.util.DisplayMetrics;
import com.instabug.library.Instabug;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class a {
    public static final a a = new a();
    private Intent b;
    private MediaProjection c;

    private a() {
    }

    public void a(int n, Intent intent, boolean bl, ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener) {
        this.b = n == -1 && intent != null ? intent : null;
        if (bl) {
            this.a(screenshotCapturingListener);
        }
    }

    private void a(final ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener) {
        Handler handler = new Handler();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                a.this.a(Instabug.getApplicationContext(), new ScreenshotProvider.ScreenshotCapturingListener(){

                    @Override
                    public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                        BitmapUtils.maskBitmap(bitmap, SettingsManager.getInstance(), null);
                        screenshotCapturingListener.onScreenshotCapturedSuccessfully(bitmap);
                    }

                    @Override
                    public void onScreenshotCapturingFailed(Throwable throwable) {
                        InstabugSDKLogger.e("ScreenshotManager", "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                        if (screenshotCapturingListener != null) {
                            screenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                            SettingsManager.getInstance().setProcessingForeground(false);
                        }
                    }
                });
            }
        };
        handler.postDelayed(runnable, 500L);
    }

    @UiThread
    public boolean a(@NonNull Context context, final ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener) {
        if (this.b == null) {
            return false;
        }
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        if (this.c != null) {
            this.c.stop();
            this.c = null;
        }
        this.c = mediaProjectionManager.getMediaProjection(-1, this.b);
        if (this.c == null) {
            return false;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        activity.getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
        int n = displayMetrics.densityDpi;
        final int n2 = displayMetrics.widthPixels;
        final int n3 = displayMetrics.heightPixels;
        ImageReader imageReader = ImageReader.newInstance((int)n2, (int)n3, (int)1, (int)1);
        VirtualDisplay virtualDisplay = this.c.createVirtualDisplay("screencap", n2, n3, n, 9, imageReader.getSurface(), null, null);
        imageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){

            @SuppressLint(value={"StaticFieldLeak"})
            public void onImageAvailable(final ImageReader reader) {
                a.this.c.stop();
                new AsyncTask<Void, Void, Bitmap>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Bitmap a(Void ... voidArray) {
                        Image image = null;
                        Bitmap bitmap = null;
                        try {
                            image = reader.acquireLatestImage();
                            if (image != null) {
                                Image.Plane[] planeArray = image.getPlanes();
                                ByteBuffer byteBuffer = planeArray[0].getBuffer();
                                int n = planeArray[0].getPixelStride();
                                int n2 = planeArray[0].getRowStride();
                                int n3 = n2 - n * n2;
                                bitmap = Bitmap.createBitmap((int)(n2 + n3 / n), (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
                                Rect rect = image.getCropRect();
                                Bitmap bitmap2 = bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
                                return bitmap2;
                            }
                        }
                        catch (Exception exception) {
                            if (bitmap != null) {
                                bitmap.recycle();
                            }
                            InstabugSDKLogger.e("ScreenshotManager", "Error occurred while processing the taken screenshot ", exception);
                        }
                        finally {
                            if (image != null) {
                                image.close();
                            }
                            reader.close();
                        }
                        return null;
                    }

                    protected void a(Bitmap bitmap) {
                        if (bitmap != null) {
                            screenshotCapturingListener.onScreenshotCapturedSuccessfully(bitmap);
                        } else {
                            screenshotCapturingListener.onScreenshotCapturingFailed(new Exception("Failed to capture screenshot using media projection "));
                        }
                        super.onPostExecute((Object)bitmap);
                    }

                    protected /* synthetic */ void onPostExecute(Object object) {
                        this.a((Bitmap)object);
                    }

                    protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                        return this.a((Void[])objectArray);
                    }
                }.execute((Object[])new Void[0]);
            }
        }, null);
        this.a(virtualDisplay, imageReader, this.c);
        return true;
    }

    private void a(final VirtualDisplay virtualDisplay, final ImageReader imageReader, final MediaProjection mediaProjection) {
        mediaProjection.registerCallback(new MediaProjection.Callback(){

            public void onStop() {
                super.onStop();
                if (virtualDisplay != null) {
                    virtualDisplay.release();
                }
                imageReader.setOnImageAvailableListener(null, null);
                mediaProjection.unregisterCallback((MediaProjection.Callback)this);
            }
        }, null);
    }
}

