/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.c;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.a;
import com.instabug.library.model.i;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.e;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.b;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.VisualUserStep;
import com.instabug.library.visualusersteps.g;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements Cacheable,
Serializable {
    public static final String KEY_APP_PACKAGE_NAME = "bundle_id";
    public static final String KEY_APP_VERSION = "app_version";
    public static final String KEY_BATTERY_LEVEL = "battery_level";
    public static final String KEY_BATTERY_STATUS = "battery_state";
    public static final String KEY_CARRIER = "carrier";
    public static final String KEY_CONSOLE_LOG = "console_log";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_DENSITY = "density";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_DEVICE_ROOTED = "device_rooted";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_INSTABUG_LOG = "instabug_log";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_MEMORY_FREE = "memory_free";
    public static final String KEY_MEMORY_TOTAL = "memory_total";
    public static final String KEY_MEMORY_USED = "memory_used";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OS = "os";
    public static final String KEY_REPORTED_AT = "reported_at";
    public static final String KEY_SCREEN_SIZE = "screen_size";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_STORAGE_FREE = "storage_free";
    public static final String KEY_STORAGE_TOTAL = "storage_total";
    public static final String KEY_STORAGE_USED = "storage_used";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_USER_DATA = "user_data";
    public static final String KEY_USER_STEPS = "user_steps";
    public static final String KEY_WIFI_SSID = "wifi_ssid";
    public static final String KEY_WIFI_STATE = "wifi_state";
    public static final String KEY_USER_ATTRIBUTES = "user_attributes";
    public static final String KEY_NETWORK_LOGS = "network_log";
    public static final String KEY_USER_EVENTS = "user_events";
    public static final String KEY_VISUAL_USER_STEPS = "user_repro_steps";
    public static final String KEY_SESSIONS_PROFILER = "sessions_profiler";
    public static final String KEY_APP_STATUS = "app_status";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_FOREGROUND = "foreground";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_BACKGROUND = "background";
    private static final String TAG = "State";
    private String sdkVersion;
    private String locale;
    private long duration;
    private String device;
    private boolean isDeviceRooted;
    private String OS;
    private String carrier;
    private String appPackageName;
    private String appVersion;
    private int batteryLevel;
    private String batteryState;
    private boolean wifiState;
    private String wifiSSID;
    private long usedMemory;
    private long freeMemory;
    private long totalMemory;
    private long usedStorage;
    private long freeStorage;
    private long totalStorage;
    private String screenDensity;
    private String screenSize;
    private String ScreenOrientation;
    private String currentView;
    private String instabugLog;
    private ArrayList<a> consoleLog;
    private ArrayList<i> userSteps;
    private ArrayList<VisualUserStep> visualUserSteps;
    private com.instabug.library.c.a.a.e sessionProfilerTimeline;
    private String userEmail;
    private String userData;
    private long reportedAt;
    private String tags;
    private String networkLogs;
    private String userAttributes;
    private String userEvents;
    private Uri uri;
    private String appStatus;

    public static State getState(Context context) {
        return new Builder(context).build(true);
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public State setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public State setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public State setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public String getDevice() {
        return this.device;
    }

    public State setDevice(String device) {
        this.device = device;
        return this;
    }

    public boolean isDeviceRooted() {
        return this.isDeviceRooted;
    }

    public State setIsDeviceRooted(boolean isDeviceRooted) {
        this.isDeviceRooted = isDeviceRooted;
        return this;
    }

    public String getOS() {
        return this.OS;
    }

    public State setOS(String OS) {
        this.OS = OS;
        return this;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public State setCarrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public State setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
        return this;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public State setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public State setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
        return this;
    }

    public String getBatteryState() {
        return this.batteryState;
    }

    public State setBatteryState(String batteryState) {
        this.batteryState = batteryState;
        return this;
    }

    public boolean isWifiEnable() {
        return this.wifiState;
    }

    public State setWifiState(boolean wifiState) {
        this.wifiState = wifiState;
        return this;
    }

    public String getWifiSSID() {
        return this.wifiSSID;
    }

    public State setWifiSSID(String wifiSSID) {
        this.wifiSSID = wifiSSID;
        return this;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public State setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
        return this;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public State setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
        return this;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public State setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
        return this;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public State setUsedStorage(long usedStorage) {
        this.usedStorage = usedStorage;
        return this;
    }

    public long getFreeStorage() {
        return this.freeStorage;
    }

    public State setFreeStorage(long freeStorage) {
        this.freeStorage = freeStorage;
        return this;
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    public State setTotalStorage(long totalStorage) {
        this.totalStorage = totalStorage;
        return this;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public State setScreenDensity(String screenDensity) {
        this.screenDensity = screenDensity;
        return this;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public State setScreenSize(String screenSize) {
        this.screenSize = screenSize;
        return this;
    }

    public String getScreenOrientation() {
        return this.ScreenOrientation;
    }

    public State setScreenOrientation(String screenOrientation) {
        this.ScreenOrientation = screenOrientation;
        return this;
    }

    public String getCurrentView() {
        return this.currentView;
    }

    public State setCurrentView(String currentView) {
        this.currentView = currentView;
        return this;
    }

    public String getAppStatus() {
        return this.appStatus;
    }

    public State setAppStatus(String appStatus) {
        this.appStatus = appStatus;
        return this;
    }

    public String getInstabugLog() {
        return this.instabugLog;
    }

    public State setInstabugLog(String instabugLog) {
        this.instabugLog = instabugLog;
        return this;
    }

    public void updateConsoleLog() {
        this.setConsoleLog(Builder.getConsoleLog());
    }

    public void updateConsoleLog(ArrayList<a> logs) {
        this.setConsoleLog(Builder.getConsoleLog(logs));
    }

    public JSONArray getConsoleLog() {
        return a.a(this.consoleLog);
    }

    public State setConsoleLog(ArrayList<a> consoleLogs) {
        this.consoleLog = consoleLogs;
        return this;
    }

    public JSONArray getUserSteps() {
        return i.a(this.userSteps);
    }

    public State setUserSteps(ArrayList<i> userSteps) {
        this.userSteps = userSteps;
        return this;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public State setUserEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public State setUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    public State setReportedAt(long reportedAt) {
        this.reportedAt = reportedAt;
        return this;
    }

    public String getTags() {
        return this.tags;
    }

    public State setTags(String tags) {
        this.tags = tags;
        return this;
    }

    private static String getTagsAsString(List<String> tags) {
        StringBuilder stringBuilder = new StringBuilder();
        if (tags != null && tags.size() > 0) {
            int n = tags.size();
            for (int i2 = 0; i2 < n; ++i2) {
                stringBuilder.append(tags.get(i2));
                if (i2 == n - 1) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    public State setTags(List<String> tags) {
        this.tags = State.getTagsAsString(tags);
        return this;
    }

    public String getUserAttributes() {
        return this.userAttributes;
    }

    public State setUserAttributes(String userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    public String getNetworkLogs() {
        return this.networkLogs;
    }

    public State setNetworkLogs(String networkLogs) {
        this.networkLogs = networkLogs;
        return this;
    }

    public String getUserEvents() {
        return this.userEvents;
    }

    public State setUserEvents(String userEvents) {
        this.userEvents = userEvents;
        return this;
    }

    public String getVisualUserSteps() {
        return VisualUserStep.toJsonString(this.visualUserSteps);
    }

    public State setVisualUserSteps(ArrayList<VisualUserStep> visualUserSteps) {
        this.visualUserSteps = visualUserSteps;
        return this;
    }

    public String getSessionProfilerTimeline() {
        return this.sessionProfilerTimeline.c().toString();
    }

    public State setSessionProfilerTimeline(com.instabug.library.c.a.a.e sessionProfilerTimeline) {
        this.sessionProfilerTimeline = sessionProfilerTimeline;
        return this;
    }

    public ArrayList<StateItem> getStateItems() {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_APP_PACKAGE_NAME).setValue(this.getAppPackageName()));
        arrayList.add(new StateItem().setKey(KEY_APP_VERSION).setValue(this.getAppVersion()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_LEVEL).setValue(this.getBatteryLevel()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_STATUS).setValue(this.getBatteryState()));
        arrayList.add(new StateItem().setKey(KEY_CARRIER).setValue(this.getCarrier()));
        arrayList.add(new StateItem().setKey(KEY_CURRENT_VIEW).setValue(this.getCurrentView()));
        arrayList.add(new StateItem().setKey(KEY_DENSITY).setValue(this.getScreenDensity()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE).setValue(this.getDevice()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE_ROOTED).setValue(this.isDeviceRooted()));
        arrayList.add(new StateItem().setKey(KEY_DURATION).setValue(this.getDuration()));
        arrayList.add(new StateItem().setKey(KEY_EMAIL).setValue(this.getUserEmail()));
        arrayList.add(new StateItem().setKey(KEY_LOCALE).setValue(this.getLocale()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_FREE).setValue(this.getFreeMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_TOTAL).setValue(this.getTotalMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_USED).setValue(this.getUsedMemory()));
        arrayList.add(new StateItem().setKey(KEY_ORIENTATION).setValue(this.getScreenOrientation()));
        arrayList.add(new StateItem().setKey(KEY_OS).setValue(this.getOS()));
        arrayList.add(new StateItem().setKey(KEY_REPORTED_AT).setValue(this.getReportedAt()));
        arrayList.add(new StateItem().setKey(KEY_SCREEN_SIZE).setValue(this.getScreenSize()));
        arrayList.add(new StateItem().setKey(KEY_SDK_VERSION).setValue(this.getSdkVersion()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_FREE).setValue(this.getFreeStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_TOTAL).setValue(this.getTotalStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_USED).setValue(this.getUsedStorage()));
        arrayList.add(new StateItem().setKey(KEY_TAGS).setValue(this.getTags()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_SSID).setValue(this.getWifiSSID()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_STATE).setValue(this.isWifiEnable()));
        arrayList.add(new StateItem().setKey(KEY_USER_ATTRIBUTES).setValue(this.getUserAttributes()));
        arrayList.add(new StateItem().setKey(KEY_APP_STATUS).setValue(this.getAppStatus()));
        return arrayList;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        ArrayList<StateItem> arrayList = this.getStateItems();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            jSONObject.put(arrayList.get(i2).getKey(), arrayList.get(i2).getValue());
        }
        ArrayList<StateItem> arrayList2 = this.getLogsItems();
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            jSONObject.put(arrayList2.get(i3).getKey(), arrayList2.get(i3).getValue());
        }
        return jSONObject.toString();
    }

    @Override
    public void fromJson(String stateAsJson) throws JSONException {
        JSONObject jSONObject = new JSONObject(stateAsJson);
        if (jSONObject.has(KEY_APP_PACKAGE_NAME)) {
            this.setAppPackageName(jSONObject.getString(KEY_APP_PACKAGE_NAME));
        }
        if (jSONObject.has(KEY_APP_VERSION)) {
            this.setAppVersion(jSONObject.getString(KEY_APP_VERSION));
        }
        if (jSONObject.has(KEY_BATTERY_LEVEL)) {
            this.setBatteryLevel(jSONObject.getInt(KEY_BATTERY_LEVEL));
        }
        if (jSONObject.has(KEY_BATTERY_STATUS)) {
            this.setBatteryState(jSONObject.getString(KEY_BATTERY_STATUS));
        }
        if (jSONObject.has(KEY_CARRIER)) {
            this.setCarrier(jSONObject.getString(KEY_CARRIER));
        }
        if (jSONObject.has(KEY_CONSOLE_LOG)) {
            this.setConsoleLog(a.a(new JSONArray(jSONObject.getString(KEY_CONSOLE_LOG))));
        }
        if (jSONObject.has(KEY_CURRENT_VIEW)) {
            this.setCurrentView(jSONObject.getString(KEY_CURRENT_VIEW));
        }
        if (jSONObject.has(KEY_DENSITY)) {
            this.setScreenDensity(jSONObject.getString(KEY_DENSITY));
        }
        if (jSONObject.has(KEY_DEVICE)) {
            this.setDevice(jSONObject.getString(KEY_DEVICE));
        }
        if (jSONObject.has(KEY_DEVICE_ROOTED)) {
            this.setIsDeviceRooted(jSONObject.getBoolean(KEY_DEVICE_ROOTED));
        }
        if (jSONObject.has(KEY_DURATION)) {
            this.setDuration(jSONObject.getLong(KEY_DURATION));
        }
        if (jSONObject.has(KEY_EMAIL)) {
            this.setUserEmail(jSONObject.getString(KEY_EMAIL));
        }
        if (jSONObject.has(KEY_INSTABUG_LOG)) {
            this.setInstabugLog(jSONObject.getString(KEY_INSTABUG_LOG));
        }
        if (jSONObject.has(KEY_LOCALE)) {
            this.setLocale(jSONObject.getString(KEY_LOCALE));
        }
        if (jSONObject.has(KEY_MEMORY_FREE)) {
            this.setFreeMemory(jSONObject.getLong(KEY_MEMORY_FREE));
        }
        if (jSONObject.has(KEY_MEMORY_TOTAL)) {
            this.setTotalMemory(jSONObject.getLong(KEY_MEMORY_TOTAL));
        }
        if (jSONObject.has(KEY_MEMORY_USED)) {
            this.setUsedMemory(jSONObject.getLong(KEY_MEMORY_USED));
        }
        if (jSONObject.has(KEY_ORIENTATION)) {
            this.setScreenOrientation(jSONObject.getString(KEY_ORIENTATION));
        }
        if (jSONObject.has(KEY_OS)) {
            this.setOS(jSONObject.getString(KEY_OS));
        }
        if (jSONObject.has(KEY_APP_STATUS)) {
            this.setAppStatus(jSONObject.getString(KEY_APP_STATUS));
        }
        if (jSONObject.has(KEY_REPORTED_AT)) {
            this.setReportedAt(jSONObject.getLong(KEY_REPORTED_AT));
        }
        if (jSONObject.has(KEY_SCREEN_SIZE)) {
            this.setScreenSize(jSONObject.getString(KEY_SCREEN_SIZE));
        }
        if (jSONObject.has(KEY_SDK_VERSION)) {
            this.setSdkVersion(jSONObject.getString(KEY_SDK_VERSION));
        }
        if (jSONObject.has(KEY_STORAGE_FREE)) {
            this.setFreeStorage(jSONObject.getLong(KEY_STORAGE_FREE));
        }
        if (jSONObject.has(KEY_STORAGE_TOTAL)) {
            this.setTotalStorage(jSONObject.getLong(KEY_STORAGE_TOTAL));
        }
        if (jSONObject.has(KEY_STORAGE_USED)) {
            this.setUsedStorage(jSONObject.getLong(KEY_STORAGE_USED));
        }
        if (jSONObject.has(KEY_TAGS)) {
            this.setTags(jSONObject.getString(KEY_TAGS));
        }
        if (jSONObject.has(KEY_USER_DATA)) {
            this.setUserData(jSONObject.getString(KEY_USER_DATA));
        }
        if (jSONObject.has(KEY_USER_STEPS)) {
            this.setUserSteps(i.a(new JSONArray(jSONObject.getString(KEY_USER_STEPS))));
        }
        if (jSONObject.has(KEY_WIFI_SSID)) {
            this.setWifiSSID(jSONObject.getString(KEY_WIFI_SSID));
        }
        if (jSONObject.has(KEY_WIFI_STATE)) {
            this.setWifiState(jSONObject.getBoolean(KEY_WIFI_STATE));
        }
        if (jSONObject.has(KEY_USER_ATTRIBUTES)) {
            this.setUserAttributes(jSONObject.getString(KEY_USER_ATTRIBUTES));
        }
        if (jSONObject.has(KEY_NETWORK_LOGS)) {
            this.setNetworkLogs(jSONObject.getString(KEY_NETWORK_LOGS));
        }
        if (jSONObject.has(KEY_USER_EVENTS)) {
            this.setUserEvents(jSONObject.getString(KEY_USER_EVENTS));
        }
        if (jSONObject.has(KEY_VISUAL_USER_STEPS)) {
            this.setVisualUserSteps(VisualUserStep.fromJson(new JSONArray(jSONObject.getString(KEY_VISUAL_USER_STEPS))));
        }
        if (jSONObject.has(KEY_SESSIONS_PROFILER)) {
            this.setSessionProfilerTimeline(com.instabug.library.c.a.a.e.a(new JSONObject(jSONObject.getString(KEY_SESSIONS_PROFILER))));
        }
    }

    public ArrayList<StateItem> getLogsItems() {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_CONSOLE_LOG).setValue(this.getConsoleLog().toString()));
        arrayList.add(new StateItem().setKey(KEY_INSTABUG_LOG).setValue(this.getInstabugLog()));
        arrayList.add(new StateItem().setKey(KEY_USER_DATA).setValue(this.getUserData()));
        arrayList.add(new StateItem().setKey(KEY_NETWORK_LOGS).setValue(this.getNetworkLogs()));
        arrayList.add(new StateItem().setKey(KEY_USER_EVENTS).setValue(this.getUserEvents()));
        if (c.a().c(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED) {
            arrayList.add(new StateItem().setKey(KEY_USER_STEPS).setValue(this.getUserSteps().toString()));
        }
        if (c.a().c(Feature.REPRO_STEPS) == Feature.State.ENABLED) {
            arrayList.add(new StateItem().setKey(KEY_VISUAL_USER_STEPS).setValue(this.getVisualUserSteps()));
        }
        if (c.a().c(Feature.SESSION_PROFILER) == Feature.State.ENABLED && this.sessionProfilerTimeline != null) {
            arrayList.add(new StateItem().setKey(KEY_SESSIONS_PROFILER).setValue(this.getSessionProfilerTimeline()));
        }
        return arrayList;
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            InstabugSDKLogger.e(TAG, "Something went wrong while getting state.toString()" + jSONException.getMessage(), jSONException);
            return "error";
        }
    }

    public boolean equals(Object state) {
        if (state != null && state instanceof State) {
            State state2 = (State)state;
            return String.valueOf(state2.getAppVersion()).equals(String.valueOf(this.getAppVersion())) && state2.getBatteryLevel() == this.getBatteryLevel() && String.valueOf(state2.getBatteryState()).equals(String.valueOf(this.getBatteryState())) && String.valueOf(state2.getCarrier()).equals(String.valueOf(this.getCarrier())) && String.valueOf(state2.getAppStatus()).equals(String.valueOf(this.getAppStatus())) && String.valueOf(state2.getConsoleLog()).equals(String.valueOf(this.getConsoleLog())) && String.valueOf(state2.getCurrentView()).equals(String.valueOf(this.getCurrentView())) && state2.getDuration() == this.getDuration() && String.valueOf(state2.getDevice()).equals(String.valueOf(this.getDevice())) && state2.getFreeMemory() == this.getFreeMemory() && state2.getFreeStorage() == this.getFreeStorage() && String.valueOf(state2.getLocale()).equals(String.valueOf(this.getLocale())) && String.valueOf(state2.getOS()).equals(String.valueOf(this.getOS())) && state2.getReportedAt() == this.getReportedAt() && String.valueOf(state2.getScreenDensity()).equals(String.valueOf(this.getScreenDensity())) && String.valueOf(state2.getScreenOrientation()).equals(String.valueOf(this.getScreenOrientation())) && String.valueOf(state2.getScreenSize()).equals(String.valueOf(this.getScreenSize())) && String.valueOf(state2.getSdkVersion()).equals(String.valueOf(this.getSdkVersion())) && state2.getTotalMemory() == this.getTotalMemory() && state2.getTotalStorage() == this.getTotalStorage() && String.valueOf(state2.getTags()).equals(String.valueOf(this.getTags())) && state2.getUsedMemory() == this.getUsedMemory() && state2.getUsedStorage() == this.getUsedStorage() && String.valueOf(state2.getUserData()).equals(String.valueOf(this.getUserData())) && String.valueOf(state2.getUserEmail()).equals(String.valueOf(this.getUserEmail())) && String.valueOf(state2.getUserSteps()).equals(String.valueOf(this.getUserSteps())) && String.valueOf(state2.getWifiSSID()).equals(String.valueOf(this.getWifiSSID())) && state2.isDeviceRooted() == this.isDeviceRooted() && state2.isWifiEnable() == this.isWifiEnable() && String.valueOf(state2.getInstabugLog()).equals(String.valueOf(this.getInstabugLog())) && String.valueOf(state2.getUserAttributes()).equals(String.valueOf(this.getUserAttributes())) && String.valueOf(state2.getNetworkLogs()).equals(String.valueOf(this.getNetworkLogs())) && String.valueOf(state2.getUserEvents()).equals(String.valueOf(this.getUserEvents())) && String.valueOf(state2.getVisualUserSteps()).equals(String.valueOf(this.getVisualUserSteps())) && String.valueOf(state2.getSessionProfilerTimeline()).equals(String.valueOf(this.getSessionProfilerTimeline()));
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getReportedAt()).hashCode();
    }

    public void updateVisualUserSteps() {
        this.setVisualUserSteps(Builder.getVisualUserSteps());
    }

    public static class Builder
    implements Serializable {
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        private static ArrayList<a> getConsoleLog(ArrayList<a> consoleLogs) {
            ArrayList<a> arrayList = Builder.getConsoleLog();
            arrayList.addAll(consoleLogs);
            return arrayList;
        }

        private static ArrayList<a> getConsoleLog() {
            ArrayList<a> arrayList = new ArrayList<a>();
            if (c.a().c(Feature.CONSOLE_LOGS) == Feature.State.ENABLED) {
                int n = 700;
                try {
                    String string2;
                    Process process = Runtime.getRuntime().exec("logcat -v time -d " + android.os.Process.myPid());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        arrayList2.add(string2);
                    }
                    bufferedReader.close();
                    arrayList2.trimToSize();
                    int n2 = 0;
                    if (arrayList2.size() > n) {
                        n2 = arrayList2.size() - n;
                    }
                    for (int i2 = n2; i2 < arrayList2.size(); ++i2) {
                        if (((String)arrayList2.get(i2)).length() <= 18) continue;
                        a a2 = new a();
                        a2.a(((String)arrayList2.get(i2)).substring(18));
                        a2.a(a.b(((String)arrayList2.get(i2)).substring(0, 18)));
                        arrayList.add(a2);
                    }
                    arrayList2.clear();
                    return arrayList;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(State.TAG, "Could not read logcat log", iOException);
                    return arrayList;
                }
            }
            return arrayList;
        }

        public State build(boolean withInstabugLogs) {
            State state = new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context)).setAppStatus(InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)).setWifiState(DeviceStateProvider.getWifiState(this.context)).setWifiSSID(DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)).setUsedMemory(DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)).setFreeStorage(DeviceStateProvider.getFreeStorage()).setUsedStorage(DeviceStateProvider.getUsedStorage()).setTotalStorage(DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()).setConsoleLog(Builder.getConsoleLog()).setUserSteps(this.getUserSteps()).setUserEmail(this.getUserEmail()).setUserData(this.getUserData()).setReportedAt(this.getReportedAt()).setTags(this.getTags()).setUserAttributes(UserAttributesDbHelper.getSDKUserAttributes()).setNetworkLogs(this.getNetworkLogs()).setUserEvents(this.getUserEvents()).setSessionProfilerTimeline(this.getSessionProfilerTimeline());
            if (withInstabugLogs) {
                state.setInstabugLog(this.getInstabugLog());
            }
            return state;
        }

        public State buildInternalState() {
            State state = new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context)).setAppStatus(InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)).setWifiState(DeviceStateProvider.getWifiState(this.context)).setWifiSSID(DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)).setUsedMemory(DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)).setFreeStorage(DeviceStateProvider.getFreeStorage()).setUsedStorage(DeviceStateProvider.getUsedStorage()).setTotalStorage(DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()).setReportedAt(this.getReportedAt());
            return state;
        }

        public String formatSessionDuration(long d2) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = (int)d2 % 60;
            int n2 = (int)(d2 /= 60L) % 60;
            int n3 = (int)(d2 /= 60L) % 60;
            if (n3 <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n3);
            stringBuilder.append(":");
            if (n2 <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n2);
            stringBuilder.append(":");
            if (n <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        private String getInstabugLog() {
            if (c.a().c(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
                return InstabugLog.getLogs();
            }
            return null;
        }

        private ArrayList<i> getUserSteps() {
            return e.a().c();
        }

        private static ArrayList<VisualUserStep> getVisualUserSteps() {
            return g.a().b();
        }

        private com.instabug.library.c.a.a.e getSessionProfilerTimeline() {
            return com.instabug.library.c.a.a().e();
        }

        private String getUserEmail() {
            return b.f();
        }

        private String getUserData() {
            return SettingsManager.getInstance().getUserData();
        }

        private long getReportedAt() {
            return InstabugDateFormatter.getCurrentUTCTimeStampInSeconds();
        }

        private String getTags() {
            return SettingsManager.getInstance().getTagsAsString();
        }

        public String getNetworkLogs() {
            return com.instabug.library.logging.b.b();
        }

        private String getUserEvents() {
            try {
                return UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents()).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(State.TAG, "Got error while parsing user events logs", jSONException);
                return "";
            }
        }
    }

    public static class StateItem<V>
    implements Serializable {
        String key;
        V value;

        public String getKey() {
            return this.key;
        }

        public StateItem<V> setKey(String key) {
            this.key = key;
            return this;
        }

        public V getValue() {
            return this.value;
        }

        public StateItem<V> setValue(V value) {
            this.value = value;
            return this;
        }

        public String toString() {
            return "key: " + this.getKey() + ", value: " + this.getValue();
        }
    }
}

