/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.model.NetworkLog;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"})
public class InstabugNetworkLog {
    public static final String TAG = "InstabugNetworkLog";
    private NetworkLog networkLog = new NetworkLog();

    public void log(String url, String method, String requestBody, String responseBody, int responseCode) throws IOException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("connection").setType(HttpURLConnection.class), new Api.Parameter().setName("requestBody").setType(String.class), new Api.Parameter().setName("responseBody").setType(String.class));
        this.networkLog.setResponseCode(responseCode);
        this.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        this.networkLog.setMethod(method);
        this.networkLog.setUrl(url);
        try {
            this.networkLog.setRequest(this.validateBody(requestBody));
            this.networkLog.setResponse(this.validateBody(responseBody));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(TAG, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        this.insert();
        InstabugSDKLogger.d(TAG, "adding network log: " + this.networkLog.toString());
    }

    private String validateBody(String responseBody) {
        if (responseBody == null) {
            return null;
        }
        long l = 1000000L;
        if ((long)responseBody.getBytes(Charset.forName("UTF-8")).length > l) {
            return "{\"InstabugNetworkLog Error\":\"Response body exceeded limit\"}";
        }
        return responseBody;
    }

    public void log(HttpURLConnection connection, String requestBody, String responseBody) throws IOException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("connection").setType(HttpURLConnection.class), new Api.Parameter().setName("requestBody").setType(String.class), new Api.Parameter().setName("responseBody").setType(String.class));
        this.networkLog.setResponseCode(connection.getResponseCode());
        this.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        this.networkLog.setMethod(connection.getRequestMethod());
        this.networkLog.setUrl(connection.getURL().toString());
        try {
            this.addHeaders(connection);
            this.networkLog.setRequest(this.validateBody(requestBody));
            this.networkLog.setResponse(this.validateBody(responseBody));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(TAG, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        this.insert();
        InstabugSDKLogger.d(TAG, "adding network log: " + this.networkLog.toString());
    }

    private void addHeaders(HttpURLConnection connection) throws JSONException, IllegalArgumentException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : connection.getHeaderFields().keySet()) {
            if (string2 == null) continue;
            for (String string3 : connection.getHeaderFields().get(string2)) {
                if (!(!string2.equalsIgnoreCase("content-type") || string3.contains("application/json") || string3.contains("application/xml") || string3.contains("text/xml") || string3.contains("text/html") || string3.contains("text/plain"))) {
                    throw new IllegalArgumentException();
                }
                jSONObject.put(string2, (Object)string3);
            }
        }
        this.networkLog.setRequestHeaders(jSONObject.toString());
    }

    private void insert() {
        this.networkLog.insert();
    }
}

