/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.instabug.library.model.c;
import com.instabug.library.settings.SettingsManager;

public final class InstabugSDKLogger {
    private static final String LOG_TAG = "IB-";
    private static com.instabug.library.logging.c instabugSDKDiskLogger;

    private InstabugSDKLogger() {
    }

    public static synchronized void initLogger(Context context) {
        if (instabugSDKDiskLogger == null) {
            instabugSDKDiskLogger = new com.instabug.library.logging.c(context);
            instabugSDKDiskLogger.a();
        }
    }

    public static String logTag(Object instance) {
        if (instance instanceof String) {
            return LOG_TAG + instance;
        }
        String string2 = instance instanceof Class ? ((Class)instance).getSimpleName() : instance.getClass().getSimpleName();
        return LOG_TAG + string2;
    }

    public static void v(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            String string2 = InstabugSDKLogger.logTag(instance);
            if (logMessage.length() > 4000) {
                int n = logMessage.length() / 4000;
                Log.v((String)string2, (String)("logMessage length = " + logMessage.length() + " divided to " + (n + 1) + " chunks"));
                for (int i2 = 0; i2 <= n; ++i2) {
                    int n2 = 4000 * (i2 + 1);
                    String string3 = n2 >= logMessage.length() ? logMessage.substring(4000 * i2) : logMessage.substring(4000 * i2, n2);
                    Log.v((String)string2, (String)("chunk " + (i2 + 1) + " of " + (n + 1) + ":\n" + string3));
                }
            } else {
                Log.v((String)string2, (String)logMessage);
            }
        }
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void d(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        String string2 = InstabugSDKLogger.logTag(instance);
        if (logMessage.length() > 4000) {
            int n = logMessage.length() / 4000;
            Log.d((String)string2, (String)("logMessage length = " + logMessage.length() + " divided to " + (n + 1) + " chunks"));
            for (int i2 = 0; i2 <= n; ++i2) {
                int n2 = 4000 * (i2 + 1);
                String string3 = n2 >= logMessage.length() ? logMessage.substring(4000 * i2) : logMessage.substring(4000 * i2, n2);
                Log.d((String)string2, (String)("chunk " + (i2 + 1) + " of " + (n + 1) + ":\n" + string3));
            }
        } else {
            Log.d((String)string2, (String)logMessage);
        }
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void i(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            Log.i((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
        }
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void w(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.w((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void e(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.e((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void e(@NonNull Object instance, @NonNull String logMessage, @NonNull Throwable throwable) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            Log.e((String)InstabugSDKLogger.logTag(instance), (String)logMessage, (Throwable)throwable);
        }
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void wtf(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.wtf((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void logSessionDetails(c logDescriptor) {
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(logDescriptor);
        } else {
            System.out.println("SDK LOG: instabugSDKDiskLogger not initialized");
        }
    }

    public static void wtf(@NonNull Object instance, @NonNull String logMessage, @NonNull Throwable throwable) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.wtf((String)InstabugSDKLogger.logTag(instance), (String)logMessage, (Throwable)throwable);
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void addVerboseLog(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            String string2 = InstabugSDKLogger.logTag(instance);
            if (logMessage.length() > 4000) {
                int n = logMessage.length() / 4000;
                Log.v((String)string2, (String)("logMessage length = " + logMessage.length() + " divided to " + (n + 1) + " chunks"));
                for (int i2 = 0; i2 <= n; ++i2) {
                    int n2 = 4000 * (i2 + 1);
                    String string3 = n2 >= logMessage.length() ? logMessage.substring(4000 * i2) : logMessage.substring(4000 * i2, n2);
                    Log.v((String)string2, (String)("chunk " + (i2 + 1) + " of " + (n + 1) + ":\n" + string3));
                }
            } else {
                Log.v((String)string2, (String)logMessage);
            }
        }
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.b(InstabugSDKLogger.logTag(instance), logMessage, Thread.currentThread().getName(), System.currentTimeMillis());
        }
    }

    public static void logEndSession(long timeStamp) {
        if (instabugSDKDiskLogger != null) {
            instabugSDKDiskLogger.a(timeStamp);
        } else {
            InstabugSDKLogger.w(LOG_TAG, "SDK LOG: instabugSDKDiskLogger not initialized");
        }
    }
}

