/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.content.ContentValues;
import android.database.Cursor;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;

class a {
    private static PublishSubject<List<InstabugLog.b>> a;
    private static Disposable b;
    private static List<InstabugLog.b> c;

    private static void e() {
        b = (Disposable)a.debounce(1L, TimeUnit.SECONDS).observeOn(Schedulers.io()).subscribeWith((Observer)new DisposableObserver<List<InstabugLog.b>>(){

            public void onComplete() {
            }

            public void onError(Throwable e2) {
                InstabugSDKLogger.e("InstabugLogDbHelper", "couldn't insert the latest logs");
            }

            public void a(List<InstabugLog.b> list) {
                try {
                    c.clear();
                    com.instabug.library.logging.a.b(list);
                }
                catch (IllegalStateException illegalStateException) {
                    InstabugSDKLogger.e("InstabugLogDbHelper", "couldn't insert the latest logs due to " + illegalStateException.getMessage());
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((List)object);
            }
        });
    }

    private static void f() {
        if (b != null && !b.isDisposed()) {
            b.dispose();
        }
    }

    static synchronized void a(InstabugLog.b b2) {
        InstabugSDKLogger.d("InstabugLogDbHelper", "insert");
        if (a == null) {
            a = PublishSubject.create();
            com.instabug.library.logging.a.e();
        } else if (b.isDisposed()) {
            com.instabug.library.logging.a.e();
        }
        c.add(b2);
        a.onNext(new ArrayList<InstabugLog.b>(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void b(List<InstabugLog.b> list) {
        InstabugSDKLogger.d("InstabugLogDbHelper", "insertInstabugLogs");
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            for (InstabugLog.b b2 : list) {
                if (b2 == null) continue;
                ContentValues contentValues = new ContentValues();
                contentValues.put("log_message", b2.a());
                contentValues.put("log_level", b2.b().toString());
                contentValues.put("log_date", String.valueOf(b2.c()));
                sQLiteDatabaseWrapper.insert("instabug_logs", null, contentValues);
            }
            sQLiteDatabaseWrapper.execSQL("DELETE FROM instabug_logs WHERE log_date IN (SELECT log_date FROM instabug_logs ORDER BY log_date DESC LIMIT -1 OFFSET 1000)");
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
        com.instabug.library.logging.a.f();
    }

    private static void g() {
        InstabugSDKLogger.d("InstabugLogDbHelper", "forceInsertSuspendedLogs");
        com.instabug.library.logging.a.f();
        ArrayList<InstabugLog.b> arrayList = new ArrayList<InstabugLog.b>(c);
        c.clear();
        com.instabug.library.logging.a.b(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONArray a() {
        InstabugSDKLogger.d("InstabugLogDbHelper", "retrieve");
        com.instabug.library.logging.a.g();
        JSONArray jSONArray = new JSONArray();
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        Cursor cursor = sQLiteDatabaseWrapper.rawQuery("SELECT * FROM instabug_logs ORDER  BY log_date DESC LIMIT 1000", null);
        try {
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String string = cursor.getString(cursor.getColumnIndex("log_message"));
                    String string2 = cursor.getString(cursor.getColumnIndex("log_level"));
                    String string3 = cursor.getString(cursor.getColumnIndex("log_date"));
                    InstabugLog.b b2 = new InstabugLog.b();
                    b2.a(string).a(InstabugLog.a.valueOf(string2.toUpperCase(Locale.ENGLISH)));
                    if (StringUtility.isNumeric(string3)) {
                        b2.a(Long.parseLong(string3));
                    } else {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
                            b2.a(simpleDateFormat.parse(string3).getTime());
                        }
                        catch (ParseException parseException) {
                            InstabugSDKLogger.e("InstabugLogDbHelper", parseException.getMessage());
                        }
                    }
                    jSONArray.put((Object)b2.d());
                } while (cursor.moveToNext());
            }
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("InstabugLogDbHelper", exception.getMessage(), exception);
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
                sQLiteDatabaseWrapper.close();
            }
        }
        return jSONArray;
    }

    static void b() {
        InstabugSDKLogger.d("InstabugLogDbHelper", "clear");
        com.instabug.library.logging.a.g();
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("instabug_logs", null, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("InstabugLogDbHelper", exception.getMessage(), exception);
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    static void c() {
        InstabugSDKLogger.d("InstabugLogDbHelper", "trim");
        com.instabug.library.logging.a.g();
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.execSQL("DELETE FROM instabug_logs WHERE log_date NOT IN ( SELECT log_date FROM instabug_logs WHERE log_date ORDER BY log_date DESC LIMIT 1000 )");
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("InstabugLogDbHelper", exception.getMessage(), exception);
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    static {
        c = new ArrayList<InstabugLog.b>();
    }
}

