/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.media;

import android.media.MediaPlayer;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AudioPlayer {
    public static final String TAG = "AudioPlayer";
    private String filePath;
    private MediaPlayer mediaPlayer;
    private b onGetDurationListener;
    private Map<String, OnStopListener> onStopListeners = new HashMap<String, OnStopListener>();
    private MediaPlayer.OnCompletionListener onCompletionListener;

    private void prepare(final a actionOnPrepared) {
        try {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setDataSource(this.filePath);
            this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.doAction(actionOnPrepared);
                }
            });
            this.mediaPlayer.prepareAsync();
            if (this.onCompletionListener != null) {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(TAG, "Playing audio file failed", iOException);
        }
    }

    public void addOnStopListener(OnStopListener onStopListener) {
        this.onStopListeners.put(onStopListener.getFilePath(), onStopListener);
        if (this.onCompletionListener == null) {
            this.onCompletionListener = new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.notifyOnStopListeners();
                }
            };
            if (this.mediaPlayer != null) {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
        }
    }

    private void notifyOnStopListeners() {
        for (OnStopListener onStopListener : this.onStopListeners.values()) {
            onStopListener.onStop();
        }
    }

    private void stream(String filePath, a actionOnPrepared) {
        if (filePath == null) {
            InstabugSDKLogger.e(TAG, "Audio file path can not be null");
            return;
        }
        if (filePath.equals(this.filePath)) {
            this.doAction(actionOnPrepared);
        } else {
            this.filePath = filePath;
            this.prepare(actionOnPrepared);
        }
    }

    public void getDurationAsync(String filePath, b onGetDurationListener) {
        this.stream(filePath, a.GET_DURATION);
        this.onGetDurationListener = onGetDurationListener;
    }

    public void start(String filePath) {
        this.pause();
        this.stream(filePath, a.START);
    }

    public void pause() {
        this.notifyOnStopListeners();
        this.doAction(a.PAUSE);
    }

    public void release() {
        this.filePath = null;
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    private void doAction(a action) {
        switch (action) {
            case START: {
                if (this.mediaPlayer.isPlaying()) break;
                this.mediaPlayer.start();
                break;
            }
            case PAUSE: {
                if (this.mediaPlayer == null || !this.mediaPlayer.isPlaying()) break;
                this.mediaPlayer.pause();
                break;
            }
            case GET_DURATION: {
                this.onGetDurationListener.a(this.mediaPlayer.getDuration());
            }
        }
    }

    public static String getFormattedDurationText(long durationInMillis) {
        int n = 3600000;
        int n2 = 60000;
        int n3 = 1000;
        int n4 = (int)(durationInMillis / 3600000L);
        int n5 = (int)(durationInMillis % 3600000L / 60000L);
        int n6 = (int)(durationInMillis % 60000L / 1000L);
        if (n4 > 0) {
            return String.format("%02d:%02d:%02d", n4, n5, n6);
        }
        return String.format("%02d:%02d", n5, n6);
    }

    public static abstract class OnStopListener {
        private String filePath;

        public String getFilePath() {
            return this.filePath;
        }

        public OnStopListener(String filePath) {
            this.filePath = filePath;
        }

        public abstract void onStop();
    }

    public static interface b {
        public void a(int var1);
    }

    static enum a {
        START,
        PAUSE,
        GET_DURATION;

    }
}

