/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.device;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugDeviceProperties {
    public static final String TAG = "InstabugDeviceProperties";

    public static String getAppVersion(Context context) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(TAG, "failed to get app version", nameNotFoundException);
        }
        String string2 = String.format("%s (%s)", packageInfo.versionName, packageInfo.versionCode);
        return string2;
    }

    public static String getAppVersionName(Context context) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(TAG, "failed to get app version", nameNotFoundException);
        }
        String string2 = packageInfo.versionName;
        return string2;
    }

    public static String getPackageName(Context context) {
        String string2;
        try {
            string2 = context.getApplicationInfo().packageName;
        }
        catch (Exception exception) {
            string2 = "Could not get information";
            InstabugSDKLogger.e(TAG, "failed to get package name", exception);
        }
        return string2;
    }

    public static String getDeviceType() {
        return Build.MANUFACTURER + " " + Build.MODEL;
    }

    public static int getCurrentOSLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean checkRingerIsOn(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            return audioManager.getRingerMode() == 2;
        }
        return true;
    }

    public static boolean isFirstInstall(Context context) {
        try {
            long l = context.getPackageManager().getPackageInfo((String)InstabugDeviceProperties.getPackageName((Context)context), (int)0).firstInstallTime;
            long l2 = context.getPackageManager().getPackageInfo((String)InstabugDeviceProperties.getPackageName((Context)context), (int)0).lastUpdateTime;
            return l == l2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return true;
        }
    }
}

