/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.memory.predicate;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.instabug.library.util.memory.predicate.MemoryAvailablePredicate;
import io.reactivex.annotations.Nullable;
import java.io.File;
import java.util.Arrays;

public class BitmapMemoryAvailablePredicate
extends MemoryAvailablePredicate {
    private final Bitmap.Config a;
    @Size(value=2L)
    private final int[] b;

    public BitmapMemoryAvailablePredicate(@NonNull Uri uri) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)new File(uri.getPath()).getAbsolutePath(), (BitmapFactory.Options)options);
        this.a = null;
        this.b = new int[]{options.outHeight, options.outWidth};
    }

    public BitmapMemoryAvailablePredicate(@Nullable Bitmap.Config config, @Size(value=2L) int[] dimens) {
        this.a = config;
        this.b = Arrays.copyOf(dimens, 2);
    }

    @Override
    public boolean check() {
        long l = this.b[0] * this.b[1] * this.b();
        return this.isMemoryAvailable(l);
    }

    private int b() {
        if (this.a == null) {
            return 8;
        }
        switch (this.a) {
            case ALPHA_8: {
                return 1;
            }
            case RGB_565: {
                return 2;
            }
            case ARGB_4444: {
                return 2;
            }
            case ARGB_8888: {
                return 4;
            }
            case RGBA_F16: {
                return 8;
            }
        }
        return 8;
    }
}

