/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.support.annotation.IntRange;
import java.util.List;

public class StringUtility {
    public static final String ELLIPSIZE = "\u2026";

    public static String trimString(String s) {
        return StringUtility.trimString(s, 4096);
    }

    public static String trimString(String s, int limit) {
        if (s == null) {
            return "null";
        }
        if (s.length() > limit) {
            s = s.substring(0, limit);
        }
        return s;
    }

    public static String[] trimStrings(String[] strings) {
        for (int k = 0; k < strings.length; ++k) {
            strings[k] = StringUtility.trimString(strings[k]);
        }
        return strings;
    }

    public static boolean isNumeric(String s) {
        return s.matches("\\d+(?:\\.\\d+)?");
    }

    public static int compareVersion(String version1, String version2) throws NumberFormatException {
        String[] stringArray = version1.split("\\.");
        String[] stringArray2 = version2.split("\\.");
        for (int k = 0; k < stringArray.length || k < stringArray2.length; ++k) {
            if (k < stringArray.length && k < stringArray2.length) {
                if (Integer.parseInt(stringArray[k]) < Integer.parseInt(stringArray2[k])) {
                    return -1;
                }
                if (Integer.parseInt(stringArray[k]) <= Integer.parseInt(stringArray2[k])) continue;
                return 1;
            }
            if (k < stringArray.length) {
                if (Integer.parseInt(stringArray[k]) == 0) continue;
                return 1;
            }
            if (k >= stringArray2.length || Integer.parseInt(stringArray2[k]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static String removeExtension(String fileName) {
        return fileName.replaceFirst("[.][^.]+$", "");
    }

    public static String toCommaSeparated(List<String> strings) {
        StringBuilder stringBuilder = new StringBuilder();
        if (strings == null || strings.size() == 0) {
            return stringBuilder.toString();
        }
        for (int k = 0; k < strings.size() - 1; ++k) {
            stringBuilder.append(strings.get(k));
            stringBuilder.append(",");
        }
        stringBuilder.append(strings.get(strings.size() - 1));
        return stringBuilder.toString();
    }

    public static String applyDoubleQuotations(String s) {
        if (s == null || s.trim().length() == 0) {
            return s;
        }
        if (!s.startsWith("\"")) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    public static String ellipsize(String str, @IntRange(from=0L) int limit) {
        if (str != null && str.trim().length() > limit) {
            str = str.trim().substring(0, limit) + ELLIPSIZE;
        }
        return str;
    }
}

