/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.screenshot.ScreenshotTaker;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;

public class BitmapUtils {
    public static int getInMemoryByteSizeOfBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return 0;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static int getOnDiskByteSizeOfBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray().length;
    }

    public static Bitmap getBitmapFromFilePath(String filePath) {
        Uri uri = Uri.fromFile((File)new File(filePath));
        return BitmapUtils.getBitmapFromUri(uri);
    }

    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Bitmap bitmap = null;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
        }
        return bitmap;
    }

    public static void compressBitmapAndSave(@NonNull Context context, final @NonNull File originalImageFile) {
        if (context == null || originalImageFile == null) {
            return;
        }
        MemoryGuard.from(context).withPredicate(new MemoryNotLowPredicate()).doAction(new Action(){

            @Override
            public void onAffirmed() throws Throwable {
                BitmapUtils.compressBitmapAndSave(originalImageFile);
            }

            @Override
            public void onDenied() throws Throwable {
                InstabugSDKLogger.e(this, "Not enough memory for compressing image");
            }
        });
    }

    private static void compressBitmapAndSave(File originalImageFile) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(originalImageFile), null, (BitmapFactory.Options)options);
            int n = 900;
            int n2 = 1;
            while (options.outWidth / n2 / 2 >= 900 && options.outHeight / n2 / 2 >= 900) {
                n2 *= 2;
            }
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            options2.inSampleSize = n2;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(originalImageFile), null, (BitmapFactory.Options)options2);
            FileOutputStream fileOutputStream = new FileOutputStream(originalImageFile);
            bitmap.compress(BitmapUtils.getImageMimeType(originalImageFile), 100, (OutputStream)fileOutputStream);
            bitmap.recycle();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView);
        bitmapWorkerTask.execute(new String[]{localPath});
    }

    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, targetWidth, targetHeight);
        bitmapWorkerTask.execute(new String[]{localPath});
    }

    public static void loadBitmap(String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, onImageLoadedListener);
        bitmapWorkerTask.execute(new String[]{localPath});
    }

    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, targetWidth, targetHeight, onImageLoadedListener);
        bitmapWorkerTask.execute(new String[]{localPath});
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        int n = options.outHeight;
        int n2 = options.outWidth;
        int n3 = 1;
        int n4 = 500;
        int n5 = 500;
        if (n > n4 || n2 > n5) {
            int n6 = n / 2;
            int n7 = n2 / 2;
            while (n6 / n3 >= n4 && n7 / n3 >= n5) {
                n3 *= 2;
            }
        }
        return n3;
    }

    public static void saveBitmapAsPNG(final Bitmap bitmap, final int quality, final File directory, final String fileNamePrefix, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file = new File(directory, fileNamePrefix + "_" + System.currentTimeMillis() + ".png");
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file.toString());
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    bitmap.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.close();
                    Uri uri = Uri.fromFile((File)file);
                    if (uri != null) {
                        callback.onSuccess(uri);
                    } else {
                        callback.onError(new Throwable("Uri equal null"));
                    }
                }
                catch (IOException iOException) {
                    callback.onError(iOException);
                }
            }
        });
    }

    public static void saveBitmap(final Bitmap bitmap, final Context context, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file = DiskUtils.getInstabugDirectory(context);
                File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.close();
                    final Uri uri = Uri.fromFile((File)file2);
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (uri != null) {
                                callback.onSuccess(uri);
                            } else {
                                callback.onError(new Throwable("Uri equal null"));
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    callback.onError(iOException);
                }
            }
        });
    }

    public static void saveDrawableBitmap(final Drawable drawable2, final File file, final OnSaveBitmapCallback callback) {
        if (drawable2 == null) {
            return;
        }
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file.getPath());
                try {
                    BitmapUtils.drawableToBitmap(drawable2, new a(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void a(Bitmap bitmap) {
                            FilterOutputStream filterOutputStream = null;
                            try {
                                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)filterOutputStream);
                            }
                            catch (IOException iOException) {
                                InstabugSDKLogger.e(this, "can't compress bitmap");
                            }
                            finally {
                                try {
                                    if (filterOutputStream != null) {
                                        filterOutputStream.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    InstabugSDKLogger.e(this, "can't close BufferedOutputStream");
                                }
                            }
                            Uri uri = Uri.fromFile((File)file);
                            if (uri != null) {
                                callback.onSuccess(uri);
                            } else {
                                callback.onError(new Throwable("Uri equal null"));
                            }
                        }
                    });
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    callback.onError(runtimeException);
                }
            }
        });
    }

    private static void drawableToBitmap(final Drawable drawable2, final a onBitmapReady) {
        Context context;
        Bitmap bitmap;
        if (drawable2 instanceof BitmapDrawable && (bitmap = (context = (BitmapDrawable)drawable2).getBitmap()) != null) {
            onBitmapReady.a(BitmapUtils.resizeBitmap(bitmap, 24.0f, 24.0f));
        }
        if ((context = Instabug.getApplicationContext()) != null) {
            int n = DisplayUtils.dpToPx(context.getResources(), 72);
            final int n2 = drawable2.getIntrinsicWidth();
            final int n3 = drawable2.getIntrinsicHeight();
            if (n2 <= n && n3 <= n) {
                final Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                final Canvas canvas = new Canvas(bitmap2);
                PoolProvider.postMainThreadTask(new Runnable(){

                    @Override
                    public void run() {
                        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        drawable2.draw(canvas);
                        PoolProvider.postBitmapTask(new Runnable(){

                            @Override
                            public void run() {
                                float[] fArray = BitmapUtils.getTargetDimensions(n2, n3);
                                onBitmapReady.a(BitmapUtils.resizeBitmap(bitmap2, fArray[0], fArray[1]));
                            }
                        });
                    }
                });
            }
        }
    }

    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        float f2 = 24.0f;
        float[] fArray = new float[]{24.0f, 24.0f};
        if (realHeight > realWidth) {
            fArray[0] = (float)realWidth / (float)realHeight * f2;
        } else if (realHeight < realWidth) {
            fArray[1] = (float)realHeight / (float)realWidth * f2;
        }
        return fArray;
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        if (bitmap == null) {
            return null;
        }
        if (targetWidth == 0.0f && targetHeight == 0.0f) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)targetWidth), (int)((int)targetHeight), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap.getWidth() < bitmap.getHeight() && targetWidth > targetHeight) {
            return bitmap;
        }
        if (bitmap.getWidth() > bitmap.getHeight() && targetWidth < targetHeight) {
            return bitmap;
        }
        Canvas canvas = new Canvas(bitmap2);
        Matrix matrix = new Matrix();
        if (bitmap.getWidth() < bitmap.getHeight()) {
            matrix.setScale(targetWidth / (float)bitmap.getWidth(), targetHeight / (float)bitmap.getHeight());
        } else {
            matrix.setScale(targetHeight / (float)bitmap.getHeight(), targetWidth / (float)bitmap.getWidth());
        }
        canvas.drawBitmap(bitmap, matrix, new Paint());
        return bitmap2;
    }

    public static void saveBitmap(final Bitmap bitmap, final Uri imageUri, final Context context, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                try {
                    final boolean bl = bitmap.compress(Bitmap.CompressFormat.PNG, 100, context.getContentResolver().openOutputStream(Uri.fromFile((File)new File(imageUri.getPath()))));
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (bl && callback != null) {
                                callback.onSuccess(null);
                            }
                        }
                    });
                }
                catch (FileNotFoundException fileNotFoundException) {
                    InstabugSDKLogger.e(BitmapUtils.class, fileNotFoundException.getMessage(), fileNotFoundException);
                }
            }
        });
    }

    public static void saveBitmap(final Bitmap bitmap, final File attachmentDirectory, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file = new File(attachmentDirectory, "frame_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(AttachmentsUtility.class, "video frame path: " + file.toString());
                try {
                    Bitmap bitmap2;
                    int n;
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    int n2 = n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
                    if (n > 640) {
                        bitmap2 = BitmapUtils.resizeBitmap(bitmap, 640);
                        bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                    } else {
                        bitmap2 = BitmapUtils.resizeBitmap(bitmap, 320);
                        bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                    }
                    bufferedOutputStream.close();
                    bitmap2 = Uri.fromFile((File)file);
                    if (bitmap2 != null) {
                        callback.onSuccess((Uri)bitmap2);
                    } else {
                        callback.onError(new Throwable("Uri equal null"));
                    }
                }
                catch (IOException iOException) {
                    callback.onError(iOException);
                }
            }
        });
    }

    private static Bitmap resizeBitmap(Bitmap image, int maxSize) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        if (n2 > n) {
            n2 = maxSize;
            n = maxSize / 2;
        } else {
            n = maxSize;
            n2 = maxSize / 2;
        }
        return Bitmap.createScaledBitmap((Bitmap)image, (int)n, (int)n2, (boolean)false);
    }

    public static void maskBitmap(Bitmap bitmap, SettingsManager settingsManager, @Nullable Canvas canvas) {
        if (canvas == null) {
            canvas = new Canvas(bitmap);
        }
        Collection<WeakReference<View>> collection = settingsManager.getPrivateViews();
        HashSet<WeakReference<View>> hashSet = new HashSet<WeakReference<View>>();
        for (WeakReference<View> weakReference : collection) {
            if (weakReference != null && weakReference.get() != null) {
                View view = (View)weakReference.get();
                if (view == null || !ScreenshotTaker.isVisible(view)) continue;
                int[] nArray = new int[2];
                view.getLocationOnScreen(nArray);
                canvas.drawRect(ScreenshotTaker.getVisibleRect(view), new Paint());
                continue;
            }
            hashSet.add(weakReference);
        }
        SettingsManager.getInstance().getPrivateViews().removeAll(hashSet);
    }

    static interface a {
        public void a(Bitmap var1);
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

