/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.instabug.library.Instabug;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class InstabugDeprecationLogger {
    private static final String PREFIX_SECTION = "#section-";
    @VisibleForTesting
    static String baseUrl = "https://docs.instabug.com/docs/android-sdk-8-6-migration-guide";
    private static InstabugDeprecationLogger INSTANCE;

    private InstabugDeprecationLogger() {
    }

    public static InstabugDeprecationLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugDeprecationLogger();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    static void tearDown() {
        INSTANCE = null;
    }

    private static void setBaseUrl(String baseUrl) {
        if (baseUrl != null && baseUrl.trim().length() > 0) {
            InstabugDeprecationLogger.baseUrl = baseUrl;
        }
    }

    public void log(int section) {
        Context context;
        if (Instabug.isBuilt() && Instabug.isEnabled() && (context = Instabug.getApplicationContext()) != null) {
            boolean bl;
            boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
            if (bl && (section == 19 || section == 18)) {
                Log.i((String)"INSTABUG", (String)("\n\nIn this release, we\u2019re improving the in-app communication experience. Now, your end user will have a unified experience while sending you a report independently from its type. Whether it is a bug, improvement, or question, they\u2019ll see the same experience.\n\nThe Chats class and its methods have been deprecated, and while they still function, they will be completely removed in a future release. For more details about this API\u2019s replacement, check the docs here: " + this.getMigrationPageUrl(section) + ".\n\nIf you have any questions please reach out to us through contactus@instabug.com."));
            }
        }
    }

    public void log(String message) {
        Context context;
        if (Instabug.isBuilt() && Instabug.isEnabled() && (context = Instabug.getApplicationContext()) != null) {
            boolean bl;
            boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
            if (bl) {
                Log.i((String)"INSTABUG", (String)message);
            }
        }
    }

    @VisibleForTesting
    String getMigrationPageUrl() {
        return baseUrl;
    }

    @VisibleForTesting
    String getMigrationPageUrl(int section) {
        return baseUrl + PREFIX_SECTION + this.getSection(section);
    }

    private String getSection(int section) {
        switch (section) {
            case 18: {
                return "show";
            }
            case 19: {
                return "setstate";
            }
        }
        return "";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MigrationSection {
        public static final int METHOD_SHOW_CHATS = 18;
        public static final int METHOD_SET_CHATS_STATE = 19;
    }
}

