/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library._InstabugActivity;
import com.instabug.library.broadcast.a;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.StatusBarUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@TargetApi(value=21)
@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public class RequestPermissionActivity
extends AppCompatActivity
implements _InstabugActivity,
a.a {
    private static final int CREATE_SCREEN_CAPTURE = 2020;
    private static final int REQUEST_SCREEN_RECORDING_MIC_PERMISSION = 2022;
    public static final int REQUEST_MEDIA_PROJECTION_PERMISSION = 2030;
    private static final int CREATE_SCREENSHOT = 101;
    protected static final String KEY_IS_VIDEO = "isVideo";
    protected static final String KEY_IS_INITIAL = "isInitial";
    public static final String KEY_IS_PERMISSION_GRANDTED = "isPermissionGranted";
    private a sdkInvokedBroadcast = new a(this);
    boolean isVideo = true;
    boolean isInitial = true;
    static ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            StatusBarUtils.darkenStatusBarColor((Activity)this, Instabug.getPrimaryColor());
        }
        if (savedInstanceState == null) {
            MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
            this.isVideo = this.getIntent().getBooleanExtra(KEY_IS_VIDEO, true);
            this.isInitial = this.getIntent().getBooleanExtra(KEY_IS_INITIAL, true);
            Intent intent = mediaProjectionManager.createScreenCaptureIntent();
            if (this.isVideo) {
                if (SettingsManager.getInstance().getAutoScreenRecordingAudioCapturingState() == Feature.State.ENABLED) {
                    this.requestAudioRecordingPermission();
                } else {
                    this.requestScreenRecording();
                }
            } else {
                this.startActivityForResult(intent, 101);
            }
        }
    }

    private void requestScreenRecording() {
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
        Intent intent = mediaProjectionManager.createScreenCaptureIntent();
        this.startActivityForResult(intent, 2020);
    }

    private void requestAudioRecordingPermission() {
        boolean bl;
        boolean bl2 = bl = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.RECORD_AUDIO") == 0;
        if (!bl) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.RECORD_AUDIO"}, (int)2022);
        } else {
            this.requestScreenRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == 2020) {
                if (resultCode == -1) {
                    this.startService(ScreenRecordingService.a((Context)this, resultCode, data, false));
                } else if (resultCode == 0) {
                    SettingsManager.getInstance().setAutoScreenRecordingDenied(true);
                    ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(0, null));
                }
            } else if (requestCode == 101) {
                if (resultCode == -1) {
                    SettingsManager.getInstance().setProcessingForeground(true);
                    if (!this.isInitial) {
                        Intent intent = new Intent();
                        intent.putExtra(KEY_IS_PERMISSION_GRANDTED, true);
                        this.setResult(2030, intent);
                    }
                    com.instabug.library.screenshot.a.a.a(resultCode, data, this.isInitial, screenshotCapturingListener);
                } else if (screenshotCapturingListener != null) {
                    screenshotCapturingListener.onScreenshotCapturingFailed(new Exception("User declined media-projection permission"));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.finish();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            switch (requestCode) {
                case 2022: {
                    this.requestScreenRecording();
                    break;
                }
                default: {
                    super.onRequestPermissionsResult(requestCode, permissions, grantResults);
                    break;
                }
            }
        } else if (requestCode == 2022) {
            this.requestScreenRecording();
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    @Override
    public void onSDKInvoked(boolean isInvoked) {
        if (isInvoked) {
            this.finish();
        }
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.sdkInvokedBroadcast, new IntentFilter("SDK invoked"));
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.sdkInvokedBroadcast);
    }

    protected void onStart() {
        super.onStart();
        SettingsManager.getInstance().setRequestPermissionScreenShown(true);
    }

    protected void onStop() {
        super.onStop();
        SettingsManager.getInstance().setRequestPermissionScreenShown(false);
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        screenshotCapturingListener = null;
    }
}

