/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics.model;

import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SDKEvent {
    private static final String KEY_TIME_STAMP = "time_stamp";
    private static final String KEY_EVENT_NAME = "event_name";
    private static final String KEY_EXTRA_ATTRIBUTES = "extra_attributes";
    private long timeStamp;
    private String eventName;
    private ArrayList<ExtraAttribute> extraAttributes;

    public String getEventName() {
        return this.eventName;
    }

    public SDKEvent setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public SDKEvent setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public ArrayList<ExtraAttribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public SDKEvent setExtraAttributes(ArrayList<ExtraAttribute> extraAttributes) {
        this.extraAttributes = extraAttributes;
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_TIME_STAMP, this.getTimeStamp()).put(KEY_EVENT_NAME, (Object)this.getEventName()).put(KEY_EXTRA_ATTRIBUTES, (Object)ExtraAttribute.toJson(this.getExtraAttributes()));
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public static JSONArray toJson(ArrayList<SDKEvent> sdkEvents) {
        JSONArray jSONArray = new JSONArray();
        for (SDKEvent sDKEvent : sdkEvents) {
            jSONArray.put((Object)sDKEvent.toJson());
        }
        return jSONArray;
    }

    public static class ExtraAttribute {
        private static final String KEY_KEY = "key";
        private static final String KEY_VALUE = "value";
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public ExtraAttribute setKey(String key) {
            this.key = key;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public ExtraAttribute setValue(String value) {
            this.value = value;
            return this;
        }

        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(KEY_KEY, (Object)this.getKey()).put(KEY_VALUE, (Object)this.getValue());
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
            }
            return jSONObject;
        }

        public static ExtraAttribute fromJson(JSONObject extraAttributeJsonObject) {
            ExtraAttribute extraAttribute = new ExtraAttribute();
            try {
                if (extraAttributeJsonObject.has(KEY_KEY)) {
                    extraAttribute.setKey(extraAttributeJsonObject.getString(KEY_KEY));
                }
                if (extraAttributeJsonObject.has(KEY_VALUE)) {
                    extraAttribute.setValue(extraAttributeJsonObject.getString(KEY_VALUE));
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
            }
            return extraAttribute;
        }

        public static JSONArray toJson(ArrayList<ExtraAttribute> extraAttributes) {
            JSONArray jSONArray = new JSONArray();
            for (ExtraAttribute extraAttribute : extraAttributes) {
                jSONArray.put((Object)extraAttribute.toJson());
            }
            return jSONArray;
        }

        public static ArrayList<ExtraAttribute> fromJson(JSONArray extraAttributeJJsonArray) {
            ArrayList<ExtraAttribute> arrayList = new ArrayList<ExtraAttribute>();
            for (int k = 0; k < extraAttributeJJsonArray.length(); ++k) {
                try {
                    arrayList.add(ExtraAttribute.fromJson(extraAttributeJJsonArray.getJSONObject(k)));
                    continue;
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
                }
            }
            return arrayList;
        }
    }
}

