/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.instabug.library.R;
import com.instabug.library.util.InstabugSDKLogger;

public abstract class InstabugBaseFragment
extends Fragment {
    private View view;
    private Activity activity;
    private boolean isStateRestored;

    @LayoutRes
    protected abstract int getLayout();

    protected abstract String getTitle();

    protected abstract void consumeNewInstanceSavedArguments();

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.activity = activity;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        InstabugSDKLogger.v((Object)this, "onCreateView called");
        if (this.getArguments() != null) {
            InstabugSDKLogger.v((Object)this, "Arguments found, calling consumeNewInstanceSavedArguments with " + this.getArguments());
            this.consumeNewInstanceSavedArguments();
        }
        this.isStateRestored = false;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        InstabugSDKLogger.v((Object)this, "onCreateView called");
        this.view = inflater.inflate(this.getLayout(), container, false);
        this.setTitle(this.getTitle());
        return this.view;
    }

    protected abstract void restoreState(Bundle var1);

    public void onViewCreated(View view, Bundle savedInstanceState) {
        InstabugSDKLogger.v((Object)this, "onViewCreated called");
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            InstabugSDKLogger.v((Object)this, "savedInstanceState found, calling restoreState");
            this.restoreState(savedInstanceState);
            this.isStateRestored = true;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        InstabugSDKLogger.v((Object)this, "onSaveInstanceState called, calling saveState");
        this.saveState(outState);
    }

    public void onPause() {
        super.onPause();
        InstabugSDKLogger.v((Object)this, "onPause called, calling saveState");
    }

    public void onResume() {
        super.onResume();
        InstabugSDKLogger.v((Object)this, "onResume called, calling saveState");
    }

    protected abstract void saveState(Bundle var1);

    public boolean isStateRestored() {
        return this.isStateRestored;
    }

    public Activity getPreservedActivity() {
        InstabugSDKLogger.v((Object)this, "Returning preserved activity " + this.activity);
        return this.activity;
    }

    public void setTitle(String title) {
        if (this.view == null) {
            InstabugSDKLogger.v((Object)this, "Calling setTitle before inflating the view! Ignoring call");
            return;
        }
        TextView textView = (TextView)this.view.findViewById(R.id.instabug_fragment_title);
        if (textView != null) {
            InstabugSDKLogger.v((Object)this, "Setting fragment title to \"" + title + "\"");
            textView.setText((CharSequence)title);
        } else {
            InstabugSDKLogger.v((Object)this, "instabug_fragment_title wasn't found, make sure your layout.xml contains it");
        }
    }
}

