/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import com.instabug.library.Instabug;
import com.instabug.library.R;

public class InstabugAlertDialog {
    public static void showAlertDialog(@NonNull Activity activity, String title, String message, String positiveButtonText, String negativeButtonText, DialogInterface.OnClickListener onPositiveClickListener, DialogInterface.OnClickListener onNegativeClickListener) {
        InstabugAlertDialog.showAlertDialog(activity, title, message, positiveButtonText, negativeButtonText, true, onPositiveClickListener, onNegativeClickListener);
    }

    public static void showAlertDialog(@NonNull Activity activity, String title, String message, String positiveButtonText, String negativeButtonText, boolean isCancelable, DialogInterface.OnClickListener onPositiveClickListener, DialogInterface.OnClickListener onNegativeClickListener) {
        AlertDialog alertDialog = InstabugAlertDialog.getAlertDialog((Context)activity, title, message, positiveButtonText, negativeButtonText, isCancelable, onPositiveClickListener, onNegativeClickListener);
        if (!activity.isFinishing()) {
            alertDialog.show();
        }
    }

    public static AlertDialog getAlertDialog(@NonNull Context context, String title, String message, String positiveButtonText, String negativeButtonText, boolean isCancelable, DialogInterface.OnClickListener onPositiveClickListener, DialogInterface.OnClickListener onNegativeClickListener) {
        final AlertDialog alertDialog = new AlertDialog.Builder(context, R.style.InstabugDialogStyle).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)positiveButtonText, onPositiveClickListener).setNegativeButton((CharSequence)negativeButtonText, onNegativeClickListener).create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                alertDialog.getButton(-1).setTextColor(Instabug.getPrimaryColor());
                alertDialog.getButton(-2).setTextColor(Instabug.getPrimaryColor());
            }
        });
        alertDialog.setCancelable(isCancelable);
        return alertDialog;
    }
}

