/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.a.b;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.reactivex.disposables.Disposable;
import io.reactivex.observers.DisposableObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static LinkedHashMap<String, a> currentDownloadingFiles = new LinkedHashMap();

    public static com.instabug.library.internal.storage.cache.a getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new com.instabug.library.internal.storage.cache.a(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        return (com.instabug.library.internal.storage.cache.a)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    public static AssetEntity createEmptyEntity(Context context, String fileUrl, AssetEntity.AssetType assetType) {
        File file = new File(AssetsCacheManager.getCashDirectory(context), String.valueOf(fileUrl.hashCode()));
        return new AssetEntity(String.valueOf(fileUrl.hashCode()), assetType, fileUrl, file);
    }

    public static void getAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        com.instabug.library.internal.storage.cache.a a2 = AssetsCacheManager.getCache();
        AssetEntity assetEntity2 = a2 != null ? (AssetEntity)a2.get(assetEntity.getKey()) : null;
        if (assetEntity2 != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            onDownloadFinished.onSuccess(assetEntity2);
        } else if (AssetsCacheManager.isDownloading(assetEntity.getKey())) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(assetEntity, onDownloadFinished);
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(context, assetEntity, onDownloadFinished);
        }
    }

    public static void downloadAssetEntity(Context context, final AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        a a2 = new a();
        a2.a(assetEntity);
        List<OnDownloadFinished> list = a2.c();
        list.add(onDownloadFinished);
        a2.a(list);
        DisposableObserver<RequestResponse> disposableObserver = b.a().a(context, assetEntity, new Request.Callbacks<AssetEntity, Throwable>(){

            public void a(AssetEntity assetEntity2) {
                AssetsCacheManager.addAssetEntity(assetEntity2);
                AssetsCacheManager.notifyDownloadFinishedSuccessfully(assetEntity2);
            }

            public void a(Throwable throwable) {
                InstabugSDKLogger.e(this, "downloading asset entity got error: ", throwable);
                AssetsCacheManager.notifyDownloadFailed(assetEntity, throwable);
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Throwable)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((AssetEntity)object);
            }
        });
        a2.a((Disposable)disposableObserver);
        currentDownloadingFiles.put(a2.b().getKey(), a2);
    }

    public static void addAssetEntity(AssetEntity assetEntity) {
        com.instabug.library.internal.storage.cache.a a2 = AssetsCacheManager.getCache();
        if (a2 != null) {
            a2.put(assetEntity.getKey(), assetEntity);
        }
    }

    public static boolean isDownloading(String key) {
        return currentDownloadingFiles.get(key) != null;
    }

    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        List<OnDownloadFinished> list = currentDownloadingFiles.get(assetEntity.getKey()).c();
        list.add(onDownloadFinished);
        currentDownloadingFiles.get(assetEntity.getKey()).a(list);
    }

    public static void notifyDownloadFinishedSuccessfully(AssetEntity assetEntity) {
        for (OnDownloadFinished onDownloadFinished : currentDownloadingFiles.get(assetEntity.getKey()).c()) {
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onSuccess(assetEntity);
            currentDownloadingFiles.remove(assetEntity.getKey());
        }
    }

    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable error) {
        for (OnDownloadFinished onDownloadFinished : currentDownloadingFiles.get(assetEntity.getKey()).c()) {
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onFailed(error);
            currentDownloadingFiles.remove(assetEntity.getKey());
        }
    }

    public static void stopRunningDownloads() {
        for (Map.Entry<String, a> entry : currentDownloadingFiles.entrySet()) {
            entry.getValue().a().dispose();
        }
        currentDownloadingFiles.clear();
    }

    public static void clearRedundantFiles(Context context) {
        try {
            File[] fileArray = AssetsCacheManager.getCashDirectory(context).listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                file.delete();
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(AssetsCacheManager.class, exception.getMessage(), exception);
        }
    }

    public static void cleanUpCache(Context context) {
        Cache cache;
        AssetsCacheManager.stopRunningDownloads();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context);
    }

    public static File getCashDirectory(Context context) {
        String string2;
        if (Environment.getExternalStorageState().equals("mounted") && context.getExternalCacheDir() != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            string2 = context.getExternalCacheDir().getPath();
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            string2 = context.getCacheDir().getAbsolutePath();
        }
        File file = new File(string2 + "/instabug/assetCache");
        if (!file.exists()) {
            boolean bl = file.mkdirs();
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + bl);
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class a {
        public AssetEntity a;
        public Disposable b;
        public List<OnDownloadFinished> c = new ArrayList<OnDownloadFinished>();

        public a a(AssetEntity assetEntity) {
            this.a = assetEntity;
            return this;
        }

        public Disposable a() {
            return this.b;
        }

        public a a(List<OnDownloadFinished> list) {
            this.c = list;
            return this;
        }

        public AssetEntity b() {
            return this.a;
        }

        public a a(Disposable disposable) {
            this.b = disposable;
            return this;
        }

        public List<OnDownloadFinished> c() {
            return this.c;
        }
    }
}

