/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.webkit.MimeTypeMap;
import com.instabug.library.internal.storage.cache.Cacheable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment
implements Cacheable,
Serializable {
    static final String KEY_NAME = "name";
    static final String KEY_LOCALE_PATH = "local_path";
    static final String KEY_URL = "url";
    static final String KEY_TYPE = "type";
    static final String KEY_ATTACHMENT_STATE = "attachment_state";
    static final String KEY_VIDEO_ENCODED = "video_encoded";
    static final String KEY_DURATION = "duration";
    static final String KEY_ENCRYPTED = "isEncrypted";
    private long id = -1L;
    private String name;
    private String localPath;
    private String url;
    private Type type;
    private AttachmentState attachmentState;
    private boolean isVideoEncoded = false;
    private String duration;
    private boolean isEncrypted = false;
    private boolean shouldAnimate = true;

    public Attachment() {
        this.setType(Type.NOT_AVAILABLE);
        this.setAttachmentState(AttachmentState.NOT_AVAILABLE);
    }

    public static JSONArray toJson(List<Attachment> attachments) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int k = 0; k < attachments.size(); ++k) {
            jSONArray.put((Object)new JSONObject(attachments.get(k).toJson()));
        }
        return jSONArray;
    }

    public static List<Attachment> fromJson(JSONArray attachmentsJsonArray) throws JSONException {
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (int k = 0; k < attachmentsJsonArray.length(); ++k) {
            Attachment attachment = new Attachment();
            attachment.fromJson(attachmentsJsonArray.getJSONObject(k).toString());
            arrayList.add(attachment);
        }
        return arrayList;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    public String getName() {
        return this.name;
    }

    public Attachment setName(String name) {
        this.name = name;
        return this;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public Attachment setLocalPath(String localPath) {
        this.localPath = localPath;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Attachment setUrl(String url) {
        this.url = url;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Attachment setType(Type type) {
        this.type = type;
        return this;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    public void setShouldAnimate(boolean shouldAnimate) {
        this.shouldAnimate = shouldAnimate;
    }

    public boolean isVideoEncoded() {
        return this.isVideoEncoded;
    }

    public Attachment setVideoEncoded(boolean videoEncoded) {
        this.isVideoEncoded = videoEncoded;
        return this;
    }

    public String getFileType() {
        String string2 = MimeTypeMap.getFileExtensionFromUrl((String)this.getName());
        if (string2 != null && !string2.equals("")) {
            String string3 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            return string3 != null && !string3.equals("") ? string3 : this.getType().toString();
        }
        return this.getType().toString();
    }

    public AttachmentState getAttachmentState() {
        return this.attachmentState;
    }

    public Attachment setAttachmentState(AttachmentState attachmentState) {
        this.attachmentState = attachmentState;
        return this;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.isEncrypted = encrypted;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_NAME, (Object)this.getName()).put(KEY_LOCALE_PATH, (Object)this.getLocalPath()).put(KEY_URL, (Object)this.getUrl()).put(KEY_TYPE, (Object)this.getType().toString()).put(KEY_ATTACHMENT_STATE, (Object)this.getAttachmentState().toString()).put(KEY_VIDEO_ENCODED, this.isVideoEncoded()).put(KEY_ENCRYPTED, this.isEncrypted()).put(KEY_DURATION, (Object)this.getDuration());
        return jSONObject.toString();
    }

    @Override
    public void fromJson(String attachmentAsJson) throws JSONException {
        JSONObject jSONObject = new JSONObject(attachmentAsJson);
        if (jSONObject.has(KEY_NAME)) {
            this.setName(jSONObject.getString(KEY_NAME));
        }
        if (jSONObject.has(KEY_LOCALE_PATH)) {
            this.setLocalPath(jSONObject.getString(KEY_LOCALE_PATH));
        }
        if (jSONObject.has(KEY_URL)) {
            this.setUrl(jSONObject.getString(KEY_URL));
        }
        if (jSONObject.has(KEY_TYPE)) {
            this.setType(Type.get(jSONObject.getString(KEY_TYPE)));
        }
        if (jSONObject.has(KEY_ATTACHMENT_STATE)) {
            this.setAttachmentState(AttachmentState.valueOf(jSONObject.getString(KEY_ATTACHMENT_STATE)));
        }
        if (jSONObject.has(KEY_VIDEO_ENCODED)) {
            this.setVideoEncoded(jSONObject.getBoolean(KEY_VIDEO_ENCODED));
        }
        if (jSONObject.has(KEY_DURATION)) {
            this.setDuration(jSONObject.getString(KEY_DURATION));
        }
        if (jSONObject.has(KEY_ENCRYPTED)) {
            this.setEncrypted(jSONObject.getBoolean(KEY_ENCRYPTED));
        }
    }

    public String toString() {
        return "Name: " + this.getName() + ", Local Path: " + this.getLocalPath() + ", Type: " + (Object)((Object)this.getType()) + ", Duration: " + this.getDuration() + ", Url: " + this.getUrl() + ", Attachment State: " + (Object)((Object)this.getAttachmentState());
    }

    public boolean equals(Object attachment) {
        if (attachment != null && attachment instanceof Attachment) {
            Attachment attachment2 = (Attachment)attachment;
            return String.valueOf(attachment2.getName()).equals(String.valueOf(this.getName())) && String.valueOf(attachment2.getLocalPath()).equals(String.valueOf(this.getLocalPath())) && String.valueOf(attachment2.getUrl()).equals(String.valueOf(this.getUrl())) && attachment2.getType() == this.getType() && attachment2.getAttachmentState() == this.getAttachmentState() && attachment2.isVideoEncoded() == this.isVideoEncoded() && String.valueOf(attachment2.getDuration()).equals(String.valueOf(this.getDuration()));
        }
        return false;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return -1;
    }

    public static enum AttachmentState {
        OFFLINE,
        SYNCED,
        NOT_AVAILABLE;

    }

    public static enum Type {
        MAIN_SCREENSHOT("main-screenshot"),
        AUDIO("audio"),
        EXTRA_IMAGE("extra_image"),
        EXTRA_VIDEO("extra_video"),
        GALLERY_IMAGE("image_gallery"),
        GALLERY_VIDEO("video_gallery"),
        ATTACHMENT_FILE("attachment-file"),
        VIEW_HIERARCHY("view-hierarchy-v2"),
        NOT_AVAILABLE("not-available"),
        VISUAL_USER_STEPS("user-repro-steps-v2"),
        AUTO_SCREEN_RECORDING_VIDEO("auto-screen-recording-v2");

        private final String name;
        private static final Map<String, Type> lookup;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Type get(String name) {
            Type type = lookup.get(name);
            return type == null ? NOT_AVAILABLE : type;
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }
    }
}

