/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ScaleImageView
extends ImageView
implements View.OnTouchListener {
    private Context mContext;
    private float MAX_SCALE = 5.0f;
    private Matrix mMatrix;
    private final float[] mMatrixValues = new float[9];
    private int mWidth;
    private int mHeight;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private float mScale;
    private float mMinScale;
    private float mPrevDistance;
    private boolean isScaling;
    private int mPrevMoveX;
    private int mPrevMoveY;
    private GestureDetector mDetector;

    public ScaleImageView(Context context, AttributeSet attr2) {
        super(context, attr2);
        this.mContext = context;
        this.initialize();
    }

    public ScaleImageView(Context context) {
        super(context);
        this.mContext = context;
        this.initialize();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.initialize();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.initialize();
    }

    private void initialize() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.mMatrix = new Matrix();
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            this.mIntrinsicWidth = drawable2.getIntrinsicWidth();
            this.mIntrinsicHeight = drawable2.getIntrinsicHeight();
            this.setOnTouchListener(this);
        }
        this.mDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e2) {
                ScaleImageView.this.maxZoomTo((int)e2.getX(), (int)e2.getY());
                ScaleImageView.this.cutting();
                return super.onDoubleTap(e2);
            }
        });
    }

    protected boolean setFrame(int l, int t, int r, int b2) {
        this.mWidth = r - l;
        this.mHeight = b2 - t;
        this.mMatrix.reset();
        int n = r - l;
        this.mScale = (float)n / (float)this.mIntrinsicWidth;
        int n2 = 0;
        int n3 = 0;
        if (this.mScale * (float)this.mIntrinsicHeight > (float)this.mHeight) {
            this.mScale = (float)this.mHeight / (float)this.mIntrinsicHeight;
            this.mMatrix.postScale(this.mScale, this.mScale);
            n3 = (r - this.mWidth) / 2;
            n2 = 0;
        } else {
            this.mMatrix.postScale(this.mScale, this.mScale);
            n2 = (b2 - this.mHeight) / 2;
            n3 = 0;
        }
        this.mMatrix.postTranslate((float)n3, (float)n2);
        this.setImageMatrix(this.mMatrix);
        this.mMinScale = this.mScale;
        this.zoomTo(this.mScale, this.mWidth / 2, this.mHeight / 2);
        this.cutting();
        return super.setFrame(l, t, r, b2);
    }

    protected float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    protected float getScale() {
        return this.getValue(this.mMatrix, 0);
    }

    public float getTranslateX() {
        return this.getValue(this.mMatrix, 2);
    }

    protected float getTranslateY() {
        return this.getValue(this.mMatrix, 5);
    }

    protected void maxZoomTo(int x, int y) {
        if (this.mMinScale != this.getScale() && this.getScale() - this.mMinScale > 0.1f) {
            float f2 = this.mMinScale / this.getScale();
            this.zoomTo(f2, x, y);
        } else {
            float f3 = this.MAX_SCALE / this.getScale();
            this.zoomTo(f3, x, y);
        }
    }

    public void zoomTo(float scale, int x, int y) {
        if (this.getScale() * scale < this.mMinScale) {
            return;
        }
        if (scale >= 1.0f && this.getScale() * scale > this.MAX_SCALE) {
            return;
        }
        this.mMatrix.postScale(scale, scale);
        this.mMatrix.postTranslate(-((float)this.mWidth * scale - (float)this.mWidth) / 2.0f, -((float)this.mHeight * scale - (float)this.mHeight) / 2.0f);
        this.mMatrix.postTranslate((float)(-(x - this.mWidth / 2)) * scale, 0.0f);
        this.mMatrix.postTranslate(0.0f, (float)(-(y - this.mHeight / 2)) * scale);
        this.setImageMatrix(this.mMatrix);
    }

    public void cutting() {
        int n = (int)((float)this.mIntrinsicWidth * this.getScale());
        int n2 = (int)((float)this.mIntrinsicHeight * this.getScale());
        if (this.getTranslateX() < (float)(-(n - this.mWidth))) {
            this.mMatrix.postTranslate(-(this.getTranslateX() + (float)n - (float)this.mWidth), 0.0f);
        }
        if (this.getTranslateX() > 0.0f) {
            this.mMatrix.postTranslate(-this.getTranslateX(), 0.0f);
        }
        if (this.getTranslateY() < (float)(-(n2 - this.mHeight))) {
            this.mMatrix.postTranslate(0.0f, -(this.getTranslateY() + (float)n2 - (float)this.mHeight));
        }
        if (this.getTranslateY() > 0.0f) {
            this.mMatrix.postTranslate(0.0f, -this.getTranslateY());
        }
        if (n < this.mWidth) {
            this.mMatrix.postTranslate((float)(this.mWidth - n) / 2.0f, 0.0f);
        }
        if (n2 < this.mHeight) {
            this.mMatrix.postTranslate(0.0f, (float)(this.mHeight - n2) / 2.0f);
        }
        this.setImageMatrix(this.mMatrix);
    }

    private float distance(float x0, float x1, float y0, float y1) {
        float f2 = x0 - x1;
        float f3 = y0 - y1;
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    private float dispDistance() {
        return (float)Math.sqrt(this.mWidth * this.mWidth + this.mHeight * this.mHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDetector.onTouchEvent(event)) {
            return true;
        }
        int n = event.getPointerCount();
        switch (event.getAction()) {
            case 0: 
            case 5: 
            case 261: {
                if (n >= 2) {
                    float f2;
                    this.mPrevDistance = f2 = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                    this.isScaling = true;
                    break;
                }
                this.mPrevMoveX = (int)event.getX();
                this.mPrevMoveY = (int)event.getY();
                break;
            }
            case 2: {
                if (n >= 2 && this.isScaling) {
                    float f3 = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                    float f4 = (f3 - this.mPrevDistance) / this.dispDistance();
                    this.mPrevDistance = f3;
                    f4 += 1.0f;
                    f4 *= f4;
                    this.zoomTo(f4, this.mWidth / 2, this.mHeight / 2);
                    this.cutting();
                    break;
                }
                if (this.isScaling) break;
                int n2 = this.mPrevMoveX - (int)event.getX();
                int n3 = this.mPrevMoveY - (int)event.getY();
                this.mPrevMoveX = (int)event.getX();
                this.mPrevMoveY = (int)event.getY();
                this.mMatrix.postTranslate((float)(-n2), (float)(-n3));
                this.cutting();
                break;
            }
            case 1: 
            case 6: 
            case 262: {
                if (event.getPointerCount() > 1) break;
                this.isScaling = false;
                break;
            }
        }
        return true;
    }

    public boolean onTouch(View v, MotionEvent event) {
        return super.onTouchEvent(event);
    }
}

