/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.WindowManager;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class FieldHelper {
    private static final String FIELD_NAME_WINDOW_MANAGER = "mWindowManager";
    private static final String FIELD_NAME_GLOBAL = "mGlobal";
    private static final String FIELD_NAME_ROOTS = "mRoots";
    private static final String FIELD_NAME_PARAMS = "mParams";
    private static final String FIELD_NAME_VIEW = "mView";

    private FieldHelper() {
    }

    public static List<RootViewInfo> getRootViews(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        WindowManager.LayoutParams[] layoutParamsArray;
        Object[] objectArray;
        Object object;
        Object object2;
        ArrayList<RootViewInfo> arrayList = new ArrayList<RootViewInfo>();
        try {
            Object object3 = Build.VERSION.SDK_INT >= 17 ? FieldHelper.getFieldValue(FIELD_NAME_GLOBAL, activity.getWindowManager()) : FieldHelper.getFieldValue(FIELD_NAME_WINDOW_MANAGER, activity.getWindowManager());
            object2 = FieldHelper.getFieldValue(FIELD_NAME_ROOTS, object3);
            object = FieldHelper.getFieldValue(FIELD_NAME_PARAMS, object3);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(FieldHelper.class, "Can't fine one of (WindowManager, rootObjects, paramsObject) field name so screenshot capturing failed", exception);
            return arrayList;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            objectArray = ((List)object2).toArray();
            List list = (List)object;
            layoutParamsArray = list.toArray(new WindowManager.LayoutParams[list.size()]);
        } else {
            objectArray = (Object[])object2;
            layoutParamsArray = (WindowManager.LayoutParams[])object;
        }
        for (int j = 0; j < objectArray.length; ++j) {
            try {
                View view = (View)FieldHelper.getFieldValue(FIELD_NAME_VIEW, objectArray[j]);
                boolean bl = false;
                if (ignoredViewsIds != null) {
                    for (int n : ignoredViewsIds) {
                        if (n != view.getId()) continue;
                        bl = true;
                    }
                }
                if (view.getVisibility() != 0 || bl) continue;
                arrayList.add(new RootViewInfo(view, layoutParamsArray[j]));
                continue;
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(FieldHelper.class, "Screenshot capturing failed in one of the viewRoots", exception);
            }
        }
        return arrayList;
    }

    private static Object getFieldValue(String fieldName, Object target) throws NoSuchFieldException, IllegalAccessException {
        Field field = fieldName.equals(FIELD_NAME_WINDOW_MANAGER) ? FieldHelper.findField(fieldName, target.getClass()) : target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }

    private static Field findField(String name, Class clazz) throws NoSuchFieldException {
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            for (Field field : clazz2.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException("Field: " + name + " is not found in class: " + clazz.toString());
    }
}

