/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;
import android.widget.ImageView;

public class DrawableUtils {
    public static void setColor(View view, int color2) {
        Drawable drawable2 = view.getBackground();
        if (drawable2 instanceof ShapeDrawable) {
            ((ShapeDrawable)drawable2).getPaint().setColor(color2);
        } else if (drawable2 instanceof GradientDrawable) {
            ((GradientDrawable)drawable2).setColor(color2);
        } else if (drawable2 instanceof ColorDrawable) {
            ((ColorDrawable)drawable2).setColor(color2);
        }
    }

    public static void setDrawableTintColor(ImageView imageView, int color2) {
        imageView.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    public static Drawable getRotateDrawable(final Drawable d2, final float angle) {
        Drawable[] drawableArray = new Drawable[]{d2};
        return new LayerDrawable(drawableArray){

            public void draw(Canvas canvas) {
                canvas.save();
                canvas.rotate(angle, (float)d2.getBounds().width() / 2.0f, (float)d2.getBounds().height() / 2.0f);
                super.draw(canvas);
                canvas.restore();
            }
        };
    }
}

