/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.settings;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.Log;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.b;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.model.Report;
import com.instabug.library.settings.a;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class SettingsManager {
    public static final boolean VERBOSE = false;
    private boolean DEBUG = false;
    public static final String INSTABUG_SHARED_PREF_NAME = "instabug";
    public static final int MAX_ASR_DURATION_IN_SECONDS = 180;
    public static final int MIN_ASR_DURATION_IN_SECONDS = 30;
    private static final String ASR_DURATION_ERROR_MSG_BELOW_MIN = "Auto screen recording duration should be in a range from 30 to 180 seconds. Falling back to %d seconds";
    private static SettingsManager settingsManager;

    private SettingsManager() {
    }

    public static void init(Context context) {
        settingsManager = new SettingsManager();
        com.instabug.library.settings.b.a(context);
        a.a();
    }

    public static synchronized SettingsManager getInstance() {
        if (settingsManager == null) {
            settingsManager = new SettingsManager();
        }
        return settingsManager;
    }

    public boolean isDebugEnabled() {
        return this.DEBUG;
    }

    public void setDebugEnabled(boolean isDebugEnabled) {
        this.DEBUG = isDebugEnabled;
    }

    public String getAppToken() {
        return com.instabug.library.settings.b.a().b();
    }

    public void setAppToken(String token) {
        com.instabug.library.settings.b.a().a(token);
    }

    public OnInvokeCallback getOnInvokeCallback() {
        return a.b().c();
    }

    public void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) {
        a.b().a(onInvokeCallback);
    }

    public OnSdkInvokedCallback getOnSdkInvokedCallback() {
        return a.b().d();
    }

    public Report.OnReportCreatedListener getOnReportCreatedListener() {
        return a.b().x();
    }

    public void setOnReportCreatedListener(Report.OnReportCreatedListener listener) {
        a.b().a(listener);
    }

    public void setOnSdkInvokedCallback(OnSdkInvokedCallback onSdkInvokedCallback) {
        a.b().a(onSdkInvokedCallback);
    }

    public String getUserData() {
        if (b.a().c(Feature.USER_DATA) == Feature.State.ENABLED) {
            return com.instabug.library.settings.b.a().p();
        }
        return "";
    }

    public void setUserData(String userData) {
        com.instabug.library.settings.b.a().g(userData);
    }

    public Locale getInstabugLocale(Context context) {
        return a.b().a(context);
    }

    public void setInstabugLocale(Locale instabugLocale) {
        a.b().a(instabugLocale);
    }

    public void addExtraAttachmentFile(Uri attachmentUri, String fileNameWithExtension) {
        a.b().a(attachmentUri, fileNameWithExtension);
    }

    public void addExtraAttachmentFile(byte[] data, String fileNameWithExtension) {
        a.b().a(AttachmentsUtility.getUriFromBytes(Instabug.getApplicationContext(), data, fileNameWithExtension), fileNameWithExtension);
    }

    public void clearExtraAttachmentFiles() {
        a.b().f();
    }

    public LinkedHashMap<Uri, String> getExtraAttachmentFiles() {
        return a.b().e();
    }

    @NonNull
    public String getIdentifiedUserEmail() {
        return com.instabug.library.settings.b.a().d();
    }

    public void setIdentifiedUserEmail(String identifiedUserEmail) {
        com.instabug.library.settings.b.a().c(identifiedUserEmail);
    }

    public boolean isDeviceRegistered() {
        return com.instabug.library.settings.b.a().e();
    }

    public void setIsDeviceRegistered(boolean registered) {
        com.instabug.library.settings.b.a().a(registered);
    }

    public boolean isFirstRun() {
        return com.instabug.library.settings.b.a().f();
    }

    public void setIsFirstRun(boolean isFirstRun) {
        com.instabug.library.settings.b.a().b(isFirstRun);
    }

    public Date getFirstRunAt() {
        return new Date(com.instabug.library.settings.b.a().g());
    }

    public void setFirstRunAt(long time) {
        com.instabug.library.settings.b.a().a(time);
    }

    @Deprecated
    public long getLastContactedAt() {
        return com.instabug.library.settings.b.a().h();
    }

    @Deprecated
    public void setLastContactedAt(long lastContactedAt) {
        com.instabug.library.settings.b.a().b(lastContactedAt);
    }

    public boolean isAppOnForeground() {
        return com.instabug.library.settings.b.a().i();
    }

    public void setIsAppOnForeground(boolean isAppOnForeground) {
        com.instabug.library.settings.b.a().c(isAppOnForeground);
    }

    public int getLastMigrationVersion() {
        return com.instabug.library.settings.b.a().j();
    }

    public void setLastMigrationVersion(int lastMigrationVersion) {
        com.instabug.library.settings.b.a().a(lastMigrationVersion);
    }

    public boolean isFirstDismiss() {
        return com.instabug.library.settings.b.a().k();
    }

    public void setIsFirstDismiss(boolean firstDismiss) {
        com.instabug.library.settings.b.a().d(firstDismiss);
    }

    public int getPrimaryColor() {
        return a.b().j();
    }

    public void setPrimaryColor(@ColorInt int primaryColorValue) {
        a.b().a(primaryColorValue);
        InvocationManager.getInstance().notifyPrimaryColorChanged();
    }

    public InstabugColorTheme getTheme() {
        return com.instabug.library.settings.b.a().l();
    }

    public void setTheme(InstabugColorTheme instabugTheme) {
        com.instabug.library.settings.b.a().a(instabugTheme);
    }

    public String getIdentifiedUsername() {
        return com.instabug.library.settings.b.a().c();
    }

    public void setIdentifiedUsername(String username) {
        com.instabug.library.settings.b.a().b(username);
    }

    public void setEnteredUsername(String enteredUsername) {
        com.instabug.library.settings.b.a().d(enteredUsername);
    }

    public String getEnteredUsername() {
        return com.instabug.library.settings.b.a().m();
    }

    public String getUuid() {
        return com.instabug.library.settings.b.a().n();
    }

    public void setUuid(String uuid) {
        com.instabug.library.settings.b.a().e(uuid);
    }

    public String getMD5Uuid() {
        return com.instabug.library.settings.b.a().o();
    }

    public void setMD5Uuid(String uuid) {
        com.instabug.library.settings.b.a().f(uuid);
    }

    public ArrayList<String> getTags() {
        return a.b().g();
    }

    public void addTags(String ... tags) {
        a.b().a(tags);
    }

    public void resetTags() {
        a.b().h();
    }

    public String getTagsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = a.b().g();
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            for (int j = 0; j < n; ++j) {
                stringBuilder.append(arrayList.get(j));
                if (j == n - 1) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    public long getSessionStartedAt() {
        return a.b().i();
    }

    public void setSessionStartedAt(long sessionStartedAt) {
        a.b().a(sessionStartedAt);
    }

    public InstabugCustomTextPlaceHolder getCustomPlaceHolders() {
        return a.b().k();
    }

    public void setCustomPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        a.b().a(instabugCustomTextPlaceHolder);
    }

    public boolean isUserLoggedOut() {
        return com.instabug.library.settings.b.a().q();
    }

    public void setUserLoggedOut(boolean isUserLoggedOut) {
        com.instabug.library.settings.b.a().e(isUserLoggedOut);
    }

    public boolean shouldMakeUUIDMigrationRequest() {
        return com.instabug.library.settings.b.a().r();
    }

    public void setShouldMakeUUIDMigrationRequest(boolean shouldMigrate) {
        com.instabug.library.settings.b.a().f(shouldMigrate);
    }

    public void setCurrentSDKVersion(String sdkVersion) {
        com.instabug.library.settings.b.a().h(sdkVersion);
    }

    public String getLastSDKVersion() {
        return com.instabug.library.settings.b.a().s();
    }

    public boolean isSDKVersionSet() {
        return com.instabug.library.settings.b.a().t();
    }

    public int getStatusBarColor() {
        return a.b().l();
    }

    public void setStatusBarColor(int statusBarColor) {
        a.b().b(statusBarColor);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        a.b().c(requestedOrientation);
    }

    public int getRequestedOrientation() {
        return a.b().m();
    }

    public void resetRequestedOrientation() {
        a.b().n();
    }

    public int getSessionsCount() {
        return com.instabug.library.settings.b.a().u();
    }

    public void incrementSessionsCount() {
        com.instabug.library.settings.b.a().v();
    }

    public boolean isPromptOptionsScreenShown() {
        return a.b().o();
    }

    public void setPromptOptionsScreenShown(boolean promptOptionsShown) {
        a.b().a(promptOptionsShown);
    }

    public boolean isRequestPermissionScreenShown() {
        return a.b().p();
    }

    public void setRequestPermissionScreenShown(boolean isRequestPermissionScreenShown) {
        a.b().b(isRequestPermissionScreenShown);
    }

    public OnSdkDismissedCallback getOnSdkDismissedCallback() {
        return a.b().q();
    }

    public void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) {
        a.b().a(onSdkDismissedCallback);
    }

    public void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
    }

    public boolean autoScreenRecordingEnabled() {
        return a.b().u();
    }

    public void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        a.b().d(autoScreenRecordingMaxDuration > 30000 ? 30000 : autoScreenRecordingMaxDuration);
    }

    public int autoScreenRecordingMaxDuration() {
        return a.b().v();
    }

    public boolean isScreenCurrentlyRecorded() {
        return a.b().s();
    }

    public void setScreenCurrentlyRecorded(boolean screenCurrentlyRecorded) {
        a.b().c(screenCurrentlyRecorded);
    }

    public boolean isAutoScreenRecordingDenied() {
        return a.b().t();
    }

    public void setAutoScreenRecordingDenied(boolean autoScreenRecordingDenied) {
        a.b().d(autoScreenRecordingDenied);
    }

    public void setReproStepsScreenshotEnabled(boolean enable) {
    }

    public boolean isReproStepsScreenshotEnabled() {
        return a.b().r();
    }

    public void setEnteredEmail(String enteredEmail) {
        com.instabug.library.settings.b.a().i(enteredEmail);
    }

    public String getEnteredEmail() {
        return com.instabug.library.settings.b.a().w();
    }

    public void setScreenshotByMediaProjectionEnabled(boolean enabled) {
        a.b().f(enabled);
    }

    public boolean isScreenshotByMediaProjectionEnabled() {
        return a.b().y();
    }

    public WelcomeMessage.State getWelcomeMessageState() {
        return WelcomeMessage.State.valueOf(com.instabug.library.settings.b.a().y());
    }

    public void setWelcomeMessageState(WelcomeMessage.State welcomeMessageState) {
        com.instabug.library.settings.b.a().a(welcomeMessageState);
    }

    public void setIsSessionEnabled(boolean enabled) {
        com.instabug.library.settings.b.a().g(enabled);
    }

    public boolean isSessionEnabled() {
        return com.instabug.library.settings.b.a().x();
    }

    public void setOnboardingShowing(boolean onboardingShowing) {
        a.b().e(onboardingShowing);
    }

    public boolean isOnboardingShowing() {
        return a.b().w();
    }

    public void setShouldAutoShowOnboarding(boolean shouldShowOnboarding) {
        com.instabug.library.settings.b.a().h(shouldShowOnboarding);
    }

    public boolean shouldAutoShowOnboarding() {
        return com.instabug.library.settings.b.a().z();
    }

    public boolean isProcessingForeground() {
        return a.b().z();
    }

    public void setProcessingForeground(boolean isProcessingForeground) {
        a.b().g(isProcessingForeground);
    }

    public void setAutoScreenRecordingDuration(int autoScreenRecordingMaxDuration) {
        if (autoScreenRecordingMaxDuration > 180) {
            Log.w((String)Instabug.class.getName(), (String)this.getASRError(autoScreenRecordingMaxDuration));
            a.b().d(this.convertSecondToMilliseconds(180));
            return;
        }
        if (autoScreenRecordingMaxDuration < 30) {
            Log.w((String)Instabug.class.getName(), (String)this.getASRError(autoScreenRecordingMaxDuration));
            a.b().d(this.convertSecondToMilliseconds(30));
            return;
        }
        a.b().d(autoScreenRecordingMaxDuration * 1000);
    }

    public void setAutoScreenRecordingAudioCapturingState(Feature.State asrAudioCapturingEnabled) {
        a.b().a(asrAudioCapturingEnabled);
    }

    public Feature.State getAutoScreenRecordingAudioCapturingState() {
        return a.b().A();
    }

    private String getASRError(int duration) {
        if (duration < 30) {
            return String.format(Locale.ENGLISH, ASR_DURATION_ERROR_MSG_BELOW_MIN, 30);
        }
        return String.format(Locale.ENGLISH, ASR_DURATION_ERROR_MSG_BELOW_MIN, 180);
    }

    private int convertSecondToMilliseconds(int seconds) {
        return (int)TimeUnit.MILLISECONDS.convert(seconds, TimeUnit.SECONDS);
    }

    public void setLastSeenTimestamp(long currentTimeMillis) {
        com.instabug.library.settings.b.a().c(currentTimeMillis);
    }

    public long getLastSeenTimestamp() {
        return com.instabug.library.settings.b.a().A();
    }
}

