/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.operation;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperationCallback;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class WriteStateToFileDiskOperation
implements DiskOperation<Uri, Context> {
    private final String stringState;
    private final File file;

    public WriteStateToFileDiskOperation(File file, String stringState) {
        this.stringState = stringState;
        this.file = file;
    }

    @Override
    public synchronized Uri execute(Context context) throws IOException {
        if (!this.file.createNewFile()) {
            throw new AssertionError((Object)"Unable to create new file, file already exists");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF8"));
        outputStreamWriter.write(this.stringState);
        outputStreamWriter.close();
        return Uri.fromFile((File)this.file);
    }

    @Override
    public void executeAsync(Context context, final @Nullable DiskOperationCallback<Uri> callback) {
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        this.a();
                    }
                    catch (Throwable throwable) {
                        InstabugSDKLogger.e(this, throwable.getClass().getSimpleName(), throwable);
                        if (callback == null) break block3;
                        callback.onFailure(throwable);
                    }
                }
                if (callback != null) {
                    callback.onSuccess(Uri.fromFile((File)WriteStateToFileDiskOperation.this.file));
                }
            }

            private void a() throws Throwable {
                if (!WriteStateToFileDiskOperation.this.file.createNewFile()) {
                    throw new AssertionError((Object)"Unable to create new file, file already exists");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(WriteStateToFileDiskOperation.this.file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF8"));
                outputStreamWriter.write(WriteStateToFileDiskOperation.this.stringState);
                outputStreamWriter.close();
            }
        });
    }
}

