/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.instabug.library.instacapture.c.a;
import com.instabug.library.instacapture.c.b;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    public static Bitmap getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        Bitmap bitmap;
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        View view = activity.getWindow().getDecorView();
        List<RootViewInfo> list = FieldHelper.getRootViews(activity, ignoredViewsIds);
        a.a("viewRoots count: " + list.size());
        try {
            bitmap = (long)(view.getWidth() * view.getHeight() * 4) < b.a((Context)activity) ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        catch (IllegalArgumentException | OutOfMemoryError throwable) {
            return null;
        }
        ScreenshotTaker.drawRootsToBitmap(list, bitmap, ignoredViewsIds);
        return bitmap;
    }

    private static void drawRootsToBitmap(List<RootViewInfo> viewRoots, Bitmap bitmap, @Nullable @IdRes int[] ignoredViewsIds) {
        for (RootViewInfo rootViewInfo : viewRoots) {
            ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap, ignoredViewsIds);
        }
    }

    private static void drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, @Nullable @IdRes int[] ignoredViewsIds) {
        View view;
        int n;
        Canvas canvas;
        if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
            canvas = new Canvas(bitmap);
            int n2 = (int)(255.0f * rootViewInfo.getLayoutParams().dimAmount);
            canvas.drawARGB(n2, 0, 0, 0);
        }
        canvas = new Canvas(bitmap);
        canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
        int[] nArray = null;
        if (ignoredViewsIds != null) {
            nArray = new int[ignoredViewsIds.length];
        }
        if (ignoredViewsIds != null) {
            for (n = 0; n < ignoredViewsIds.length; ++n) {
                view = rootViewInfo.getView().findViewById(ignoredViewsIds[n]);
                if (view == null) continue;
                nArray[n] = view.getVisibility();
                view.post(new Runnable(){

                    @Override
                    public void run() {
                        view.setVisibility(4);
                    }
                });
            }
        }
        rootViewInfo.getView().draw(canvas);
        ScreenshotTaker.drawUnDrawableViews(rootViewInfo.getView(), canvas);
        if (ignoredViewsIds != null) {
            for (n = 0; n < ignoredViewsIds.length; ++n) {
                view = rootViewInfo.getView().findViewById(ignoredViewsIds[n]);
                if (view == null) continue;
                final int[] nArray2 = nArray;
                final int n3 = n;
                view.post(new Runnable(){

                    @Override
                    public void run() {
                        view.setVisibility(nArray2[n3]);
                    }
                });
            }
        }
    }

    private static ArrayList<View> drawUnDrawableViews(View v, Canvas canvas) {
        if (!(v instanceof ViewGroup)) {
            ArrayList<View> arrayList = new ArrayList<View>();
            arrayList.add(v);
            return arrayList;
        }
        ArrayList<View> arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)v;
        for (int j = 0; j < viewGroup.getChildCount(); ++j) {
            View view = viewGroup.getChildAt(j);
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(v);
            arrayList2.addAll(ScreenshotTaker.drawUnDrawableViews(view, canvas));
            int[] nArray = new int[2];
            view.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT >= 14 && view instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view, nArray, canvas);
            }
            if (view instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view, nArray, canvas);
            }
            if (Build.VERSION.SDK_INT >= 11 && view instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view, canvas);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static void drawGLSurfaceView(GLSurfaceView surfaceView, int[] locationOnScreen, Canvas canvas) {
        a.a("Drawing GLSurfaceView");
        if (surfaceView.getWindowToken() != null) {
            final int n = surfaceView.getWidth();
            final int n2 = surfaceView.getHeight();
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray = new int[n * (0 + n2)];
            final IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.position(0);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            surfaceView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    eGL10.eglWaitGL();
                    GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    gL10.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    gL10.glReadPixels(0, 0, n, 0 + n2, 6408, 5121, (Buffer)intBuffer);
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            int[] nArray2 = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                for (int j = 0; j < n; ++j) {
                    int n5;
                    int n6 = nArray[n3 * n + j];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 << 16 & 0xFF0000;
                    nArray2[(n2 - n4 - 1) * n + j] = n5 = n6 & 0xFF00FF00 | n8 | n7;
                }
                ++n3;
                ++n4;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])nArray2, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap(bitmap, (float)locationOnScreen[0], (float)locationOnScreen[1], paint);
            bitmap.recycle();
        }
    }

    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] locationOnScreen, Canvas canvas) {
        a.a("Drawing TextureView");
        try {
            Bitmap bitmap = textureView.getBitmap();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                canvas.drawBitmap(bitmap, (float)locationOnScreen[0], (float)locationOnScreen[1], paint);
                bitmap.recycle();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(ScreenshotTaker.class, ScreenshotTaker.class.getSimpleName(), outOfMemoryError);
        }
    }

    @TargetApi(value=11)
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n = webView.getLayerType();
        if (n == 2) {
            webView.setLayerType(0, null);
            webView.setDrawingCacheEnabled(true);
            webView.buildDrawingCache(true);
            Bitmap bitmap = webView.getDrawingCache();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                webView.getLocationOnScreen(nArray);
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                bitmap.recycle();
            }
            webView.setDrawingCacheEnabled(false);
            webView.setLayerType(n, null);
        }
    }
}

