/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import java.util.Locale;

public class LocaleUtils {
    public static void setLocale(Activity activity, Locale locale) {
        Configuration configuration = activity.getApplicationContext().getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            configuration.setLocales(new LocaleList(new Locale[]{locale}));
            LocaleUtils.updateResources((Context)activity, locale);
        } else if (Build.VERSION.SDK_INT >= 17) {
            configuration.setLocale(locale);
        } else {
            configuration.locale = locale;
        }
        activity.getResources().updateConfiguration(configuration, activity.getResources().getDisplayMetrics());
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, Locale locale) {
        Locale.setDefault(locale);
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        configuration.setLayoutDirection(locale);
        return context.createConfigurationContext(configuration);
    }

    public static String getLocaleStringResource(Locale requestedLocale, int resourceId, Context context) {
        String string2;
        if (Build.VERSION.SDK_INT >= 17) {
            Configuration configuration = new Configuration(context.getResources().getConfiguration());
            configuration.setLocale(requestedLocale);
            string2 = context.createConfigurationContext(configuration).getText(resourceId).toString();
        } else {
            Resources resources = context.getResources();
            Configuration configuration = resources.getConfiguration();
            Locale locale = configuration.locale;
            configuration.locale = requestedLocale;
            resources.updateConfiguration(configuration, null);
            string2 = resources.getString(resourceId);
            configuration.locale = locale;
            resources.updateConfiguration(configuration, null);
        }
        return string2;
    }

    public static boolean isRTL(Locale locale) {
        if (Build.VERSION.SDK_INT >= 17) {
            return TextUtils.getLayoutDirectionFromLocale((Locale)locale) == 1;
        }
        byte by = Character.getDirectionality(locale.getDisplayName().charAt(0));
        return by == 1 || by == 2;
    }
}

