/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.b;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InstabugUserEventLogger {
    private static final long DELAY = 1L;
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 10000;
    private List<UserEvent> userEvents = new ArrayList<UserEvent>();
    private ConcurrentHashMap<String, Integer> userEventsCount = new ConcurrentHashMap();
    private ScheduledExecutorService insertionExecutor;

    private InstabugUserEventLogger() {
    }

    public static InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    public synchronized void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class), new Api.Parameter().setName("userEventParams").setType(UserEventParam.class));
        if (b.a().c(Feature.USER_EVENTS) == Feature.State.ENABLED) {
            UserEvent userEvent = new UserEvent().setEventIdentifier(eventIdentifier).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
            for (UserEventParam userEventParam : userEventParams) {
                userEvent.addParam(userEventParam);
            }
            if (this.userEvents.size() >= 10000) {
                this.userEvents.remove(0);
            }
            this.userEvents.add(userEvent);
            Object object = this.userEventsCount.get(eventIdentifier);
            if (object != null) {
                object = (Integer)object + 1;
                this.userEventsCount.put(eventIdentifier, (Integer)object);
            } else {
                this.userEventsCount.put(eventIdentifier, 1);
            }
            UserEventsEventBus.getInstance().post(userEvent);
        }
        this.runInsertionHandler();
    }

    private void runInsertionHandler() {
        if (this.insertionExecutor == null) {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : InstabugUserEventLogger.this.userEventsCount.entrySet()) {
                        InstabugUserEventLogger.this.incrementEventLoggingCount((String)entry.getKey(), (Integer)entry.getValue());
                    }
                    InstabugUserEventLogger.this.userEventsCount.clear();
                    InstabugUserEventLogger.this.insertionExecutor = null;
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userEventIdentifier").setType(String.class));
        return this.getEventLoggingCount(userEventIdentifier);
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    public void clearAll() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.delete("user_events_logs", null, null);
    }

    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy) {
        int n = this.getEventLoggingCount(eventIdentifier);
        boolean bl = n > 0;
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("event_identifier", eventIdentifier);
        contentValues.put("event_logging_count", Integer.valueOf(n += incrementBy));
        if (bl) {
            InstabugSDKLogger.d(this, "update: " + sQLiteDatabaseWrapper.update("user_events_logs", contentValues, "event_identifier=?", new String[]{eventIdentifier}));
        } else {
            InstabugSDKLogger.d(this, "insert: " + sQLiteDatabaseWrapper.insert("user_events_logs", null, contentValues));
        }
        sQLiteDatabaseWrapper.close();
    }

    private int getEventLoggingCount(@NonNull String eventIdentifier) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        Cursor cursor = sQLiteDatabaseWrapper.query("user_events_logs", new String[]{"event_logging_count"}, "event_identifier =?", new String[]{eventIdentifier}, null, null, null);
        int n = 0;
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            int n2 = cursor.getColumnIndex("event_logging_count");
            n = cursor.getInt(n2);
        }
        cursor.close();
        sQLiteDatabaseWrapper.close();
        return n;
    }
}

