/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d.a;
import com.instabug.library.d.b;
import com.instabug.library.internal.storage.cache.db.UserAttributesDbHelper;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.visualusersteps.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Instabug {
    private static Instabug INSTANCE = null;
    private static InstabugState INSTABUG_STATE = InstabugState.NOT_BUILT;
    private com.instabug.library.a delegate;

    private Instabug(@NonNull com.instabug.library.a delegate) {
        this.delegate = delegate;
    }

    static Instabug getInstance() throws IllegalStateException {
        if (INSTANCE == null) {
            throw new IllegalStateException("Instabug getInstance called before Instabug.Builder().build() was called");
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getApplicationContext() {
        return Instabug.getInstance().delegate.l();
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(isDebugEnabled));
        SettingsManager.getInstance().setDebugEnabled(isDebugEnabled);
    }

    public static int getPrimaryColor() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(primaryColorValue)));
        SettingsManager.getInstance().setPrimaryColor(primaryColorValue);
    }

    public static InstabugColorTheme getTheme() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getTheme();
    }

    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(fileUri, fileNameWithExtension);
    }

    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("data").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(data, fileNameWithExtension);
    }

    public static void clearFileAttachment() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().clearExtraAttachmentFiles();
    }

    public static String getUserData() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getUserData();
    }

    public static void setUserData(@NonNull String userData) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userData").setType(String.class));
        if (com.instabug.library.b.a().c(Feature.USER_DATA) == Feature.State.ENABLED) {
            userData = StringUtility.trimString(userData, 1000);
            SettingsManager.getInstance().setUserData(userData);
        }
    }

    public static String getUserEmail() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return com.instabug.library.user.a.b();
    }

    public static String getAppToken() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getAppToken();
    }

    public static void identifyUser(@NonNull String username, @NonNull String email) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("username").setType(String.class), new Api.Parameter().setName("email"));
        com.instabug.library.user.a.a(Instabug.getApplicationContext(), username, email);
    }

    public static void logoutUser() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.library.user.a.a();
    }

    public static void setState(InstabugState instabugState) {
        INSTABUG_STATE = instabugState;
    }

    public static InstabugState getState() {
        return INSTABUG_STATE;
    }

    public static boolean isBuilt() {
        return INSTANCE != null && Instabug.getState() != InstabugState.NOT_BUILT;
    }

    public static boolean isEnabled() {
        APIBuildChecker.check();
        return com.instabug.library.b.a().a(Feature.INSTABUG) && com.instabug.library.b.a().c(Feature.INSTABUG) == Feature.State.ENABLED;
    }

    public static void enable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (!Instabug.isEnabled()) {
            com.instabug.library.b.a().a(Feature.INSTABUG, true);
            com.instabug.library.b.a().a(Feature.INSTABUG, Feature.State.ENABLED);
            com.instabug.library.b.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.a();
        }
    }

    public static void disable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.isEnabled()) {
            com.instabug.library.b.a().a(Feature.INSTABUG, Feature.State.DISABLED);
            com.instabug.library.b.a().a(Feature.INSTABUG, false);
            com.instabug.library.b.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.h();
        }
    }

    public static void pauseSdk() throws IllegalStateException {
        APIBuildChecker.check();
        if (Instabug.isEnabled()) {
            Instabug.getInstance().delegate.i();
        }
    }

    public static void resumeSdk() throws IllegalStateException {
        APIBuildChecker.check();
        Instabug.getInstance().delegate.j();
    }

    public static void setLocale(Locale locale) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        SettingsManager.getInstance().setInstabugLocale(locale);
    }

    public static Locale getLocale(Context context) throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getInstabugLocale(context);
    }

    public static void addTags(String ... tags) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        tags = StringUtility.trimStrings(tags);
        SettingsManager.getInstance().addTags(tags);
    }

    public static ArrayList<String> getTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getTags();
    }

    public static void resetTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetTags();
    }

    @Deprecated
    public static boolean isInstabugNotification(Bundle data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("data").setType(Bundle.class));
        InstabugDeprecationLogger.getInstance().log(13);
        return a.a(data);
    }

    @Deprecated
    public static boolean isInstabugNotification(Map<String, String> data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Map.class));
        InstabugDeprecationLogger.getInstance().log(13);
        return a.a(data);
    }

    public static void setCustomTextPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class));
        SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder);
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return UserAttributesDbHelper.getAll();
    }

    public static void setUserAttribute(@NonNull String key, String value) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class), new Api.Parameter().setName("value").setType(String.class));
        value = StringUtility.trimString(value);
        UserAttributesDbHelper.insert(key, value);
    }

    @Nullable
    public static String getUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        return UserAttributesDbHelper.retrieve(key);
    }

    public static void removeUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        UserAttributesDbHelper.delete(key);
    }

    public static void clearAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        UserAttributesDbHelper.deleteAll();
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    @Deprecated
    public static void setShouldPlayConversationSounds(boolean shouldPlaySounds) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySounds").setType(Boolean.TYPE).setValue(shouldPlaySounds));
        a.b(shouldPlaySounds);
        InstabugDeprecationLogger.getInstance().log(17);
    }

    public static void setWelcomeMessageState(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(welcomeMessageState.toString()));
        SettingsManager.getInstance().setWelcomeMessageState(welcomeMessageState);
    }

    public static void showWelcomeMessage(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(welcomeMessageState.toString()));
        if (!InstabugCore.isForegroundBusy()) {
            Instabug.getInstance().delegate.a(welcomeMessageState);
        }
    }

    @Deprecated
    public static void setNotificationIcon(@DrawableRes int notificationIcon) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("notificationIcon").setType(Integer.TYPE));
        InstabugDeprecationLogger.getInstance().log(14);
        a.a(notificationIcon);
    }

    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.VIEW_HIERARCHY, state);
    }

    @Deprecated
    public static void setCrashReportingState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.CRASH_REPORTING, state);
        InstabugDeprecationLogger.getInstance().log(11);
    }

    @Deprecated
    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setAutoScreenRecordingEnabled").setType(Boolean.class).setValue(String.valueOf(autoScreenRecordingEnabled)));
        SettingsManager.getInstance().setAutoScreenRecordingEnabled(autoScreenRecordingEnabled);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
    }

    @Deprecated
    public static void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(autoScreenRecordingMaxDuration)));
        SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(autoScreenRecordingMaxDuration);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
    }

    @Deprecated
    @RequiresApi(api=26)
    public static void setPushNotificationChannelId(String pushNotificationChannelId) {
        APIBuildChecker.check();
        a.b(pushNotificationChannelId);
        InstabugDeprecationLogger.getInstance().log(15);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.SESSION_PROFILER, state);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.TRACK_USER_STEPS, state);
    }

    public static void setReproStepsState(State reproStepsState) {
        if (reproStepsState == State.ENABLED) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(true);
            Log.e((String)Instabug.class.getName(), (String)"UserSteps with screenshots Mode is disabled please contact support for further details.");
        } else if (reproStepsState == State.ENABLED_WITH_NO_SCREENSHOTS) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(false);
        } else if (reproStepsState == State.DISABLED) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.DISABLED);
        }
    }

    @Deprecated
    public static void setSystemReplyNotificationSoundEnabled(boolean shouldPlaySound) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setSystemReplyNotificationSoundEnabled").setType(Boolean.TYPE).setValue(shouldPlaySound));
        a.c(shouldPlaySound);
        InstabugDeprecationLogger.getInstance().log(16);
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugTheme));
        SettingsManager.getInstance().setTheme(instabugTheme);
        switch (instabugTheme) {
            case InstabugColorThemeDark: {
                SettingsManager.getInstance().setPrimaryColor(-9580554);
                SettingsManager.getInstance().setStatusBarColor(-16119286);
                break;
            }
            case InstabugColorThemeLight: {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        }
    }

    public static void logUserEvent(@NonNull String eventIdentifier) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class));
        InstabugUserEventLogger.getInstance().logUserEvent(eventIdentifier, new UserEventParam[0]);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class));
        SettingsManager.getInstance().setOnReportCreatedListener(listener);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingDuration(@IntRange(from=30L, to=180L) int maxDuration) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("maxDuration").setType(Integer.class).setValue(maxDuration));
        SettingsManager.getInstance().setAutoScreenRecordingDuration(maxDuration);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("asrAudioCapturingEnabled").setType(Feature.State.class).setValue(isASRAudioEnabled.name()));
        SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(isASRAudioEnabled);
    }

    public static void show() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().show();
    }

    @Deprecated
    public static void setInAppReplyNotificationSound(boolean shouldPlaySound) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(shouldPlaySound));
        a.d(shouldPlaySound);
        InstabugDeprecationLogger.getInstance().log(10);
    }

    @Deprecated
    public static void setOnNewReplyReceivedCallback(Runnable runnable) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("runnable").setType(Runnable.class).setValue(runnable));
        a.a(runnable);
        InstabugDeprecationLogger.getInstance().log(4);
    }

    @Deprecated
    public static void setReplyNotificationEnabled(boolean isReplyNotificationEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isReplyNotificationEnabled").setType(Boolean.TYPE).setValue(isReplyNotificationEnabled));
        a.a(isReplyNotificationEnabled);
        InstabugDeprecationLogger.getInstance().log(5);
    }

    @Deprecated
    public static int getUnreadMessagesCount() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log(6);
        return a.a();
    }

    @Deprecated
    public static void showNotification(Bundle data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("data").setType(Bundle.class).setValue(data));
        a.b(data);
        InstabugDeprecationLogger.getInstance().log(9);
    }

    @Deprecated
    public static void showNotification(Map<String, String> data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("data").setType(Map.class));
        a.b(data);
        InstabugDeprecationLogger.getInstance().log(9);
    }

    @Deprecated
    public static void setPushNotificationRegistrationToken(String token) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("token").setType(String.class).setValue(token));
        a.a(token);
        InstabugDeprecationLogger.getInstance().log(8);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class Builder {
        private String applicationToken;
        private Context applicationContext;
        private Application application;
        private InstabugColorTheme instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
        private int instabugPrimaryColor = -15893761;
        private int instabugStatusBarColor = -3815737;
        private InstabugInvocationEvent[] instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
        private int defaultInvocationMode = 0;
        private Feature.State userDataState = com.instabug.library.b.a;
        private Feature.State consoleLogState = com.instabug.library.b.a;
        private Feature.State instabugLogState = com.instabug.library.b.a;
        private Feature.State inAppMessagingState = com.instabug.library.b.a;
        private Feature.State crashReportingState = com.instabug.library.b.a;
        private Feature.State pushNotificationState = com.instabug.library.b.a;
        private Feature.State trackingUserStepsState = com.instabug.library.b.a;
        private State reproStepsState = State.ENABLED;
        private Feature.State viewHierarchyState = com.instabug.library.b.a;
        private Feature.State surveysState = com.instabug.library.b.a;
        private Feature.State userEventsState = com.instabug.library.b.a;
        private boolean emailFieldRequired = true;
        private boolean emailFieldVisibility = true;
        private boolean commentFieldRequired = false;
        private boolean introMessageEnabled = true;
        private boolean shouldPlaySounds = false;
        private boolean successDialogEnabled = true;
        private boolean playSystemNotificationSound;
        private boolean playInAppNotificationSound;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
        private int shakingThreshold = 650;
        private int floatingButtonOffsetFromTop = -1;
        private Locale instabugLocale = Locale.getDefault();
        private int notificationIcon;
        private boolean isSurveysAutoShowing = true;
        private boolean chatPromptOptionEnable = true;
        private boolean bugPromptOptionEnable = true;
        private boolean feedbackPromptOptionEnable = true;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();

        public Builder(Application application, String applicationToken) {
            this(application, applicationToken, InstabugInvocationEvent.SHAKE);
        }

        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(application.getApplicationContext(), applicationToken, instabugInvocationEvent);
            this.application = application;
        }

        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            this.applicationContext = applicationContext;
            this.instabugInvocationEvents = instabugInvocationEvents;
            this.applicationToken = applicationToken;
        }

        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue(TextUtils.join((CharSequence)",", (Object[])instabugInvocationEvents)));
            this.instabugInvocationEvents = instabugInvocationEvents;
            return this;
        }

        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.trackingUserStepsState = state;
            return this;
        }

        public Builder setReproStepsState(State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(State.class).setValue((Object)state));
            this.reproStepsState = state;
            return this;
        }

        @Deprecated
        public Builder setPushNotificationState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.pushNotificationState = state;
            this.deprecatedMethodsToBeLogedAfterBuild.add(7);
            return this;
        }

        public Builder setConsoleLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.consoleLogState = state;
            return this;
        }

        @Deprecated
        public Builder setCrashReportingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.crashReportingState = state;
            this.deprecatedMethodsToBeLogedAfterBuild.add(11);
            return this;
        }

        public Builder setInstabugLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.instabugLogState = state;
            return this;
        }

        public Builder setUserDataState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userDataState = state;
            return this;
        }

        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.inAppMessagingState = state;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.viewHierarchyState = state;
            return this;
        }

        @Deprecated
        public Builder setSurveysState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.surveysState = state;
            this.deprecatedMethodsToBeLogedAfterBuild.add(12);
            return this;
        }

        public Builder setUserEventsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userEventsState = state;
            return this;
        }

        public Instabug build(Feature.State instabugInitialState) {
            SettingsManager.init(this.applicationContext);
            boolean bl = instabugInitialState == Feature.State.ENABLED;
            this.setFeaturesStates(bl);
            com.instabug.library.a a2 = new com.instabug.library.a(this.applicationContext);
            INSTANCE = new Instabug(a2);
            Instabug.setState(InstabugState.BUILT);
            this.logDeprecatedApis();
            a2.a(this.applicationContext);
            InstabugInternalTrackingDelegate.init(this.application);
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            a2.a();
            SettingsManager.getInstance().setInstabugLocale(this.instabugLocale);
            SettingsManager.getInstance().setTheme(this.instabugTheme);
            SettingsManager.getInstance().setPrimaryColor(this.instabugPrimaryColor);
            SettingsManager.getInstance().setStatusBarColor(this.instabugStatusBarColor);
            InvocationManager.getInstance().setInstabugInvocationEvent(this.instabugInvocationEvents);
            InvocationManager.getInstance().getCurrentInvocationSettings().setDefaultInvocationMode(this.defaultInvocationMode);
            InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(this.shakingThreshold);
            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(this.instabugFloatingButtonEdge);
            if (this.floatingButtonOffsetFromTop != -1) {
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(this.floatingButtonOffsetFromTop);
            }
            a.b(this.shouldPlaySounds);
            a.c(this.playSystemNotificationSound);
            a.d(this.playInAppNotificationSound);
            a.a(this.notificationIcon);
            b.a(this.isSurveysAutoShowing);
            return INSTANCE;
        }

        private void logDeprecatedApis() {
            for (Integer n : this.deprecatedMethodsToBeLogedAfterBuild) {
                InstabugDeprecationLogger.getInstance().log(n);
            }
        }

        public Instabug build() {
            if (Instabug.isBuilt()) {
                if (InternalScreenRecordHelper.getInstance().isRecording()) {
                    InternalScreenRecordHelper.getInstance().cancel();
                }
                Instabug.disable();
            }
            return this.build(Feature.State.ENABLED);
        }

        private void setFeaturesStates(Boolean isInstabugEnabled) {
            InstabugSDKLogger.v(this, "Setting user data feature state " + (Object)((Object)this.userDataState));
            com.instabug.library.b.a().a(Feature.USER_DATA, this.userDataState);
            InstabugSDKLogger.v(this, "Setting console log feature state " + (Object)((Object)this.consoleLogState));
            com.instabug.library.b.a().a(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugSDKLogger.v(this, "Setting Instabug logs feature state " + (Object)((Object)this.instabugLogState));
            com.instabug.library.b.a().a(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugSDKLogger.v(this, "Setting crash reporting feature state " + (Object)((Object)this.crashReportingState));
            com.instabug.library.b.a().a(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugSDKLogger.v(this, "Setting in-app messaging feature state " + (Object)((Object)this.inAppMessagingState));
            com.instabug.library.b.a().a(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugSDKLogger.v(this, "Setting push notification feature state " + (Object)((Object)this.pushNotificationState));
            com.instabug.library.b.a().a(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugSDKLogger.v(this, "Setting tracking user steps feature state " + (Object)((Object)this.trackingUserStepsState));
            com.instabug.library.b.a().a(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            InstabugSDKLogger.v(this, "Setting repro steps feature state " + (Object)((Object)this.reproStepsState));
            Instabug.setReproStepsState(this.reproStepsState);
            InstabugSDKLogger.v(this, "Setting view hierarchy  feature state " + (Object)((Object)this.viewHierarchyState));
            com.instabug.library.b.a().a(Feature.VIEW_HIERARCHY, this.viewHierarchyState);
            InstabugSDKLogger.v(this, "Setting surveys feature state " + (Object)((Object)this.surveysState));
            com.instabug.library.b.a().a(Feature.SURVEYS, this.surveysState);
            InstabugSDKLogger.v(this, "Setting user events feature state " + (Object)((Object)this.userEventsState));
            com.instabug.library.b.a().a(Feature.USER_EVENTS, this.userEventsState);
            InstabugSDKLogger.v(this, "Setting instabug overall state " + isInstabugEnabled);
            com.instabug.library.b.a().a(Feature.INSTABUG, isInstabugEnabled);
        }
    }
}

