/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.Window;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.R;
import com.instabug.library.settings.SettingsManager;

public class StatusBarUtils {
    public static void setStatusBar(Activity activity) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21) {
            window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(SettingsManager.getInstance().getStatusBarColor());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            window = activity.getWindow().getDecorView();
            if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                window.setSystemUiVisibility(8192);
            } else {
                window.setSystemUiVisibility(0);
            }
        }
    }

    public static void setStatusBarForDialog(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            window.setFlags(512, 512);
            View view = activity.getWindow().getDecorView();
            int n = 4096;
            view.setSystemUiVisibility(n);
        }
    }

    public static void darkenStatusBarColor(@NonNull Activity activity, int color2) {
        Window window;
        int n = Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight ? StatusBarUtils.darkenColor(color2) : StatusBarUtils.darkenColor(ContextCompat.getColor((Context)activity, (int)R.color.instabug_toolbar_color_dark));
        if (Build.VERSION.SDK_INT >= 21) {
            window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(n);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            window = activity.getWindow().getDecorView();
            window.setSystemUiVisibility(0);
        }
    }

    private static int darkenColor(int color2) {
        float[] fArray = new float[3];
        Color.colorToHSV((int)color2, (float[])fArray);
        fArray[2] = fArray[2] * 0.8f;
        return Color.HSVToColor((float[])fArray);
    }
}

