/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.model.a;
import com.instabug.library.util.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Report {
    private ArrayList<String> tags = new ArrayList();
    private ArrayList<a> consoleLogs = new ArrayList();
    private String userData;
    private HashMap<String, String> userAttributes = new HashMap();
    private HashMap<Uri, String> fileAttachments = new HashMap();

    public void addTag(String ... tag) {
        Collections.addAll(this.tags, tag);
    }

    public void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        this.fileAttachments.put(fileUri, fileNameWithExtension);
    }

    public void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        this.fileAttachments.put(AttachmentsUtility.getUriFromBytes(Instabug.getApplicationContext(), data, fileNameWithExtension), fileNameWithExtension);
    }

    public void setUserAttribute(@NonNull String key, String value) {
        this.userAttributes.put(key, value);
    }

    public void appendToConsoleLogs(String logMessage) {
        a a2 = new a();
        a2.a(logMessage);
        a2.a(System.currentTimeMillis());
        this.consoleLogs.add(a2);
    }

    public void logVerbose(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.v(logMessage);
        }
    }

    public void logDebug(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.d(logMessage);
        }
    }

    public void logInfo(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.i(logMessage);
        }
    }

    public void logWarn(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.w(logMessage);
        }
    }

    public void logError(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.e(logMessage);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public ArrayList<a> getConsoleLog() {
        return this.consoleLogs;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(@NonNull String userData) {
        this.userData = StringUtility.trimString(userData, 1000);
    }

    public HashMap<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public HashMap<Uri, String> getFileAttachments() {
        return this.fileAttachments;
    }

    public static interface OnReportCreatedListener {
        public void onReportCreated(Report var1);
    }
}

