/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class InstabugVideoUtils {
    private static final String TAG = "InstabugVideoUtils";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static int getVideoDuration(String srcPath) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(srcPath);
        String string2 = mediaMetadataRetriever.extractMetadata(9);
        mediaMetadataRetriever.release();
        return Integer.parseInt(string2);
    }

    public static boolean isDurationMoreThanAutoRecMaxDuration(int durationMs, int autoRecordingMaxDuration) {
        return durationMs > autoRecordingMaxDuration;
    }

    public static File startTrim(File src, File dst, int autoRecordingMaxDuration) throws IOException {
        int n;
        if (src != null && src.length() > 0L && InstabugVideoUtils.isDurationMoreThanAutoRecMaxDuration(n = InstabugVideoUtils.getVideoDuration(src.getPath()), autoRecordingMaxDuration)) {
            int n2 = n - autoRecordingMaxDuration;
            InstabugVideoUtils.genVideoUsingMuxer(src.getPath(), dst.getPath(), n2, n, false, true);
            return dst;
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    private static void genVideoUsingMuxer(String srcPath, String dstPath, int startMs, int endMs, boolean useAudio, boolean useVideo) throws IOException {
        int n;
        int n2;
        int n3;
        Object object;
        MediaExtractor mediaExtractor = new MediaExtractor();
        mediaExtractor.setDataSource(srcPath);
        int n4 = mediaExtractor.getTrackCount();
        MediaMuxer mediaMuxer = new MediaMuxer(dstPath, 0);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n4);
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            object = mediaExtractor.getTrackFormat(i);
            String string2 = object.getString("mime");
            n3 = 0;
            if (string2.startsWith("audio/") && useAudio) {
                n3 = 1;
            } else if (string2.startsWith("video/") && useVideo) {
                n3 = 1;
            }
            if (n3 == 0) continue;
            mediaExtractor.selectTrack(i);
            n2 = mediaMuxer.addTrack(object);
            hashMap.put(i, n2);
            if (!object.containsKey("max-input-size")) continue;
            int n6 = object.getInteger("max-input-size");
            n5 = n6 > n5 ? n6 : n5;
        }
        if (n5 < 0) {
            n5 = 4096;
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(srcPath);
        object = mediaMetadataRetriever.extractMetadata(24);
        if (object != null && (n = Integer.parseInt((String)object)) >= 0) {
            mediaMuxer.setOrientationHint(n);
        }
        if (startMs > 0) {
            mediaExtractor.seekTo((long)(startMs * 1000), 2);
        }
        int n7 = 0;
        n3 = -1;
        n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n5);
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        try {
            mediaMuxer.start();
            while (true) {
                bufferInfo.offset = n7;
                bufferInfo.size = mediaExtractor.readSampleData(byteBuffer, n7);
                if (bufferInfo.size < 0) {
                    InstabugSDKLogger.d(TAG, "Saw input EOS.");
                    bufferInfo.size = 0;
                    break;
                }
                bufferInfo.presentationTimeUs = mediaExtractor.getSampleTime();
                if (endMs > 0 && bufferInfo.presentationTimeUs > (long)(endMs * 1000)) {
                    InstabugSDKLogger.d(TAG, "The current sample is over the trim end time.");
                    break;
                }
                bufferInfo.flags = mediaExtractor.getSampleFlags();
                n3 = mediaExtractor.getSampleTrackIndex();
                mediaMuxer.writeSampleData(((Integer)hashMap.get(n3)).intValue(), byteBuffer, bufferInfo);
                n2 = 1;
                mediaExtractor.advance();
            }
            mediaMuxer.stop();
            File file = new File(srcPath);
            file.delete();
        }
        catch (IllegalStateException illegalStateException) {
            InstabugSDKLogger.w(TAG, "The source video file is malformed");
        }
        finally {
            if (n2 != 0) {
                mediaMuxer.release();
                InstabugSDKLogger.d(TAG, "The muxer has been released!");
            } else {
                InstabugSDKLogger.w(TAG, "The muxer skip release/stop since it has no written frames");
            }
        }
    }
}

