/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.net.Uri;
import android.os.Handler;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.video.ScreenRecordEvent;
import com.instabug.library.internal.video.VideoProcessingService;
import com.instabug.library.internal.video.c;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.a.c;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.b;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.io.File;

public class InternalScreenRecordHelper
implements c.b,
c.c {
    private static InternalScreenRecordHelper INSTANCE;
    private com.instabug.library.invocation.a.c fab;
    private Disposable sessionDisposable;
    private final Subject<Boolean> stopSubject = BehaviorSubject.createDefault((Object)false);
    private boolean canStopRecording;

    private InternalScreenRecordHelper() {
    }

    public static InternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    public void init() {
        InvocationManager.getInstance().switchOffInvocation();
        if (this.fab == null) {
            this.fab = new com.instabug.library.invocation.a.c(this);
            this.fab.a();
        } else {
            this.fab.a();
        }
    }

    @Override
    public void start() {
        this.subscribeToSessionEvents();
        this.startSnapping();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (InternalScreenRecordHelper.this.isRecording()) {
                    InternalScreenRecordHelper.this.stopSubject.onNext((Object)true);
                }
            }
        }, 1000L);
    }

    public void pause() {
    }

    @Override
    public void stop() {
        if (this.canStopRecording) {
            c.a().b();
            this.release();
        }
    }

    public void release() {
        if (this.fab != null) {
            this.fab.b();
        }
        this.unsubscribeFromSessionEvents();
        InvocationManager.getInstance().switchOnInvocation();
        b.b(Instabug.getApplicationContext());
        this.stopSubject.onNext((Object)false);
    }

    public void cancel() {
        if (this.isRecording()) {
            c.a().c();
            b.b(Instabug.getApplicationContext());
            if (this.fab != null) {
                this.fab.b();
                this.fab.a();
            }
            InstabugSDKLogger.d(this, "Cancelling screen recording");
            SettingsManager.getInstance().setVideoProcessorBusy(false);
        }
    }

    private void startSnapping() {
        if (!c.a().d()) {
            c.a().a(this);
        }
    }

    public boolean isRecording() {
        return c.a().d() || SettingsManager.getInstance().isVideoProcessorBusy();
    }

    public Observable<Boolean> getIsStopableObservable() {
        return this.stopSubject.hide().doOnNext((Consumer)new Consumer<Boolean>(){

            public void a(Boolean bl) {
                InternalScreenRecordHelper.this.canStopRecording = bl;
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((Boolean)object);
            }
        });
    }

    private void subscribeToSessionEvents() {
        if (this.sessionDisposable == null || this.sessionDisposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer<Session.SessionState>(){

                public void a(Session.SessionState sessionState) {
                    if (sessionState == Session.SessionState.FINISH) {
                        InternalScreenRecordHelper.this.stopSubject.onNext((Object)false);
                        InternalScreenRecordHelper.this.cancel();
                    }
                }

                public /* synthetic */ void accept(Object object) throws Exception {
                    this.a((Session.SessionState)((Object)object));
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    @Override
    public void onFramesCapturingFinished(String string2) {
        File file = AttachmentsUtility.getVideoFile(Instabug.getApplicationContext());
        Uri uri = Uri.fromFile((File)file);
        ScreenRecordingEventBus.getInstance().post(new ScreenRecordEvent(0, uri));
        InstabugSDKLogger.i(this, "Encoding...");
        VideoProcessingService.a(Instabug.getApplicationContext(), file.getPath(), string2);
    }
}

