/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.screenshot.a;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class ExtraScreenshotHelper {
    private ImageButton captureButton;
    private boolean isCaptureButtonShown = false;
    private Disposable currentActivityLifeCycleDisposable;
    private OnCaptureListener onCaptureListener;

    public void init(OnCaptureListener onCaptureListener) {
        this.onCaptureListener = onCaptureListener;
        this.subscribeToCurranActivityLifeCycle();
        InvocationManager.getInstance().switchOffInvocation();
    }

    public void release() {
        this.captureButton = null;
        this.onCaptureListener = null;
        if (this.currentActivityLifeCycleDisposable != null && !this.currentActivityLifeCycleDisposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        InvocationManager.getInstance().switchOnInvocation();
    }

    private void show(final @NonNull Activity activity) {
        if (this.isCaptureButtonShown) {
            InstabugSDKLogger.v(this, "bar already shown");
            return;
        }
        this.captureButton = this.createCaptureButton(activity);
        ViewCompat.setElevation((View)this.captureButton, (float)ViewUtils.convertDpToPx((Context)activity, 5.0f));
        ((ViewGroup)activity.getWindow().getDecorView()).addView((View)this.captureButton, (ViewGroup.LayoutParams)this.createCaptureButtonContainer(activity));
        this.isCaptureButtonShown = true;
        this.captureButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ExtraScreenshotHelper.this.hide();
                ExtraScreenshotHelper.this.captureExtraScreenshot(activity, ExtraScreenshotHelper.this.onCaptureListener);
            }
        });
    }

    private ImageButton createCaptureButton(Activity activity) {
        ImageButton imageButton = new ImageButton((Context)activity);
        imageButton.setId(R.id.instabug_extra_screenshot_button);
        imageButton.setScaleType(ImageView.ScaleType.CENTER);
        imageButton.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.instabug_bg_white_oval)));
        imageButton.setImageDrawable(AppCompatResources.getDrawable((Context)activity, (int)R.drawable.ib_ic_core_screenshot));
        return imageButton;
    }

    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity activity) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 81);
        layoutParams.setMargins(0, 0, 0, 20);
        Resources resources = activity.getResources();
        if (Build.VERSION.SDK_INT >= 21 && ScreenUtility.hasNavBar(resources) && !ScreenUtility.isLandscape(activity)) {
            layoutParams.bottomMargin += ScreenUtility.getNavigationBarHeight(resources);
        }
        return layoutParams;
    }

    private void captureExtraScreenshot(final Activity activity, final OnCaptureListener onCaptureListener) {
        a.a(activity, new a.a(){

            @Override
            public void a(Bitmap bitmap) {
                BitmapUtils.saveBitmap(bitmap, (Context)activity, new BitmapUtils.OnSaveBitmapCallback(){

                    @Override
                    public void onSuccess(Uri uri) {
                        onCaptureListener.onExtraScreenshotCaptured(uri);
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
                    }
                });
            }

            @Override
            public void a(Throwable throwable) {
                InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
            }
        });
    }

    private void hide() {
        if (this.isCaptureButtonShown && this.captureButton != null && this.captureButton.getParent() != null && this.captureButton.getParent() instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.captureButton.getParent();
            viewGroup.removeView((View)this.captureButton);
            this.isCaptureButtonShown = false;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                switch (activityLifeCycleEvent) {
                    case RESUMED: {
                        ExtraScreenshotHelper.this.handleCurrentActivityResumeEvent();
                        break;
                    }
                    case PAUSED: {
                        ExtraScreenshotHelper.this.handleCurrentActivityPauseEvent();
                        break;
                    }
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((ActivityLifeCycleEvent)((Object)object));
            }
        });
    }

    private void handleCurrentActivityResumeEvent() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        } else {
            InstabugSDKLogger.v(ExtraScreenshotHelper.class, "current activity equal null");
        }
    }

    private void handleCurrentActivityPauseEvent() {
        this.hide();
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);
    }
}

