/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.support.annotation.CheckResult;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.IBGColorTheme;
import com.instabug.library.IBGCustomTextPlaceHolder;
import com.instabug.library.IBGFloatingButtonEdge;
import com.instabug.library.IBGInvocationEvent;
import com.instabug.library.IBGInvocationMode;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.b.a;
import com.instabug.library.b.b;
import com.instabug.library.b.c;
import com.instabug.library.b.d;
import com.instabug.library.b.e;
import com.instabug.library.bugreporting.model.ReportCategory;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.internal.layer.CapturableView;
import com.instabug.library.internal.storage.cache.UserAttributesCacheManager;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InstabugInvocationMode;
import com.instabug.library.invocation.Invocation;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonCorner;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.BugCategory;
import com.instabug.library.model.Report;
import com.instabug.library.settings.AttachmentsTypesParams;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.StringUtility;
import com.instabug.library.visualusersteps.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Instabug {
    private static Instabug INSTANCE = null;
    private static InstabugState INSTABUG_STATE = InstabugState.NOT_BUILT;
    private com.instabug.library.a delegate;

    private Instabug(@NonNull com.instabug.library.a a2) {
        this.delegate = a2;
    }

    static Instabug getInstance() throws IllegalStateException {
        if (INSTANCE == null) {
            throw new IllegalStateException("Instabug getInstance called before Instabug.Builder().build() was called");
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getApplicationContext() {
        return Instabug.getInstance().delegate.h();
    }

    public static void setDebugEnabled(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(bl));
        SettingsManager.getInstance().setDebugEnabled(bl);
    }

    public static int getPrimaryColor() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static void setPrimaryColor(@ColorInt int n) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(n)));
        SettingsManager.getInstance().setPrimaryColor(n);
    }

    public static InstabugColorTheme getTheme() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getTheme();
    }

    public static void addFileAttachment(@NonNull Uri uri, @NonNull String string2) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(uri, string2);
    }

    public static void addFileAttachment(@NonNull byte[] byArray, @NonNull String string2) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("data").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(byArray, string2);
    }

    public static void clearFileAttachment() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().clearExtraAttachmentFiles();
    }

    public static String getUserData() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getUserData();
    }

    public static void setUserData(@NonNull String string2) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userData").setType(String.class));
        if (com.instabug.library.b.a().b(Feature.USER_DATA) == Feature.State.ENABLED) {
            string2 = StringUtility.trimString(string2);
            SettingsManager.getInstance().setUserData(string2);
        }
    }

    public static String getUserEmail() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return com.instabug.library.user.a.b();
    }

    public static String getAppToken() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getAppToken();
    }

    public static void identifyUser(@NonNull String string2, @NonNull String string3) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("username").setType(String.class), new Api.Parameter().setName("email"));
        com.instabug.library.user.a.a(Instabug.getApplicationContext(), string2, string3);
    }

    public static void logoutUser() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.library.user.a.a();
    }

    public static void setState(InstabugState instabugState) {
        INSTABUG_STATE = instabugState;
    }

    public static InstabugState getState() {
        return INSTABUG_STATE;
    }

    public static boolean isBuilt() {
        return INSTANCE != null && Instabug.getState() != InstabugState.NOT_BUILT;
    }

    public static boolean isEnabled() {
        APIBuildChecker.check();
        return com.instabug.library.b.a().a(Feature.INSTABUG) && com.instabug.library.b.a().b(Feature.INSTABUG) == Feature.State.ENABLED;
    }

    public static void enable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (!Instabug.isEnabled()) {
            com.instabug.library.b.a().a(Feature.INSTABUG, true);
            com.instabug.library.b.a().a(Feature.INSTABUG, Feature.State.ENABLED);
            com.instabug.library.b.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.a();
        }
    }

    public static void disable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.isEnabled()) {
            com.instabug.library.b.a().a(Feature.INSTABUG, Feature.State.DISABLED);
            com.instabug.library.b.a().a(Feature.INSTABUG, false);
            com.instabug.library.b.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.f();
        }
    }

    public static void setLocale(Locale locale) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        SettingsManager.getInstance().setInstabugLocale(locale);
    }

    public static Locale getLocale(Context context) throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getInstabugLocale(context);
    }

    public static int getUnreadMessagesCount() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return b.a();
    }

    public static void addTags(String ... stringArray) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        stringArray = StringUtility.trimStrings(stringArray);
        SettingsManager.getInstance().addTags(stringArray);
    }

    public static ArrayList<String> getTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getTags();
    }

    public static void resetTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetTags();
    }

    public static boolean isInstabugNotification(Bundle bundle) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Bundle.class));
        return b.a(bundle);
    }

    public static boolean isInstabugNotification(Map<String, String> map) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Map.class));
        return b.a(map);
    }

    public static void showNotification(Bundle bundle) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Bundle.class));
        b.b(bundle);
    }

    public static void showNotification(Map<String, String> map) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Map.class));
        b.b(map);
    }

    public static void setPushNotificationRegistrationToken(String string2) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("token").setType(String.class));
        b.a(string2);
    }

    public static void setCustomTextPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class));
        SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder);
    }

    @Deprecated
    public static void setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("initialScreenshot").setType(Boolean.TYPE).setValue(bl), new Api.Parameter().setName("extraScreenshot").setType(Boolean.TYPE).setValue(bl2), new Api.Parameter().setName("galleryImage").setType(Boolean.TYPE).setValue(bl3), new Api.Parameter().setName("screenRecording").setType(Boolean.TYPE).setValue(bl4));
        a.a(bl, bl2, bl3, bl4);
        b.a(bl2, bl3, bl4);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return UserAttributesCacheManager.getAll();
    }

    public static void setUserAttribute(@NonNull String string2, String string3) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class), new Api.Parameter().setName("value").setType(String.class));
        string3 = StringUtility.trimString(string3);
        UserAttributesCacheManager.putAttribute(string2, string3);
    }

    @Nullable
    public static String getUserAttribute(@NonNull String string2) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        return UserAttributesCacheManager.getAttribute(string2);
    }

    public static void removeUserAttribute(@NonNull String string2) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        UserAttributesCacheManager.deleteAttribute(string2);
    }

    public static void clearAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        UserAttributesCacheManager.deleteAll();
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setShouldPlayConversationSounds(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("shouldPlaySounds").setType(Boolean.TYPE).setValue(bl));
        b.b(bl);
    }

    public static void setWelcomeMessageState(WelcomeMessage.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(state.toString()));
        SettingsManager.getInstance().setWelcomeMessageState(state);
        InstabugDeprecationLogger.getInstance().log();
    }

    public static void showWelcomeMessage(WelcomeMessage.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(state.toString()));
        if (!InstabugCore.isForegroundBusy()) {
            Instabug.getInstance().delegate.a(state);
        }
    }

    public static void setNotificationIcon(@DrawableRes int n) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("notificationIcon").setType(Integer.TYPE));
        b.a(n);
    }

    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.VIEW_HIERARCHY, state);
    }

    public static void setCrashReportingState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.CRASH_REPORTING, state);
    }

    public static void setAutoScreenRecordingEnabled(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("setAutoScreenRecordingEnabled").setType(Boolean.class).setValue(String.valueOf(bl)));
        SettingsManager.getInstance().setAutoScreenRecordingEnabled(bl);
        InternalAutoScreenRecorderHelper.getInstance().start();
    }

    public static void setAutoScreenRecordingMaxDuration(int n) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(n)));
        SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(n);
    }

    @RequiresApi(api=26)
    public static void setPushNotificationChannelId(String string2) {
        APIBuildChecker.check();
        b.b(string2);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.SESSION_PROFILER, state);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.TRACK_USER_STEPS, state);
    }

    public static void setReproStepsState(State state) {
        if (state == State.ENABLED) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(true);
        } else if (state == State.ENABLED_WITH_NO_SCREENSHOTS) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(false);
        } else if (state == State.DISABLED) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.DISABLED);
        }
    }

    public static void setOnNewReplyReceivedCallback(Runnable runnable) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        b.a(runnable);
    }

    public static void setReplyNotificationEnabled(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isReplyNotificationEnabled").setType(Boolean.TYPE).setValue(bl));
        b.a(bl);
    }

    public static void setSystemReplyNotificationSoundEnabled(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("setSystemReplyNotificationSoundEnabled").setType(Boolean.TYPE).setValue(bl));
        b.c(bl);
    }

    public static void setInAppReplyNotificationSound(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(bl));
        b.d(bl);
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugColorTheme) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugColorTheme));
        SettingsManager.getInstance().setTheme(instabugColorTheme);
        switch (instabugColorTheme) {
            case InstabugColorThemeDark: {
                SettingsManager.getInstance().setPrimaryColor(-9580554);
                SettingsManager.getInstance().setStatusBarColor(-16119286);
                break;
            }
            case InstabugColorThemeLight: {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        }
    }

    public static void logUserEvent(@NonNull String string2) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class));
        InstabugUserEventLogger.getInstance().logUserEvent(string2, new UserEventParam[0]);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener onReportCreatedListener) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class));
        SettingsManager.getInstance().setOnReportCreatedListener(onReportCreatedListener);
    }

    @Deprecated
    public static void setShouldAudioRecordingOptionAppear(boolean bl) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    static boolean shouldAudioRecordingOptionAppear() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return false;
    }

    @Deprecated
    public static void changeInvocationEvent(@NonNull InstabugInvocationEvent instabugInvocationEvent) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)instabugInvocationEvent));
        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEvent);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void changeInvocationEvent(@NonNull IBGInvocationEvent iBGInvocationEvent) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationEvent").setType(IBGInvocationEvent.class).setValue((Object)iBGInvocationEvent));
        switch (iBGInvocationEvent) {
            case IBGInvocationEventNone: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.NONE);
                break;
            }
            case IBGInvocationEventShake: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.SHAKE);
                break;
            }
            case IBGInvocationEventFloatingButton: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.FLOATING_BUTTON);
                break;
            }
            case IBGInvocationEventTwoFingersSwipeLeft: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.TWO_FINGER_SWIPE_LEFT);
                break;
            }
            case IBGInvocationScreenshotGesture: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.SCREENSHOT_GESTURE);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invoke() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().invoke();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setDialog(@NonNull Dialog dialog) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("dialog").setType(Dialog.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void addMapView(@NonNull View view, @NonNull Object object) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("mapView").setType(View.class), new Api.Parameter().setName("googleMap").setType(Object.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void addCapturableView(@NonNull CapturableView capturableView) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("capturableView").setType(CapturableView.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setGLSurfaceView(@NonNull GLSurfaceView gLSurfaceView) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("surfaceView").setType(GLSurfaceView.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invoke(@NonNull InstabugInvocationMode instabugInvocationMode) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugInvocationMode").setType(InstabugInvocationMode.class).setValue(instabugInvocationMode.toString()));
        switch (instabugInvocationMode) {
            case NEW_BUG: {
                InvocationManager.getInstance().invoke(1);
                break;
            }
            case NEW_FEEDBACK: {
                InvocationManager.getInstance().invoke(2);
                break;
            }
            case NEW_CHAT: {
                InvocationManager.getInstance().invoke(3);
                break;
            }
            case CHATS_LIST: {
                InvocationManager.getInstance().invoke(4);
                break;
            }
            default: {
                InvocationManager.getInstance().invoke(0);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invokeConversations() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.invoke(InstabugInvocationMode.CHATS_LIST);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invoke(@NonNull IBGInvocationMode iBGInvocationMode) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationMode").setType(IBGInvocationMode.class).setValue((Object)iBGInvocationMode));
        switch (iBGInvocationMode) {
            case IBGInvocationModeNA: {
                Instabug.invoke(InstabugInvocationMode.PROMPT_OPTION);
                break;
            }
            case IBGInvocationModeBugReporter: {
                Instabug.invoke(InstabugInvocationMode.NEW_BUG);
                break;
            }
            case IBGInvocationModeFeedbackSender: {
                Instabug.invoke(InstabugInvocationMode.NEW_FEEDBACK);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setDefaultInvocationMode(int n) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setDefaultInvocationMode").setType(Invocation.class).setValue(n));
        InvocationManager.getInstance().getCurrentInvocationSettings().setDefaultInvocationMode(n);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void resetDefaultInvocationMode() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().getCurrentInvocationSettings().resetDefaultInvocationMode();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void showIntroMessage() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.getInstance().delegate.a(WelcomeMessage.State.LIVE);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void log(@NonNull String string2) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("message").setType(String.class));
        if (com.instabug.library.b.a().b(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.d(string2);
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void clearLog() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter[0]);
        InstabugLog.clearLogs();
    }

    @Deprecated
    public static void reportException(@NonNull Throwable throwable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("throwable").setType(Throwable.class));
        Instabug.reportException(throwable, null);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void reportException(@NonNull Throwable throwable, @Nullable String string2) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("throwable").setType(Throwable.class), new Api.Parameter().setName("exceptionIdentifier").setType(String.class));
        c.a(throwable, string2);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPreSendingRunnable(Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("preSendingRunnable").setType(Runnable.class));
        SettingsManager.getInstance().setPreReportRunnable(runnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static IBGColorTheme getColorTheme() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        switch (SettingsManager.getInstance().getTheme()) {
            case InstabugColorThemeDark: {
                return IBGColorTheme.IBGColorThemeDark;
            }
            case InstabugColorThemeLight: {
                return IBGColorTheme.IBGColorThemeLight;
            }
        }
        return IBGColorTheme.IBGColorThemeLight;
    }

    @Deprecated
    public static void setFileAttachment(Uri uri, @Nullable String string2) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        Instabug.addFileAttachment(uri, string2);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setOnSdkInvokedCallback(OnSdkInvokedCallback onSdkInvokedCallback) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("onSdkInvokedCallback").setType(OnSdkInvokedCallback.class));
        SettingsManager.getInstance().setOnSdkInvokedCallback(onSdkInvokedCallback);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPreInvocation(final Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("preSdkInvocationRunnable").setType(Runnable.class));
        SettingsManager.getInstance().setOnInvokeCallback(new OnInvokeCallback(){

            @Override
            public void onInvoke() {
                runnable.run();
            }
        });
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class));
        a.a(onSdkDismissedCallback);
        b.a(onSdkDismissedCallback);
        SettingsManager.getInstance().setOnSdkDismissedCallback(onSdkDismissedCallback);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setNewMessageHandler(Runnable runnable) throws IllegalStateException {
        b.a(runnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void changeLocale(Locale locale) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        SettingsManager.getInstance().setInstabugLocale(locale);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setUserEmail(@NonNull String string2) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("email").setType(String.class));
        com.instabug.library.user.a.d(string2);
    }

    @Deprecated
    public static void setUsername(@NonNull String string2) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("username").setType(String.class));
        com.instabug.library.user.a.a(string2);
    }

    @Deprecated
    public static void dismiss() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.getInstance().delegate.i();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setChatNotificationEnabled(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isChatNotificationEnable").setType(Boolean.TYPE).setValue(bl));
        b.a(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setBugCategories(List<BugCategory> list) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("bugCategories").setType(List.class));
        a.a(list);
    }

    @Deprecated
    public static void setReportCategories(List<ReportCategory> list) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("reportCategories").setType(List.class));
        a.b(list);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("initialScreenshot").setType(Boolean.TYPE).setValue(bl), new Api.Parameter().setName("extraScreenshot").setType(Boolean.TYPE).setValue(bl2), new Api.Parameter().setName("galleryImage").setType(Boolean.TYPE).setValue(bl3), new Api.Parameter().setName("voiceNote").setType(Boolean.TYPE).setValue(bl4), new Api.Parameter().setName("screenRecording").setType(Boolean.TYPE).setValue(bl5));
        Instabug.setAttachmentTypesEnabled(bl, bl2, bl3, bl5);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static boolean showValidSurvey() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.a();
    }

    @Deprecated
    public static void setCustomTextPlaceHolders(IBGCustomTextPlaceHolder iBGCustomTextPlaceHolder) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("ibgCustomTextPlaceHolder").setType(IBGCustomTextPlaceHolder.class));
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder = new InstabugCustomTextPlaceHolder();
        instabugCustomTextPlaceHolder.setPlaceHoldersMap(iBGCustomTextPlaceHolder.getConvertedHashMap());
        Instabug.setCustomTextPlaceHolders(instabugCustomTextPlaceHolder);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setThresholdForReshowingSurveyAfterDismiss(int n, int n2) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.a(n, n2);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setSurveysAutoShowing(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isSurveysAutoShowing").setType(Boolean.class).setValue(bl));
        e.a(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPreShowingSurveyRunnable(Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.a(runnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setAfterShowingSurveyRunnable(Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.b(runnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setRequestedOrientation(int n) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().setRequestedOrientation(n);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void resetRequestedOrientation() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetRequestedOrientation();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    @CheckResult
    public static int getRequestedOrientation() {
        return OrientationUtils.getOrientation(SettingsManager.getInstance().getRequestedOrientation());
    }

    @Deprecated
    public static void setEnableSystemNotificationSound(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(bl));
        b.c(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEnableInAppNotificationSound(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(bl));
        b.d(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPromptOptionsEnabled(boolean bl, boolean bl2, boolean bl3) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("chat").setType(Boolean.TYPE).setValue(bl), new Api.Parameter().setName("bug").setType(Boolean.TYPE).setValue(bl2), new Api.Parameter().setName("feedback").setType(Boolean.TYPE).setValue(Boolean.toString(bl3)));
        InvocationSettings invocationSettings = InvocationManager.getInstance().getCurrentInvocationSettings();
        if (bl) {
            invocationSettings.enabledPromptOption(4);
        } else {
            invocationSettings.disabledPromptOption(4);
        }
        if (bl2) {
            invocationSettings.enabledPromptOption(1);
        } else {
            invocationSettings.disabledPromptOption(1);
        }
        if (bl3) {
            invocationSettings.enabledPromptOption(2);
        } else {
            invocationSettings.disabledPromptOption(2);
        }
        if (bl && (bl2 || bl3) || bl2 && bl3) {
            invocationSettings.setDefaultInvocationMode(0);
        } else if (bl) {
            invocationSettings.setDefaultInvocationMode(4);
        } else if (bl2) {
            invocationSettings.setDefaultInvocationMode(1);
        } else if (bl3) {
            invocationSettings.setDefaultInvocationMode(2);
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setShakingThreshold(int n) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue(Integer.toString(n)));
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(n);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setSuccessDialogEnabled(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(bl));
        a.d(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setIntroMessageEnabled(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(bl));
        Instabug.setWelcomeMessageState(bl ? WelcomeMessage.State.LIVE : WelcomeMessage.State.DISABLED);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setCommentFieldRequired(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("commentFieldRequired").setType(Boolean.TYPE).setValue(bl));
        a.b(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEmailFieldVisibility(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.TYPE).setValue(bl));
        a.c(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEmailFieldRequired(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.setEmailFieldRequired(bl, 1);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEmailFieldRequired(boolean bl, int ... nArray) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldRequired").setType(Boolean.TYPE).setValue(bl), new Api.Parameter().setName("actions").setValue(String.class).setValue(Arrays.toString(nArray)));
        if (nArray == null || nArray.length == 0) {
            a.a(bl);
            d.a(bl);
            d.b(bl);
        } else {
            block6: for (int n : nArray) {
                switch (n) {
                    case 1: {
                        a.a(bl);
                        d.a(bl);
                        d.b(bl);
                        return;
                    }
                    case 2: {
                        a.a(bl);
                        continue block6;
                    }
                    case 4: {
                        d.a(bl);
                        continue block6;
                    }
                    case 8: {
                        d.b(bl);
                        continue block6;
                    }
                }
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setWillSkipScreenshotAnnotation(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("willSkipInitialScreenshotAnnotating").setType(Boolean.TYPE).setValue(bl));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setTheme(@NonNull InstabugColorTheme instabugColorTheme) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugColorTheme));
        SettingsManager.getInstance().setTheme(instabugColorTheme);
        switch (instabugColorTheme) {
            case InstabugColorThemeDark: {
                SettingsManager.getInstance().setPrimaryColor(-9580554);
                SettingsManager.getInstance().setStatusBarColor(-16119286);
                break;
            }
            case InstabugColorThemeLight: {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static boolean showSurvey(@NonNull String string2) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.a(string2);
    }

    @Deprecated
    public static boolean hasRespondToSurvey(@NonNull String string2) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.b(string2);
    }

    @Deprecated
    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setFloatingButtonOffsetFromTop(@IntRange(from=0L) int n) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue(Integer.toString(n)));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(n);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setVideoRecordingFloatingButtonCorner(@NonNull InstabugVideoRecordingButtonCorner instabugVideoRecordingButtonCorner) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugViewRecordingButtonCorner").setType(InstabugVideoRecordingButtonCorner.class).setValue((Object)instabugVideoRecordingButtonCorner));
        switch (instabugVideoRecordingButtonCorner) {
            case TOP_LEFT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.TOP_LEFT);
                break;
            }
            case TOP_RIGHT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.TOP_RIGHT);
                break;
            }
            case BOTTOM_RIGHT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.BOTTOM_RIGHT);
                break;
            }
            case BOTTOM_LEFT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.BOTTOM_LEFT);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void addExtraReportField(CharSequence charSequence, boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("fieldHint").setType(CharSequence.class).setValue(charSequence), new Api.Parameter().setName("required").setType(Boolean.TYPE).setValue(bl));
        a.a(charSequence, bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void clearExtraReportFields() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        a.b();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("state").setType(ExtendedBugReport.State.class).setValue((Object)state));
        a.a(state);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void showFeatureRequests() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        d.a();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setShouldShowSurveysWelcomeScreen(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.b(bl);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static boolean hasValidSurveys() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.b();
    }

    @Deprecated
    public static void logUserEvent(@NonNull String string2, UserEventParam ... userEventParamArray) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class), new Api.Parameter().setName("userEventParams").setType(UserEventParam.class));
        InstabugUserEventLogger.getInstance().logUserEvent(string2, userEventParamArray);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class Builder {
        private String applicationToken;
        private Context applicationContext;
        private Application application;
        private InstabugColorTheme instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
        private int instabugPrimaryColor = -15893761;
        private int instabugStatusBarColor = -3815737;
        private InstabugInvocationEvent[] instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
        private int defaultInvocationMode = 0;
        private Feature.State userDataState = com.instabug.library.b.a;
        private Feature.State consoleLogState = com.instabug.library.b.a;
        private Feature.State instabugLogState = com.instabug.library.b.a;
        private Feature.State inAppMessagingState = com.instabug.library.b.a;
        private Feature.State crashReportingState = com.instabug.library.b.a;
        private Feature.State pushNotificationState = com.instabug.library.b.a;
        private Feature.State trackingUserStepsState = com.instabug.library.b.a;
        private State reproStepsState = State.ENABLED;
        private Feature.State viewHierarchyState = com.instabug.library.b.a;
        private Feature.State surveysState = com.instabug.library.b.a;
        private Feature.State userEventsState = com.instabug.library.b.a;
        private boolean emailFieldRequired = true;
        private boolean emailFieldVisibility = true;
        private AttachmentsTypesParams attachmentsTypesParams = new AttachmentsTypesParams();
        private boolean commentFieldRequired = false;
        private boolean introMessageEnabled = true;
        private boolean shouldPlaySounds = false;
        private boolean successDialogEnabled = true;
        private boolean playSystemNotificationSound;
        private boolean playInAppNotificationSound;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
        private int shakingThreshold = 650;
        private int floatingButtonOffsetFromTop = -1;
        private Locale instabugLocale = Locale.getDefault();
        private int notificationIcon;
        private boolean isSurveysAutoShowing = true;
        private boolean chatPromptOptionEnable = true;
        private boolean bugPromptOptionEnable = true;
        private boolean feedbackPromptOptionEnable = true;

        public Builder(Application application, String string2) {
            this(application, string2, InstabugInvocationEvent.SHAKE);
        }

        public Builder(@NonNull Application application, @NonNull String string2, InstabugInvocationEvent ... instabugInvocationEventArray) {
            this(application.getApplicationContext(), string2, instabugInvocationEventArray);
            this.application = application;
        }

        Builder(@NonNull Context context, @NonNull String string2, InstabugInvocationEvent ... instabugInvocationEventArray) {
            this.applicationContext = context;
            this.instabugInvocationEvents = instabugInvocationEventArray;
            this.applicationToken = string2;
        }

        @Deprecated
        public Builder setInvocationEvent(IBGInvocationEvent iBGInvocationEvent) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationEvent").setType(IBGInvocationEvent.class).setValue((Object)iBGInvocationEvent));
            switch (iBGInvocationEvent) {
                case IBGInvocationEventNone: {
                    this.setInvocationEvent(InstabugInvocationEvent.NONE);
                    break;
                }
                case IBGInvocationEventShake: {
                    this.setInvocationEvent(InstabugInvocationEvent.SHAKE);
                    break;
                }
                case IBGInvocationEventFloatingButton: {
                    this.setInvocationEvent(InstabugInvocationEvent.FLOATING_BUTTON);
                    break;
                }
                case IBGInvocationEventTwoFingersSwipeLeft: {
                    this.setInvocationEvent(InstabugInvocationEvent.TWO_FINGER_SWIPE_LEFT);
                    break;
                }
                case IBGInvocationScreenshotGesture: {
                    this.setInvocationEvent(InstabugInvocationEvent.SCREENSHOT_GESTURE);
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setInvocationEvent(@NonNull InstabugInvocationEvent instabugInvocationEvent) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)instabugInvocationEvent));
            this.instabugInvocationEvents = new InstabugInvocationEvent[]{instabugInvocationEvent};
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEventArray) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue(TextUtils.join((CharSequence)",", (Object[])instabugInvocationEventArray)));
            this.instabugInvocationEvents = instabugInvocationEventArray;
            return this;
        }

        @Deprecated
        public Builder setShouldPlayConversationSounds(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySounds").setType(Boolean.TYPE).setValue(bl));
            this.shouldPlaySounds = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEnableSystemNotificationSound(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(bl));
            this.playSystemNotificationSound = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEnableInAppNotificationSound(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(bl));
            this.playInAppNotificationSound = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setDefaultInvocationMode(IBGInvocationMode iBGInvocationMode) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationMode").setType(IBGInvocationMode.class).setValue((Object)iBGInvocationMode));
            switch (iBGInvocationMode) {
                case IBGInvocationModeNA: {
                    this.defaultInvocationMode = 0;
                    break;
                }
                case IBGInvocationModeBugReporter: {
                    this.defaultInvocationMode = 1;
                    break;
                }
                case IBGInvocationModeFeedbackSender: {
                    this.defaultInvocationMode = 2;
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setPromptOptionsEnabled(boolean bl, boolean bl2, boolean bl3) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("chat").setType(Boolean.TYPE).setValue(bl), new Api.Parameter().setName("bug").setType(Boolean.TYPE).setValue(bl2), new Api.Parameter().setName("feedback").setType(Boolean.TYPE).setValue(Boolean.toString(bl3)));
            this.chatPromptOptionEnable = bl;
            this.bugPromptOptionEnable = bl2;
            this.feedbackPromptOptionEnable = bl3;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setShakingThreshold(int n) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue(Integer.toString(n)));
            this.shakingThreshold = n;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setShouldShowIntroDialog(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(bl));
            this.introMessageEnabled = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setSuccessDialogEnabled(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(bl));
            this.successDialogEnabled = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setIntroMessageEnabled(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(bl));
            this.introMessageEnabled = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.trackingUserStepsState = state;
            return this;
        }

        public Builder setReproStepsState(State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(State.class).setValue((Object)state));
            this.reproStepsState = state;
            return this;
        }

        public Builder setPushNotificationState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.pushNotificationState = state;
            return this;
        }

        public Builder setConsoleLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.consoleLogState = state;
            return this;
        }

        public Builder setCrashReportingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.crashReportingState = state;
            return this;
        }

        public Builder setInstabugLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.instabugLogState = state;
            return this;
        }

        public Builder setUserDataState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userDataState = state;
            return this;
        }

        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.inAppMessagingState = state;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.viewHierarchyState = state;
            return this;
        }

        public Builder setSurveysState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.surveysState = state;
            return this;
        }

        public Builder setUserEventsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userEventsState = state;
            return this;
        }

        @Deprecated
        public Builder setCommentFieldRequired(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("commentFieldRequired").setType(Boolean.TYPE).setValue(bl));
            this.commentFieldRequired = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEmailFieldRequired(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldRequired").setType(Boolean.TYPE).setValue(bl));
            this.emailFieldRequired = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEmailFieldVisibility(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.TYPE).setValue(bl));
            this.emailFieldVisibility = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setWillTakeScreenshot(boolean bl) throws IllegalStateException {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("willTakeInitialScreenshot").setType(Boolean.TYPE).setValue(bl));
            this.attachmentsTypesParams.setShouldTakesInitialScreenshot(bl);
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("initialScreenshot").setType(Boolean.TYPE).setValue(bl), new Api.Parameter().setName("extraScreenshot").setType(Boolean.TYPE).setValue(bl2), new Api.Parameter().setName("galleryImage").setType(Boolean.TYPE).setValue(bl3), new Api.Parameter().setName("voiceNote").setType(Boolean.TYPE).setValue(bl4), new Api.Parameter().setName("screenRecording").setType(Boolean.TYPE).setValue(bl5));
            this.attachmentsTypesParams.setShouldTakesInitialScreenshot(bl).setAllowTakeExtraScreenshot(bl2).setAllowAttachImageFromGallery(bl3).setAllowScreenRecording(bl5);
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setWillSkipScreenshotAnnotation(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("willSkipInitialScreenshotAnnotating").setType(Boolean.TYPE).setValue(bl));
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setColorTheme(IBGColorTheme iBGColorTheme) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("theme").setType(IBGColorTheme.class).setValue((Object)iBGColorTheme));
            switch (iBGColorTheme) {
                case IBGColorThemeDark: {
                    this.instabugTheme = InstabugColorTheme.InstabugColorThemeDark;
                    this.instabugPrimaryColor = -9580554;
                    break;
                }
                case IBGColorThemeLight: {
                    this.instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
                    this.instabugPrimaryColor = -15893761;
                    break;
                }
                case theme: {
                    this.instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
                    this.instabugPrimaryColor = -15893761;
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setTheme(@NonNull InstabugColorTheme instabugColorTheme) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugColorTheme));
            this.instabugTheme = instabugColorTheme;
            switch (instabugColorTheme) {
                case InstabugColorThemeDark: {
                    this.instabugPrimaryColor = -9580554;
                    this.instabugStatusBarColor = -16119286;
                    break;
                }
                case InstabugColorThemeLight: {
                    this.instabugPrimaryColor = -15893761;
                    this.instabugStatusBarColor = -3815737;
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setFloatingButtonEdge(IBGFloatingButtonEdge iBGFloatingButtonEdge) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("floatingButtonEdge").setType(IBGFloatingButtonEdge.class).setValue((Object)iBGFloatingButtonEdge));
            switch (iBGFloatingButtonEdge) {
                case Right: {
                    this.setFloatingButtonEdge(InstabugFloatingButtonEdge.RIGHT);
                    break;
                }
                case Left: {
                    this.setFloatingButtonEdge(InstabugFloatingButtonEdge.LEFT);
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugFloatingButtonEdge").setType(IBGFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge));
            this.instabugFloatingButtonEdge = instabugFloatingButtonEdge;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setFloatingButtonOffsetFromTop(@IntRange(from=0L) int n) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue(Integer.toString(n)));
            this.floatingButtonOffsetFromTop = n;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setLocale(Locale locale) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
            this.instabugLocale = locale;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setNotificationIcon(int n) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("notificationIcon").setType(Integer.TYPE));
            this.notificationIcon = n;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setSurveysAutoShowing(boolean bl) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isSurveysAutoShowing").setType(Boolean.TYPE).setValue(bl));
            this.isSurveysAutoShowing = bl;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        public Instabug build(Feature.State state) {
            SettingsManager.init(this.applicationContext);
            boolean bl = state == Feature.State.ENABLED;
            this.setFeaturesStates(bl);
            com.instabug.library.a a2 = new com.instabug.library.a(this.applicationContext);
            INSTANCE = new Instabug(a2);
            Instabug.setState(InstabugState.BUILT);
            InstabugInternalTrackingDelegate.init(this.application);
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            a2.a();
            SettingsManager.getInstance().setInstabugLocale(this.instabugLocale);
            SettingsManager.getInstance().setTheme(this.instabugTheme);
            SettingsManager.getInstance().setPrimaryColor(this.instabugPrimaryColor);
            SettingsManager.getInstance().setStatusBarColor(this.instabugStatusBarColor);
            a.a(this.attachmentsTypesParams.isShouldTakesInitialScreenshot(), this.attachmentsTypesParams.isAllowTakeExtraScreenshot(), this.attachmentsTypesParams.isAllowAttachImageFromGallery(), this.attachmentsTypesParams.isAllowScreenRecording());
            a.a(this.emailFieldRequired);
            a.c(this.emailFieldVisibility);
            a.d(this.successDialogEnabled);
            InvocationManager.getInstance().setInstabugInvocationEvent(this.instabugInvocationEvents);
            Instabug.setPromptOptionsEnabled(this.chatPromptOptionEnable, this.bugPromptOptionEnable, this.feedbackPromptOptionEnable);
            InvocationManager.getInstance().getCurrentInvocationSettings().setDefaultInvocationMode(this.defaultInvocationMode);
            InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(this.shakingThreshold);
            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(this.instabugFloatingButtonEdge);
            if (this.floatingButtonOffsetFromTop != -1) {
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(this.floatingButtonOffsetFromTop);
            }
            a.b(this.commentFieldRequired);
            b.b(this.shouldPlaySounds);
            b.c(this.playSystemNotificationSound);
            b.d(this.playInAppNotificationSound);
            b.a(this.notificationIcon);
            b.a(this.attachmentsTypesParams.isAllowTakeExtraScreenshot(), this.attachmentsTypesParams.isAllowAttachImageFromGallery(), this.attachmentsTypesParams.isAllowScreenRecording());
            e.a(this.isSurveysAutoShowing);
            return INSTANCE;
        }

        public Instabug build() {
            if (Instabug.isBuilt()) {
                if (InternalScreenRecordHelper.getInstance().isRecording()) {
                    InternalScreenRecordHelper.getInstance().cancel();
                }
                Instabug.disable();
            }
            return this.build(Feature.State.ENABLED);
        }

        private void setFeaturesStates(Boolean bl) {
            InstabugSDKLogger.v(this, "Setting user data feature state " + (Object)((Object)this.userDataState));
            com.instabug.library.b.a().a(Feature.USER_DATA, this.userDataState);
            InstabugSDKLogger.v(this, "Setting console log feature state " + (Object)((Object)this.consoleLogState));
            com.instabug.library.b.a().a(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugSDKLogger.v(this, "Setting Instabug logs feature state " + (Object)((Object)this.instabugLogState));
            com.instabug.library.b.a().a(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugSDKLogger.v(this, "Setting crash reporting feature state " + (Object)((Object)this.crashReportingState));
            com.instabug.library.b.a().a(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugSDKLogger.v(this, "Setting in-app messaging feature state " + (Object)((Object)this.inAppMessagingState));
            com.instabug.library.b.a().a(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugSDKLogger.v(this, "Setting push notification feature state " + (Object)((Object)this.pushNotificationState));
            com.instabug.library.b.a().a(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugSDKLogger.v(this, "Setting tracking user steps feature state " + (Object)((Object)this.trackingUserStepsState));
            com.instabug.library.b.a().a(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            InstabugSDKLogger.v(this, "Setting repro steps feature state " + (Object)((Object)this.reproStepsState));
            Instabug.setReproStepsState(this.reproStepsState);
            InstabugSDKLogger.v(this, "Setting view hierarchy  feature state " + (Object)((Object)this.viewHierarchyState));
            com.instabug.library.b.a().a(Feature.VIEW_HIERARCHY, this.viewHierarchyState);
            InstabugSDKLogger.v(this, "Setting surveys feature state " + (Object)((Object)this.surveysState));
            com.instabug.library.b.a().a(Feature.SURVEYS, this.surveysState);
            InstabugSDKLogger.v(this, "Setting user events feature state " + (Object)((Object)this.userEventsState));
            com.instabug.library.b.a().a(Feature.USER_EVENTS, this.userEventsState);
            InstabugSDKLogger.v(this, "Setting instabug overall state " + bl);
            com.instabug.library.b.a().a(Feature.INSTABUG, bl);
        }
    }
}

