/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import java.util.List;

public class StringUtility {
    public static String trimString(String s) {
        return StringUtility.trimString(s, 4096);
    }

    public static String trimString(String s, int limit) {
        if (s == null) {
            return "null";
        }
        if (s.length() > limit) {
            s = s.substring(0, limit);
        }
        return s;
    }

    public static String[] trimStrings(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = StringUtility.trimString(strings[i]);
        }
        return strings;
    }

    public static boolean isNumeric(String s) {
        return s.matches("\\d+(?:\\.\\d+)?");
    }

    public static int compareVersion(String version1, String version2) throws NumberFormatException {
        String[] stringArray = version1.split("\\.");
        String[] stringArray2 = version2.split("\\.");
        for (int i = 0; i < stringArray.length || i < stringArray2.length; ++i) {
            if (i < stringArray.length && i < stringArray2.length) {
                if (Integer.parseInt(stringArray[i]) < Integer.parseInt(stringArray2[i])) {
                    return -1;
                }
                if (Integer.parseInt(stringArray[i]) <= Integer.parseInt(stringArray2[i])) continue;
                return 1;
            }
            if (i < stringArray.length) {
                if (Integer.parseInt(stringArray[i]) == 0) continue;
                return 1;
            }
            if (i >= stringArray2.length || Integer.parseInt(stringArray2[i]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static String removeExtension(String fileName) {
        return fileName.replaceFirst("[.][^.]+$", "");
    }

    public static String toCommaSeparated(List<String> strings) {
        StringBuilder stringBuilder = new StringBuilder();
        if (strings == null || strings.size() == 0) {
            return stringBuilder.toString();
        }
        for (int i = 0; i < strings.size() - 1; ++i) {
            stringBuilder.append(strings.get(i));
            stringBuilder.append(",");
        }
        stringBuilder.append(strings.get(strings.size() - 1));
        return stringBuilder.toString();
    }
}

