/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.app.Activity;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.b;
import com.instabug.library.core.InitialScreenshotHelper;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.a.a;
import com.instabug.library.invocation.a.d;
import com.instabug.library.invocation.a.e;
import com.instabug.library.invocation.a.f;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class InvocationManager
implements com.instabug.library.invocation.a {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings = new InvocationSettings();
    private InstabugInvocationEvent[] currentInstabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
    private List<a> currentInvokers = new ArrayList<a>();
    private Disposable currentActivityLifeCycleDisposable;
    private boolean isInvocationAvailable = true;

    private InvocationManager() {
        this.subscribeToCarenActivityLifeCycle();
    }

    public static void init() {
        InstabugSDKLogger.v(InvocationManager.class, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else {
            INSTANCE.listen();
        }
    }

    public static InvocationManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        throw new IllegalStateException("calling InvocationManager.getInstance() before calling InvocationManager.init()");
    }

    public void release() {
        if (this.currentActivityLifeCycleDisposable != null && !this.currentActivityLifeCycleDisposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
    }

    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        boolean bl;
        this.currentInstabugInvocationEvents = this.removeDuplicates(instabugInvocationEvent);
        boolean bl2 = bl = this.currentInvokers != null && this.currentInvokers.size() > 0;
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                a2.b();
            }
            this.currentInvokers.clear();
        }
        block7: for (InstabugInvocationEvent instabugInvocationEvent2 : instabugInvocationEvent) {
            if (instabugInvocationEvent2 == InstabugInvocationEvent.NONE && instabugInvocationEvent.length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new ArrayList<a>();
            }
            switch (instabugInvocationEvent2) {
                case SHAKE: {
                    e e2 = new e(Instabug.getApplicationContext(), this);
                    e2.a(this.currentInvocationSettings.getShakeThreshold());
                    this.currentInvokers.add(e2);
                    continue block7;
                }
                case FLOATING_BUTTON: {
                    this.currentInvokers.add(new com.instabug.library.invocation.a.b(this));
                    continue block7;
                }
                case TWO_FINGER_SWIPE_LEFT: {
                    this.currentInvokers.add(new f(Instabug.getApplicationContext(), this));
                    continue block7;
                }
                case SCREENSHOT: 
                case SCREENSHOT_GESTURE: {
                    this.currentInvokers.add(new d(this));
                    continue block7;
                }
            }
        }
        if (this.currentInvokers != null && bl) {
            for (a a3 : this.currentInvokers) {
                a3.a();
            }
        }
    }

    @VisibleForTesting
    InstabugInvocationEvent[] removeDuplicates(InstabugInvocationEvent[] events) {
        ArrayList<InstabugInvocationEvent> arrayList = new ArrayList<InstabugInvocationEvent>();
        HashSet<InstabugInvocationEvent> hashSet = new HashSet<InstabugInvocationEvent>();
        for (InstabugInvocationEvent instabugInvocationEvent : events) {
            if (hashSet.contains((Object)instabugInvocationEvent)) continue;
            arrayList.add(instabugInvocationEvent);
            hashSet.add(instabugInvocationEvent);
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = new InstabugInvocationEvent[arrayList.size()];
        return arrayList.toArray(instabugInvocationEventArray);
    }

    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        return Arrays.copyOf(this.currentInstabugInvocationEvents, this.currentInstabugInvocationEvents.length);
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    List<a> getCurrentInvokers() {
        return this.currentInvokers;
    }

    private void listen() {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && this.isInvocationAvailable && this.isPromptOptionsAvailable() && this.currentInvokers != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (a a2 : this.currentInvokers) {
                a2.a();
            }
        }
    }

    public void handle(MotionEvent motionEvent) {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof f)) continue;
                ((f)a2).a(motionEvent);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                a2.b();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable = false;
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable = true;
    }

    public void invoke() {
        if (!InstabugCore.isForegroundBusy()) {
            this.invoke(this.currentInvocationSettings.getDefaultInvocationMode());
        }
    }

    public void invoke(int invocationMode) {
        if (this.isInstabugEnabled() && !InstabugCore.isForegroundBusy()) {
            switch (invocationMode) {
                case 0: 
                case 3: 
                case 4: {
                    this.invoke(invocationMode, null);
                    break;
                }
                case 1: 
                case 2: {
                    this.captureScreenshotThenInvoke(invocationMode);
                    break;
                }
            }
        }
    }

    private void invoke(int invocationMode, @Nullable Uri screenshotUri) {
        this.startPreInvocationRunnable();
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
            AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_TRIM_KEEP);
        }
        switch (invocationMode) {
            case 0: {
                this.invokeWithAvailableOptions(screenshotUri);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                PluginPromptOption pluginPromptOption = PluginPromptOption.getPromptOptionByInvocationMode(invocationMode);
                if (pluginPromptOption != null) {
                    pluginPromptOption.invoke(screenshotUri);
                    break;
                }
                InstabugSDKLogger.w(InvocationManager.class, "'" + invocationMode + "' invocationMode isn't available");
                break;
            }
            case 3: {
                com.instabug.library.d.b.b();
                break;
            }
        }
    }

    private void startPreInvocationRunnable() {
        if (SettingsManager.getInstance().getOnInvokeCallback() != null) {
            SettingsManager.getInstance().getOnInvokeCallback().onInvoke();
        }
    }

    private void invokeWithAvailableOptions(Uri screenshotUri) {
        ArrayList<PluginPromptOption> arrayList = this.getAvailablePromptOptions();
        if (arrayList.size() >= 2) {
            if (screenshotUri == null) {
                this.captureScreenshotThenLaunchPromptOptionActivity();
            } else {
                this.launchPromptOptionActivity(screenshotUri);
            }
        } else if (arrayList.size() == 1) {
            PluginPromptOption pluginPromptOption = arrayList.get(0);
            int n = pluginPromptOption.getInvocationMode();
            switch (n) {
                case 1: 
                case 2: {
                    if (screenshotUri == null) {
                        this.captureScreenshotThenInvoke(n);
                        break;
                    }
                    this.invoke(n, screenshotUri);
                    break;
                }
                case 4: {
                    pluginPromptOption.invoke();
                    break;
                }
            }
        } else {
            InstabugSDKLogger.w(InvocationManager.class, "No plugins prompt options available");
        }
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        ArrayList<PluginPromptOption> arrayList = new ArrayList<PluginPromptOption>();
        for (PluginPromptOption pluginPromptOption : com.instabug.library.core.plugin.a.c()) {
            if (!this.currentInvocationSettings.getEnabledPromptOptions()[pluginPromptOption.getInvocationMode()]) continue;
            arrayList.add(pluginPromptOption);
        }
        return arrayList;
    }

    private void captureScreenshotThenLaunchPromptOptionActivity() {
        InitialScreenshotHelper.captureScreenshot(new InitialScreenshotHelper.InitialScreenshotCapturingListener(){

            @Override
            public void onScreenshotCapturedSuccessfully(Uri screenshotUri) {
                InvocationManager.this.launchPromptOptionActivity(screenshotUri);
            }

            @Override
            public void onScreenshotCapturingFailed(Throwable throwable) {
                InvocationManager.this.launchPromptOptionActivity(null);
            }
        });
    }

    private void captureScreenshotThenInvoke(final int invocationMode) {
        InitialScreenshotHelper.captureScreenshot(new InitialScreenshotHelper.InitialScreenshotCapturingListener(){

            @Override
            public void onScreenshotCapturedSuccessfully(Uri screenshotUri) {
                InvocationManager.this.invoke(invocationMode, screenshotUri);
            }

            @Override
            public void onScreenshotCapturingFailed(Throwable throwable) {
                InvocationManager.this.invoke(invocationMode, null);
            }
        });
    }

    @Override
    public void onInvocationRequested(Uri screenshotUri) {
        this.invoke(this.currentInvocationSettings.getDefaultInvocationMode(), screenshotUri);
    }

    @Override
    public void onInvocationRequested() {
        this.invoke();
    }

    private void launchPromptOptionActivity(Uri screenshotUri) {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            com.instabug.library.ui.a.a.a().a(activity, screenshotUri);
        }
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                switch (activityLifeCycleEvent) {
                    case RESUMED: {
                        InstabugSDKLogger.v(this, "current activity resumed");
                        InvocationManager.this.listen();
                        break;
                    }
                    case PAUSED: {
                        InstabugSDKLogger.v(this, "current activity paused");
                        InvocationManager.this.sleep();
                        break;
                    }
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((ActivityLifeCycleEvent)((Object)object));
            }
        });
    }

    private boolean isInstabugEnabled() {
        return b.a().b(Feature.INSTABUG) == Feature.State.ENABLED && b.a().a(Feature.INSTABUG);
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    public void notifyPrimaryColorChanged() {
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof com.instabug.library.invocation.a.b)) continue;
                a2.b();
                a2.a();
            }
        }
    }
}

