/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import com.instabug.library.internal.storage.cache.CacheChangedListener;
import java.util.ArrayList;
import java.util.List;

public abstract class Cache<K, V> {
    private final List<CacheChangedListener<V>> listeners;
    private String id;
    private int appVersion = -1;

    public Cache(String cacheId) {
        this(cacheId, 1);
    }

    protected Cache(String cacheId, int appVersion) {
        this.id = cacheId;
        this.appVersion = appVersion;
        this.listeners = new ArrayList<CacheChangedListener<V>>();
    }

    public abstract V get(K var1);

    public abstract V put(K var1, V var2);

    public abstract V delete(K var1);

    public abstract List<V> getValues();

    public abstract long size();

    public void notifyItemRemoved(V removedElement) {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCachedItemRemoved(removedElement);
        }
    }

    public void notifyItemAdded(V addedElement) {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCachedItemAdded(addedElement);
        }
    }

    public void notifyItemUpdated(V oldElement, V updatedElement) {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCachedItemUpdated(oldElement, updatedElement);
        }
    }

    public void notifyCacheInvalidated() {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCacheInvalidated();
        }
    }

    public abstract void invalidate();

    public String getId() {
        return this.id;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    public boolean addOnCacheChangedListener(CacheChangedListener<V> cacheChangedListener) {
        return !this.listeners.contains(cacheChangedListener) && this.listeners.add(cacheChangedListener);
    }

    public boolean removeOnCacheChangedListener(CacheChangedListener<V> cacheChangedListener) {
        return this.listeners.remove(cacheChangedListener);
    }
}

