/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.plugin;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import com.instabug.library.core.plugin.PluginPromptOption;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class Plugin {
    public static final int STATE_BACKGROUND = 0;
    public static final int STATE_FOREGROUND = 1;
    public static final int STATE_PROCESSING_ATTACHMENT = 2;
    protected WeakReference<Context> contextWeakReference;
    protected int state = 0;

    @CallSuper
    public void init(Context context) {
        this.contextWeakReference = new WeakReference<Context>(context);
    }

    public abstract void release();

    public abstract long getLastActivityTime();

    public ArrayList<PluginPromptOption> getPromptOptions() {
        return null;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    @Nullable
    public Context getAppContext() {
        if (this.contextWeakReference == null) {
            return null;
        }
        return (Context)this.contextWeakReference.get();
    }

    public boolean isAppContextAvailable() {
        return this.contextWeakReference != null && this.contextWeakReference.get() != null;
    }

    public void invoke(PluginPromptOption pluginPromptOption) {
    }
}

