/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.support.annotation.CheckResult;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.IBGColorTheme;
import com.instabug.library.IBGCustomTextPlaceHolder;
import com.instabug.library.IBGFloatingButtonEdge;
import com.instabug.library.IBGInvocationEvent;
import com.instabug.library.IBGInvocationMode;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.bugreporting.model.ReportCategory;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d.a;
import com.instabug.library.d.b;
import com.instabug.library.d.c;
import com.instabug.library.d.d;
import com.instabug.library.d.e;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.internal.layer.CapturableView;
import com.instabug.library.internal.storage.cache.UserAttributesCacheManager;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InstabugInvocationMode;
import com.instabug.library.invocation.Invocation;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonCorner;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.BugCategory;
import com.instabug.library.model.Report;
import com.instabug.library.settings.AttachmentsTypesParams;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.StringUtility;
import com.instabug.library.visualusersteps.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Instabug {
    private static Instabug INSTANCE = null;
    private static InstabugState INSTABUG_STATE = InstabugState.NOT_BUILT;
    private com.instabug.library.a delegate;

    private Instabug(@NonNull com.instabug.library.a delegate) {
        this.delegate = delegate;
    }

    static Instabug getInstance() throws IllegalStateException {
        if (INSTANCE == null) {
            throw new IllegalStateException("Instabug getInstance called before Instabug.Builder().build() was called");
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getApplicationContext() {
        return Instabug.getInstance().delegate.l();
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(isDebugEnabled));
        SettingsManager.getInstance().setDebugEnabled(isDebugEnabled);
    }

    public static int getPrimaryColor() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(primaryColorValue)));
        SettingsManager.getInstance().setPrimaryColor(primaryColorValue);
    }

    public static InstabugColorTheme getTheme() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getTheme();
    }

    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(fileUri, fileNameWithExtension);
    }

    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("data").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(data, fileNameWithExtension);
    }

    public static void clearFileAttachment() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().clearExtraAttachmentFiles();
    }

    public static String getUserData() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getUserData();
    }

    public static void setUserData(@NonNull String userData) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userData").setType(String.class));
        if (com.instabug.library.b.a().b(Feature.USER_DATA) == Feature.State.ENABLED) {
            userData = StringUtility.trimString(userData, 1000);
            SettingsManager.getInstance().setUserData(userData);
        }
    }

    public static String getUserEmail() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return com.instabug.library.user.a.b();
    }

    public static String getAppToken() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getAppToken();
    }

    public static void identifyUser(@NonNull String username, @NonNull String email) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("username").setType(String.class), new Api.Parameter().setName("email"));
        com.instabug.library.user.a.a(Instabug.getApplicationContext(), username, email);
    }

    public static void logoutUser() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.library.user.a.a();
    }

    public static void setState(InstabugState instabugState) {
        INSTABUG_STATE = instabugState;
    }

    public static InstabugState getState() {
        return INSTABUG_STATE;
    }

    public static boolean isBuilt() {
        return INSTANCE != null && Instabug.getState() != InstabugState.NOT_BUILT;
    }

    public static boolean isEnabled() {
        APIBuildChecker.check();
        return com.instabug.library.b.a().a(Feature.INSTABUG) && com.instabug.library.b.a().b(Feature.INSTABUG) == Feature.State.ENABLED;
    }

    public static void enable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (!Instabug.isEnabled()) {
            com.instabug.library.b.a().a(Feature.INSTABUG, true);
            com.instabug.library.b.a().a(Feature.INSTABUG, Feature.State.ENABLED);
            com.instabug.library.b.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.a();
        }
    }

    public static void disable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.isEnabled()) {
            com.instabug.library.b.a().a(Feature.INSTABUG, Feature.State.DISABLED);
            com.instabug.library.b.a().a(Feature.INSTABUG, false);
            com.instabug.library.b.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.h();
        }
    }

    public static void pauseSdk() throws IllegalStateException {
        APIBuildChecker.check();
        if (Instabug.isEnabled()) {
            Instabug.getInstance().delegate.i();
        }
    }

    public static void resumeSdk() throws IllegalStateException {
        APIBuildChecker.check();
        Instabug.getInstance().delegate.j();
    }

    public static void setLocale(Locale locale) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        SettingsManager.getInstance().setInstabugLocale(locale);
    }

    public static Locale getLocale(Context context) throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getInstabugLocale(context);
    }

    public static int getUnreadMessagesCount() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return b.a();
    }

    public static void addTags(String ... tags) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        tags = StringUtility.trimStrings(tags);
        SettingsManager.getInstance().addTags(tags);
    }

    public static ArrayList<String> getTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getTags();
    }

    public static void resetTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetTags();
    }

    public static boolean isInstabugNotification(Bundle data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Bundle.class));
        return b.a(data);
    }

    public static boolean isInstabugNotification(Map<String, String> data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Map.class));
        return b.a(data);
    }

    public static void showNotification(Bundle data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Bundle.class));
        b.b(data);
    }

    public static void showNotification(Map<String, String> data) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("data").setType(Map.class));
        b.b(data);
    }

    public static void setPushNotificationRegistrationToken(String token) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("token").setType(String.class));
        b.a(token);
    }

    public static void setCustomTextPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class));
        SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder);
    }

    @Deprecated
    public static void setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean galleryImage, boolean screenRecording) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("initialScreenshot").setType(Boolean.TYPE).setValue(initialScreenshot), new Api.Parameter().setName("extraScreenshot").setType(Boolean.TYPE).setValue(extraScreenshot), new Api.Parameter().setName("galleryImage").setType(Boolean.TYPE).setValue(galleryImage), new Api.Parameter().setName("screenRecording").setType(Boolean.TYPE).setValue(screenRecording));
        a.a(initialScreenshot, extraScreenshot, galleryImage, screenRecording);
        b.a(extraScreenshot, galleryImage, screenRecording);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return UserAttributesCacheManager.getAll();
    }

    public static void setUserAttribute(@NonNull String key, String value) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class), new Api.Parameter().setName("value").setType(String.class));
        value = StringUtility.trimString(value);
        UserAttributesCacheManager.putAttribute(key, value);
    }

    @Nullable
    public static String getUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        return UserAttributesCacheManager.getAttribute(key);
    }

    public static void removeUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        UserAttributesCacheManager.deleteAttribute(key);
    }

    public static void clearAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        UserAttributesCacheManager.deleteAll();
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setShouldPlayConversationSounds(boolean shouldPlaySounds) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("shouldPlaySounds").setType(Boolean.TYPE).setValue(shouldPlaySounds));
        b.b(shouldPlaySounds);
    }

    public static void setWelcomeMessageState(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(welcomeMessageState.toString()));
        SettingsManager.getInstance().setWelcomeMessageState(welcomeMessageState);
        InstabugDeprecationLogger.getInstance().log();
    }

    public static void showWelcomeMessage(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(welcomeMessageState.toString()));
        if (!InstabugCore.isForegroundBusy()) {
            Instabug.getInstance().delegate.a(welcomeMessageState);
        }
    }

    public static void setNotificationIcon(@DrawableRes int notificationIcon) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("notificationIcon").setType(Integer.TYPE));
        b.a(notificationIcon);
    }

    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.VIEW_HIERARCHY, state);
    }

    public static void setCrashReportingState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.CRASH_REPORTING, state);
    }

    @Deprecated
    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("setAutoScreenRecordingEnabled").setType(Boolean.class).setValue(String.valueOf(autoScreenRecordingEnabled)));
        SettingsManager.getInstance().setAutoScreenRecordingEnabled(autoScreenRecordingEnabled);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
    }

    @Deprecated
    public static void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(autoScreenRecordingMaxDuration)));
        SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(autoScreenRecordingMaxDuration);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
    }

    @RequiresApi(api=26)
    public static void setPushNotificationChannelId(String pushNotificationChannelId) {
        APIBuildChecker.check();
        b.b(pushNotificationChannelId);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.SESSION_PROFILER, state);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.b.a().a(Feature.TRACK_USER_STEPS, state);
    }

    public static void setReproStepsState(State reproStepsState) {
        if (reproStepsState == State.ENABLED) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(true);
            Log.e((String)Instabug.class.getName(), (String)"UserSteps with screenshots Mode is disabled please contact support for further details.");
        } else if (reproStepsState == State.ENABLED_WITH_NO_SCREENSHOTS) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(false);
        } else if (reproStepsState == State.DISABLED) {
            com.instabug.library.b.a().a(Feature.REPRO_STEPS, Feature.State.DISABLED);
        }
    }

    public static void setOnNewReplyReceivedCallback(Runnable runnable) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        b.a(runnable);
    }

    public static void setReplyNotificationEnabled(boolean isReplyNotificationEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isReplyNotificationEnabled").setType(Boolean.TYPE).setValue(isReplyNotificationEnabled));
        b.a(isReplyNotificationEnabled);
    }

    public static void setSystemReplyNotificationSoundEnabled(boolean shouldPlaySound) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("setSystemReplyNotificationSoundEnabled").setType(Boolean.TYPE).setValue(shouldPlaySound));
        b.c(shouldPlaySound);
    }

    public static void setInAppReplyNotificationSound(boolean shouldPlaySound) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(shouldPlaySound));
        b.d(shouldPlaySound);
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugTheme));
        SettingsManager.getInstance().setTheme(instabugTheme);
        switch (instabugTheme) {
            case InstabugColorThemeDark: {
                SettingsManager.getInstance().setPrimaryColor(-9580554);
                SettingsManager.getInstance().setStatusBarColor(-16119286);
                break;
            }
            case InstabugColorThemeLight: {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        }
    }

    public static void logUserEvent(@NonNull String eventIdentifier) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class));
        InstabugUserEventLogger.getInstance().logUserEvent(eventIdentifier, new UserEventParam[0]);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class));
        SettingsManager.getInstance().setOnReportCreatedListener(listener);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingDuration(@IntRange(from=30L, to=180L) int maxDuration) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("maxDuration").setType(Integer.class).setValue(maxDuration));
        SettingsManager.getInstance().setAutoScreenRecordingDuration(maxDuration);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("asrAudioCapturingEnabled").setType(Feature.State.class).setValue(isASRAudioEnabled.name()));
        SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(isASRAudioEnabled);
    }

    @Deprecated
    public static void setShouldAudioRecordingOptionAppear(boolean shouldBeVisible) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    static boolean shouldAudioRecordingOptionAppear() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return false;
    }

    @Deprecated
    public static void changeInvocationEvent(@NonNull InstabugInvocationEvent instabugInvocationEvent) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)instabugInvocationEvent));
        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEvent);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void changeInvocationEvent(@NonNull IBGInvocationEvent invocationEvent) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationEvent").setType(IBGInvocationEvent.class).setValue((Object)invocationEvent));
        switch (invocationEvent) {
            case IBGInvocationEventNone: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.NONE);
                break;
            }
            case IBGInvocationEventShake: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.SHAKE);
                break;
            }
            case IBGInvocationEventFloatingButton: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.FLOATING_BUTTON);
                break;
            }
            case IBGInvocationEventTwoFingersSwipeLeft: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.TWO_FINGER_SWIPE_LEFT);
                break;
            }
            case IBGInvocationScreenshotGesture: {
                Instabug.changeInvocationEvent(InstabugInvocationEvent.SCREENSHOT_GESTURE);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invoke() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().invoke();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setDialog(@NonNull Dialog dialog) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("dialog").setType(Dialog.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void addMapView(@NonNull View mapView, @NonNull Object googleMap) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("mapView").setType(View.class), new Api.Parameter().setName("googleMap").setType(Object.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void addCapturableView(@NonNull CapturableView capturableView) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("capturableView").setType(CapturableView.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setGLSurfaceView(@NonNull GLSurfaceView surfaceView) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("surfaceView").setType(GLSurfaceView.class));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invoke(@NonNull InstabugInvocationMode instabugInvocationMode) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugInvocationMode").setType(InstabugInvocationMode.class).setValue(instabugInvocationMode.toString()));
        switch (instabugInvocationMode) {
            case NEW_BUG: {
                InvocationManager.getInstance().invoke(1);
                break;
            }
            case NEW_FEEDBACK: {
                InvocationManager.getInstance().invoke(2);
                break;
            }
            case NEW_CHAT: {
                InvocationManager.getInstance().invoke(3);
                break;
            }
            case CHATS_LIST: {
                InvocationManager.getInstance().invoke(4);
                break;
            }
            default: {
                InvocationManager.getInstance().invoke(0);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invokeConversations() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.invoke(InstabugInvocationMode.CHATS_LIST);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void invoke(@NonNull IBGInvocationMode invocationMode) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationMode").setType(IBGInvocationMode.class).setValue((Object)invocationMode));
        switch (invocationMode) {
            case IBGInvocationModeNA: {
                Instabug.invoke(InstabugInvocationMode.PROMPT_OPTION);
                break;
            }
            case IBGInvocationModeBugReporter: {
                Instabug.invoke(InstabugInvocationMode.NEW_BUG);
                break;
            }
            case IBGInvocationModeFeedbackSender: {
                Instabug.invoke(InstabugInvocationMode.NEW_FEEDBACK);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setDefaultInvocationMode(int invocationMode) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setDefaultInvocationMode").setType(Invocation.class).setValue(invocationMode));
        InvocationManager.getInstance().getCurrentInvocationSettings().setDefaultInvocationMode(invocationMode);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void resetDefaultInvocationMode() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().getCurrentInvocationSettings().resetDefaultInvocationMode();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void showIntroMessage() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.getInstance().delegate.a(WelcomeMessage.State.LIVE);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void log(@NonNull String message) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("message").setType(String.class));
        if (com.instabug.library.b.a().b(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            InstabugLog.d(message);
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void clearLog() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter[0]);
        InstabugLog.clearLogs();
    }

    @Deprecated
    public static void reportException(@NonNull Throwable throwable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("throwable").setType(Throwable.class));
        Instabug.reportException(throwable, null);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("throwable").setType(Throwable.class), new Api.Parameter().setName("exceptionIdentifier").setType(String.class));
        c.a(throwable, exceptionIdentifier);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPreSendingRunnable(Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedLoggingApiUsage(new Api.Parameter().setName("preSendingRunnable").setType(Runnable.class));
        SettingsManager.getInstance().setPreReportRunnable(runnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static IBGColorTheme getColorTheme() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        switch (SettingsManager.getInstance().getTheme()) {
            case InstabugColorThemeDark: {
                return IBGColorTheme.IBGColorThemeDark;
            }
            case InstabugColorThemeLight: {
                return IBGColorTheme.IBGColorThemeLight;
            }
        }
        return IBGColorTheme.IBGColorThemeLight;
    }

    @Deprecated
    public static void setFileAttachment(Uri fileUri, @Nullable String fileNameWithExtension) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        Instabug.addFileAttachment(fileUri, fileNameWithExtension);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setOnSdkInvokedCallback(OnSdkInvokedCallback onSdkInvokedCallback) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("onSdkInvokedCallback").setType(OnSdkInvokedCallback.class));
        SettingsManager.getInstance().setOnSdkInvokedCallback(onSdkInvokedCallback);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPreInvocation(final Runnable preInvocationRunnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("preSdkInvocationRunnable").setType(Runnable.class));
        SettingsManager.getInstance().setOnInvokeCallback(new OnInvokeCallback(){

            @Override
            public void onInvoke() {
                preInvocationRunnable.run();
            }
        });
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class));
        a.a(onSdkDismissedCallback);
        b.a(onSdkDismissedCallback);
        SettingsManager.getInstance().setOnSdkDismissedCallback(onSdkDismissedCallback);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setNewMessageHandler(Runnable runnable) throws IllegalStateException {
        b.a(runnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void changeLocale(Locale locale) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        SettingsManager.getInstance().setInstabugLocale(locale);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setUserEmail(@NonNull String email) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("email").setType(String.class));
        com.instabug.library.user.a.d(email);
    }

    @Deprecated
    public static void setUsername(@NonNull String username) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("username").setType(String.class));
        com.instabug.library.user.a.a(username);
    }

    @Deprecated
    public static void dismiss() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.getInstance().delegate.m();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setChatNotificationEnabled(boolean isChatNotificationEnable) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isChatNotificationEnable").setType(Boolean.TYPE).setValue(isChatNotificationEnable));
        b.a(isChatNotificationEnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setBugCategories(List<BugCategory> bugCategories) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("bugCategories").setType(List.class));
        a.a(bugCategories);
    }

    @Deprecated
    public static void setReportCategories(List<ReportCategory> reportCategories) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("reportCategories").setType(List.class));
        a.b(reportCategories);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean galleryImage, boolean voiceNote, boolean screenRecording) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("initialScreenshot").setType(Boolean.TYPE).setValue(initialScreenshot), new Api.Parameter().setName("extraScreenshot").setType(Boolean.TYPE).setValue(extraScreenshot), new Api.Parameter().setName("galleryImage").setType(Boolean.TYPE).setValue(galleryImage), new Api.Parameter().setName("voiceNote").setType(Boolean.TYPE).setValue(voiceNote), new Api.Parameter().setName("screenRecording").setType(Boolean.TYPE).setValue(screenRecording));
        Instabug.setAttachmentTypesEnabled(initialScreenshot, extraScreenshot, galleryImage, screenRecording);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static boolean showValidSurvey() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.a();
    }

    @Deprecated
    public static void setCustomTextPlaceHolders(IBGCustomTextPlaceHolder ibgCustomTextPlaceHolder) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("ibgCustomTextPlaceHolder").setType(IBGCustomTextPlaceHolder.class));
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder = new InstabugCustomTextPlaceHolder();
        instabugCustomTextPlaceHolder.setPlaceHoldersMap(ibgCustomTextPlaceHolder.getConvertedHashMap());
        Instabug.setCustomTextPlaceHolders(instabugCustomTextPlaceHolder);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setThresholdForReshowingSurveyAfterDismiss(int sessionsCount, int daysCount) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.a(sessionsCount, daysCount);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setSurveysAutoShowing(boolean isSurveysAutoShowing) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isSurveysAutoShowing").setType(Boolean.class).setValue(isSurveysAutoShowing));
        e.a(isSurveysAutoShowing);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPreShowingSurveyRunnable(Runnable preShowingSurveyRunnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.a(preShowingSurveyRunnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setAfterShowingSurveyRunnable(Runnable afterShowingSurveyRunnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.b(afterShowingSurveyRunnable);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setRequestedOrientation(int requestedOrientation) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().setRequestedOrientation(requestedOrientation);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void resetRequestedOrientation() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetRequestedOrientation();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    @CheckResult
    public static int getRequestedOrientation() {
        return OrientationUtils.getOrientation(SettingsManager.getInstance().getRequestedOrientation());
    }

    @Deprecated
    public static void setEnableSystemNotificationSound(boolean shouldPlaySound) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(shouldPlaySound));
        b.c(shouldPlaySound);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEnableInAppNotificationSound(boolean shouldPlaySound) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(shouldPlaySound));
        b.d(shouldPlaySound);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setPromptOptionsEnabled(boolean chat, boolean bug, boolean feedback) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("chat").setType(Boolean.TYPE).setValue(chat), new Api.Parameter().setName("bug").setType(Boolean.TYPE).setValue(bug), new Api.Parameter().setName("feedback").setType(Boolean.TYPE).setValue(Boolean.toString(feedback)));
        InvocationSettings invocationSettings = InvocationManager.getInstance().getCurrentInvocationSettings();
        if (chat) {
            invocationSettings.enabledPromptOption(4);
        } else {
            invocationSettings.disabledPromptOption(4);
        }
        if (bug) {
            invocationSettings.enabledPromptOption(1);
        } else {
            invocationSettings.disabledPromptOption(1);
        }
        if (feedback) {
            invocationSettings.enabledPromptOption(2);
        } else {
            invocationSettings.disabledPromptOption(2);
        }
        if (chat && (bug || feedback) || bug && feedback) {
            invocationSettings.setDefaultInvocationMode(0);
        } else if (chat) {
            invocationSettings.setDefaultInvocationMode(4);
        } else if (bug) {
            invocationSettings.setDefaultInvocationMode(1);
        } else if (feedback) {
            invocationSettings.setDefaultInvocationMode(2);
        }
        if (!(chat || bug || feedback)) {
            invocationSettings.enabledPromptOption(1);
            invocationSettings.setDefaultInvocationMode(1);
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setShakingThreshold(int threshold) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue(Integer.toString(threshold)));
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(threshold);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setSuccessDialogEnabled(boolean enabled) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(enabled));
        a.d(enabled);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setIntroMessageEnabled(boolean enabled) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(enabled));
        Instabug.setWelcomeMessageState(enabled ? WelcomeMessage.State.LIVE : WelcomeMessage.State.DISABLED);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setCommentFieldRequired(boolean commentFieldRequired) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("commentFieldRequired").setType(Boolean.TYPE).setValue(commentFieldRequired));
        a.b(commentFieldRequired);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEmailFieldVisibility(boolean emailFieldVisibility) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.TYPE).setValue(emailFieldVisibility));
        a.c(emailFieldVisibility);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEmailFieldRequired(boolean emailFieldRequired) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        Instabug.setEmailFieldRequired(emailFieldRequired, 1);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setEmailFieldRequired(boolean emailFieldRequired, int ... actions) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldRequired").setType(Boolean.TYPE).setValue(emailFieldRequired), new Api.Parameter().setName("actions").setValue(String.class).setValue(Arrays.toString(actions)));
        if (actions == null || actions.length == 0) {
            a.a(emailFieldRequired);
            d.a(emailFieldRequired);
            d.b(emailFieldRequired);
        } else {
            block6: for (int n : actions) {
                switch (n) {
                    case 1: {
                        a.a(emailFieldRequired);
                        d.a(emailFieldRequired);
                        d.b(emailFieldRequired);
                        return;
                    }
                    case 2: {
                        a.a(emailFieldRequired);
                        continue block6;
                    }
                    case 4: {
                        d.a(emailFieldRequired);
                        continue block6;
                    }
                    case 8: {
                        d.b(emailFieldRequired);
                        continue block6;
                    }
                }
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setWillSkipScreenshotAnnotation(boolean willSkipInitialScreenshotAnnotating) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("willSkipInitialScreenshotAnnotating").setType(Boolean.TYPE).setValue(willSkipInitialScreenshotAnnotating));
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setTheme(@NonNull InstabugColorTheme instabugTheme) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugTheme));
        SettingsManager.getInstance().setTheme(instabugTheme);
        switch (instabugTheme) {
            case InstabugColorThemeDark: {
                SettingsManager.getInstance().setPrimaryColor(-9580554);
                SettingsManager.getInstance().setStatusBarColor(-16119286);
                break;
            }
            case InstabugColorThemeLight: {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static boolean showSurvey(@NonNull String token) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.a(token);
    }

    @Deprecated
    public static boolean hasRespondToSurvey(@NonNull String token) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.b(token);
    }

    @Deprecated
    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setFloatingButtonOffsetFromTop(@IntRange(from=0L) int floatingButtonOffsetFromTop) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue(Integer.toString(floatingButtonOffsetFromTop)));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setVideoRecordingFloatingButtonCorner(@NonNull InstabugVideoRecordingButtonCorner instabugVideoRecordingButtonCorner) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugViewRecordingButtonCorner").setType(InstabugVideoRecordingButtonCorner.class).setValue((Object)instabugVideoRecordingButtonCorner));
        switch (instabugVideoRecordingButtonCorner) {
            case TOP_LEFT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.TOP_LEFT);
                break;
            }
            case TOP_RIGHT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.TOP_RIGHT);
                break;
            }
            case BOTTOM_RIGHT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.BOTTOM_RIGHT);
                break;
            }
            case BOTTOM_LEFT: {
                InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition.BOTTOM_LEFT);
            }
        }
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void addExtraReportField(CharSequence fieldHint, boolean required) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("fieldHint").setType(CharSequence.class).setValue(fieldHint), new Api.Parameter().setName("required").setType(Boolean.TYPE).setValue(required));
        a.a(fieldHint, required);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void clearExtraReportFields() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        a.b();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("state").setType(ExtendedBugReport.State.class).setValue((Object)state));
        a.a(state);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void showFeatureRequests() {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        d.a();
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static void setShouldShowSurveysWelcomeScreen(boolean shouldShow) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        e.b(shouldShow);
        InstabugDeprecationLogger.getInstance().log();
    }

    @Deprecated
    public static boolean hasValidSurveys() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        InstabugDeprecationLogger.getInstance().log();
        return e.b();
    }

    @Deprecated
    public static void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class), new Api.Parameter().setName("userEventParams").setType(UserEventParam.class));
        InstabugUserEventLogger.getInstance().logUserEvent(eventIdentifier, userEventParams);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class Builder {
        private String applicationToken;
        private Context applicationContext;
        private Application application;
        private InstabugColorTheme instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
        private int instabugPrimaryColor = -15893761;
        private int instabugStatusBarColor = -3815737;
        private InstabugInvocationEvent[] instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
        private int defaultInvocationMode = 0;
        private Feature.State userDataState = com.instabug.library.b.a;
        private Feature.State consoleLogState = com.instabug.library.b.a;
        private Feature.State instabugLogState = com.instabug.library.b.a;
        private Feature.State inAppMessagingState = com.instabug.library.b.a;
        private Feature.State crashReportingState = com.instabug.library.b.a;
        private Feature.State pushNotificationState = com.instabug.library.b.a;
        private Feature.State trackingUserStepsState = com.instabug.library.b.a;
        private State reproStepsState = State.ENABLED;
        private Feature.State viewHierarchyState = com.instabug.library.b.a;
        private Feature.State surveysState = com.instabug.library.b.a;
        private Feature.State userEventsState = com.instabug.library.b.a;
        private boolean emailFieldRequired = true;
        private boolean emailFieldVisibility = true;
        private AttachmentsTypesParams attachmentsTypesParams = new AttachmentsTypesParams();
        private boolean commentFieldRequired = false;
        private boolean introMessageEnabled = true;
        private boolean shouldPlaySounds = false;
        private boolean successDialogEnabled = true;
        private boolean playSystemNotificationSound;
        private boolean playInAppNotificationSound;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
        private int shakingThreshold = 650;
        private int floatingButtonOffsetFromTop = -1;
        private Locale instabugLocale = Locale.getDefault();
        private int notificationIcon;
        private boolean isSurveysAutoShowing = true;
        private boolean chatPromptOptionEnable = true;
        private boolean bugPromptOptionEnable = true;
        private boolean feedbackPromptOptionEnable = true;

        public Builder(Application application, String applicationToken) {
            this(application, applicationToken, InstabugInvocationEvent.SHAKE);
        }

        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(application.getApplicationContext(), applicationToken, instabugInvocationEvent);
            this.application = application;
        }

        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            this.applicationContext = applicationContext;
            this.instabugInvocationEvents = instabugInvocationEvents;
            this.applicationToken = applicationToken;
        }

        @Deprecated
        public Builder setInvocationEvent(IBGInvocationEvent invocationEvent) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationEvent").setType(IBGInvocationEvent.class).setValue((Object)invocationEvent));
            switch (invocationEvent) {
                case IBGInvocationEventNone: {
                    this.setInvocationEvent(InstabugInvocationEvent.NONE);
                    break;
                }
                case IBGInvocationEventShake: {
                    this.setInvocationEvent(InstabugInvocationEvent.SHAKE);
                    break;
                }
                case IBGInvocationEventFloatingButton: {
                    this.setInvocationEvent(InstabugInvocationEvent.FLOATING_BUTTON);
                    break;
                }
                case IBGInvocationEventTwoFingersSwipeLeft: {
                    this.setInvocationEvent(InstabugInvocationEvent.TWO_FINGER_SWIPE_LEFT);
                    break;
                }
                case IBGInvocationScreenshotGesture: {
                    this.setInvocationEvent(InstabugInvocationEvent.SCREENSHOT_GESTURE);
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setInvocationEvent(@NonNull InstabugInvocationEvent instabugInvocationEvent) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)instabugInvocationEvent));
            this.instabugInvocationEvents = new InstabugInvocationEvent[]{instabugInvocationEvent};
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue(TextUtils.join((CharSequence)",", (Object[])instabugInvocationEvents)));
            this.instabugInvocationEvents = instabugInvocationEvents;
            return this;
        }

        @Deprecated
        public Builder setShouldPlayConversationSounds(boolean shouldPlaySounds) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySounds").setType(Boolean.TYPE).setValue(shouldPlaySounds));
            this.shouldPlaySounds = shouldPlaySounds;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEnableSystemNotificationSound(boolean shouldPlaySound) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(shouldPlaySound));
            this.playSystemNotificationSound = shouldPlaySound;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEnableInAppNotificationSound(boolean shouldPlaySound) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("shouldPlaySound").setType(Boolean.TYPE).setValue(shouldPlaySound));
            this.playInAppNotificationSound = shouldPlaySound;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setDefaultInvocationMode(IBGInvocationMode invocationMode) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("invocationMode").setType(IBGInvocationMode.class).setValue((Object)invocationMode));
            switch (invocationMode) {
                case IBGInvocationModeNA: {
                    this.defaultInvocationMode = 0;
                    break;
                }
                case IBGInvocationModeBugReporter: {
                    this.defaultInvocationMode = 1;
                    break;
                }
                case IBGInvocationModeFeedbackSender: {
                    this.defaultInvocationMode = 2;
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setPromptOptionsEnabled(boolean chat, boolean bug, boolean feedback) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("chat").setType(Boolean.TYPE).setValue(chat), new Api.Parameter().setName("bug").setType(Boolean.TYPE).setValue(bug), new Api.Parameter().setName("feedback").setType(Boolean.TYPE).setValue(Boolean.toString(feedback)));
            this.chatPromptOptionEnable = chat;
            this.bugPromptOptionEnable = bug;
            this.feedbackPromptOptionEnable = feedback;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setShakingThreshold(int threshold) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue(Integer.toString(threshold)));
            this.shakingThreshold = threshold;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setShouldShowIntroDialog(boolean enabled) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(enabled));
            this.introMessageEnabled = enabled;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setSuccessDialogEnabled(boolean enabled) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(enabled));
            this.successDialogEnabled = enabled;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setIntroMessageEnabled(boolean enabled) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("enabled").setType(Boolean.TYPE).setValue(enabled));
            this.introMessageEnabled = enabled;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.trackingUserStepsState = state;
            return this;
        }

        public Builder setReproStepsState(State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(State.class).setValue((Object)state));
            this.reproStepsState = state;
            return this;
        }

        public Builder setPushNotificationState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.pushNotificationState = state;
            return this;
        }

        public Builder setConsoleLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.consoleLogState = state;
            return this;
        }

        public Builder setCrashReportingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.crashReportingState = state;
            return this;
        }

        public Builder setInstabugLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.instabugLogState = state;
            return this;
        }

        public Builder setUserDataState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userDataState = state;
            return this;
        }

        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.inAppMessagingState = state;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.viewHierarchyState = state;
            return this;
        }

        public Builder setSurveysState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.surveysState = state;
            return this;
        }

        public Builder setUserEventsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userEventsState = state;
            return this;
        }

        @Deprecated
        public Builder setCommentFieldRequired(boolean commentFieldRequired) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("commentFieldRequired").setType(Boolean.TYPE).setValue(commentFieldRequired));
            this.commentFieldRequired = commentFieldRequired;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEmailFieldRequired(boolean emailFieldRequired) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldRequired").setType(Boolean.TYPE).setValue(emailFieldRequired));
            this.emailFieldRequired = emailFieldRequired;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setEmailFieldVisibility(boolean emailFieldVisibility) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.TYPE).setValue(emailFieldVisibility));
            this.emailFieldVisibility = emailFieldVisibility;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setWillTakeScreenshot(boolean willTakeInitialScreenshot) throws IllegalStateException {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("willTakeInitialScreenshot").setType(Boolean.TYPE).setValue(willTakeInitialScreenshot));
            this.attachmentsTypesParams.setShouldTakesInitialScreenshot(willTakeInitialScreenshot);
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean galleryImage, boolean voiceNote, boolean screenRecording) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("initialScreenshot").setType(Boolean.TYPE).setValue(initialScreenshot), new Api.Parameter().setName("extraScreenshot").setType(Boolean.TYPE).setValue(extraScreenshot), new Api.Parameter().setName("galleryImage").setType(Boolean.TYPE).setValue(galleryImage), new Api.Parameter().setName("voiceNote").setType(Boolean.TYPE).setValue(voiceNote), new Api.Parameter().setName("screenRecording").setType(Boolean.TYPE).setValue(screenRecording));
            this.attachmentsTypesParams.setShouldTakesInitialScreenshot(initialScreenshot).setAllowTakeExtraScreenshot(extraScreenshot).setAllowAttachImageFromGallery(galleryImage).setAllowScreenRecording(screenRecording);
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setWillSkipScreenshotAnnotation(boolean willSkipInitialScreenshotAnnotating) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("willSkipInitialScreenshotAnnotating").setType(Boolean.TYPE).setValue(willSkipInitialScreenshotAnnotating));
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setColorTheme(IBGColorTheme theme) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("theme").setType(IBGColorTheme.class).setValue((Object)theme));
            switch (theme) {
                case IBGColorThemeDark: {
                    this.instabugTheme = InstabugColorTheme.InstabugColorThemeDark;
                    this.instabugPrimaryColor = -9580554;
                    break;
                }
                case IBGColorThemeLight: {
                    this.instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
                    this.instabugPrimaryColor = -15893761;
                    break;
                }
                case theme: {
                    this.instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
                    this.instabugPrimaryColor = -15893761;
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setTheme(@NonNull InstabugColorTheme instabugTheme) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugTheme));
            this.instabugTheme = instabugTheme;
            switch (instabugTheme) {
                case InstabugColorThemeDark: {
                    this.instabugPrimaryColor = -9580554;
                    this.instabugStatusBarColor = -16119286;
                    break;
                }
                case InstabugColorThemeLight: {
                    this.instabugPrimaryColor = -15893761;
                    this.instabugStatusBarColor = -3815737;
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setFloatingButtonEdge(IBGFloatingButtonEdge floatingButtonEdge) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("floatingButtonEdge").setType(IBGFloatingButtonEdge.class).setValue((Object)floatingButtonEdge));
            switch (floatingButtonEdge) {
                case Right: {
                    this.setFloatingButtonEdge(InstabugFloatingButtonEdge.RIGHT);
                    break;
                }
                case Left: {
                    this.setFloatingButtonEdge(InstabugFloatingButtonEdge.LEFT);
                }
            }
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("instabugFloatingButtonEdge").setType(IBGFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge));
            this.instabugFloatingButtonEdge = instabugFloatingButtonEdge;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setFloatingButtonOffsetFromTop(@IntRange(from=0L) int floatingButtonOffsetFromTop) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue(Integer.toString(floatingButtonOffsetFromTop)));
            this.floatingButtonOffsetFromTop = floatingButtonOffsetFromTop;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setLocale(Locale locale) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
            this.instabugLocale = locale;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setNotificationIcon(int notificationIcon) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("notificationIcon").setType(Integer.TYPE));
            this.notificationIcon = notificationIcon;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        @Deprecated
        public Builder setSurveysAutoShowing(boolean isSurveysAutoShowing) {
            AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("isSurveysAutoShowing").setType(Boolean.TYPE).setValue(isSurveysAutoShowing));
            this.isSurveysAutoShowing = isSurveysAutoShowing;
            InstabugDeprecationLogger.getInstance().log();
            return this;
        }

        public Instabug build(Feature.State instabugInitialState) {
            SettingsManager.init(this.applicationContext);
            boolean bl = instabugInitialState == Feature.State.ENABLED;
            this.setFeaturesStates(bl);
            com.instabug.library.a a2 = new com.instabug.library.a(this.applicationContext);
            INSTANCE = new Instabug(a2);
            Instabug.setState(InstabugState.BUILT);
            a2.a(this.applicationContext);
            InstabugInternalTrackingDelegate.init(this.application);
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            a2.a();
            SettingsManager.getInstance().setInstabugLocale(this.instabugLocale);
            SettingsManager.getInstance().setTheme(this.instabugTheme);
            SettingsManager.getInstance().setPrimaryColor(this.instabugPrimaryColor);
            SettingsManager.getInstance().setStatusBarColor(this.instabugStatusBarColor);
            a.a(this.attachmentsTypesParams.isShouldTakesInitialScreenshot(), this.attachmentsTypesParams.isAllowTakeExtraScreenshot(), this.attachmentsTypesParams.isAllowAttachImageFromGallery(), this.attachmentsTypesParams.isAllowScreenRecording());
            a.a(this.emailFieldRequired);
            a.c(this.emailFieldVisibility);
            a.d(this.successDialogEnabled);
            InvocationManager.getInstance().setInstabugInvocationEvent(this.instabugInvocationEvents);
            Instabug.setPromptOptionsEnabled(this.chatPromptOptionEnable, this.bugPromptOptionEnable, this.feedbackPromptOptionEnable);
            InvocationManager.getInstance().getCurrentInvocationSettings().setDefaultInvocationMode(this.defaultInvocationMode);
            InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(this.shakingThreshold);
            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(this.instabugFloatingButtonEdge);
            if (this.floatingButtonOffsetFromTop != -1) {
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(this.floatingButtonOffsetFromTop);
            }
            a.b(this.commentFieldRequired);
            b.b(this.shouldPlaySounds);
            b.c(this.playSystemNotificationSound);
            b.d(this.playInAppNotificationSound);
            b.a(this.notificationIcon);
            b.a(this.attachmentsTypesParams.isAllowTakeExtraScreenshot(), this.attachmentsTypesParams.isAllowAttachImageFromGallery(), this.attachmentsTypesParams.isAllowScreenRecording());
            e.a(this.isSurveysAutoShowing);
            return INSTANCE;
        }

        public Instabug build() {
            if (Instabug.isBuilt()) {
                if (InternalScreenRecordHelper.getInstance().isRecording()) {
                    InternalScreenRecordHelper.getInstance().cancel();
                }
                Instabug.disable();
            }
            return this.build(Feature.State.ENABLED);
        }

        private void setFeaturesStates(Boolean isInstabugEnabled) {
            InstabugSDKLogger.v(this, "Setting user data feature state " + (Object)((Object)this.userDataState));
            com.instabug.library.b.a().a(Feature.USER_DATA, this.userDataState);
            InstabugSDKLogger.v(this, "Setting console log feature state " + (Object)((Object)this.consoleLogState));
            com.instabug.library.b.a().a(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugSDKLogger.v(this, "Setting Instabug logs feature state " + (Object)((Object)this.instabugLogState));
            com.instabug.library.b.a().a(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugSDKLogger.v(this, "Setting crash reporting feature state " + (Object)((Object)this.crashReportingState));
            com.instabug.library.b.a().a(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugSDKLogger.v(this, "Setting in-app messaging feature state " + (Object)((Object)this.inAppMessagingState));
            com.instabug.library.b.a().a(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugSDKLogger.v(this, "Setting push notification feature state " + (Object)((Object)this.pushNotificationState));
            com.instabug.library.b.a().a(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugSDKLogger.v(this, "Setting tracking user steps feature state " + (Object)((Object)this.trackingUserStepsState));
            com.instabug.library.b.a().a(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            InstabugSDKLogger.v(this, "Setting repro steps feature state " + (Object)((Object)this.reproStepsState));
            Instabug.setReproStepsState(this.reproStepsState);
            InstabugSDKLogger.v(this, "Setting view hierarchy  feature state " + (Object)((Object)this.viewHierarchyState));
            com.instabug.library.b.a().a(Feature.VIEW_HIERARCHY, this.viewHierarchyState);
            InstabugSDKLogger.v(this, "Setting surveys feature state " + (Object)((Object)this.surveysState));
            com.instabug.library.b.a().a(Feature.SURVEYS, this.surveysState);
            InstabugSDKLogger.v(this, "Setting user events feature state " + (Object)((Object)this.userEventsState));
            com.instabug.library.b.a().a(Feature.USER_EVENTS, this.userEventsState);
            InstabugSDKLogger.v(this, "Setting instabug overall state " + isInstabugEnabled);
            com.instabug.library.b.a().a(Feature.INSTABUG, isInstabugEnabled);
        }
    }
}

