/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.video.InstabugVideoUtils;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.internal.video.a.f;
import com.instabug.library.internal.video.a.g;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.c;
import java.io.File;
import java.io.IOException;

@TargetApi(value=21)
final class a {
    private final Context a;
    private final a b;
    private final File c;
    private String d;
    private boolean e;
    private boolean f;
    private MediaProjection g;
    private f h;

    a(Context context, a a2, int n, Intent intent) {
        this.a = context;
        this.b = a2;
        this.f = InternalScreenRecordHelper.getInstance().isRecording();
        if (this.f) {
            this.c = AttachmentsUtility.getVideoRecordingFramesDirectory(context);
            this.d = AttachmentsUtility.getVideoFile(context).getAbsolutePath();
        } else {
            this.c = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
            this.d = AttachmentManager.getAutoScreenRecordingFile(context).getAbsolutePath();
        }
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.g = mediaProjectionManager.getMediaProjection(n, intent);
        g g2 = this.e();
        com.instabug.library.internal.video.a.a a3 = this.d();
        this.h = new f(g2, a3, this.g, this.d);
        this.g();
    }

    private com.instabug.library.internal.video.a.a d() {
        if (!com.instabug.library.util.c.a()) {
            return null;
        }
        return new com.instabug.library.internal.video.a.a();
    }

    private g e() {
        int[] nArray = this.f();
        Configuration configuration = this.a.getResources().getConfiguration();
        boolean bl = configuration.orientation == 2;
        int n = nArray[bl ? 0 : 1];
        int n2 = nArray[bl ? 1 : 0];
        int n3 = nArray[2];
        return new g(n, n2, n3);
    }

    private int[] f() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.a.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        int n3 = displayMetrics.densityDpi;
        return new int[]{n2, n, n3};
    }

    private void g() {
        if (!this.c.exists() && !this.c.mkdirs()) {
            InstabugSDKLogger.d(this, "Unable to create output directory.\nCannot record screen.");
            return;
        }
        this.h.b();
        this.e = true;
        this.b.a();
        if (this.f) {
            InternalScreenRecordHelper.getInstance().startTimerOnRecordingFAB();
        }
        com.instabug.library.util.c.a(this.a);
        InstabugSDKLogger.i(this, "Screen recording started");
    }

    private void h() {
        if (!this.e) {
            throw new IllegalStateException("Not running.");
        }
        this.e = false;
        boolean bl = false;
        try {
            this.g.stop();
            if (this.h != null) {
                this.h.a();
            }
            this.h = null;
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            this.h.a();
            bl = true;
        }
        finally {
            block14: {
                try {
                    this.b.b();
                }
                catch (RuntimeException runtimeException) {
                    if (!bl) break block14;
                    throw runtimeException;
                }
            }
        }
        InstabugSDKLogger.d(this, "Screen recording stopped");
    }

    void a() {
        if (this.e) {
            this.h();
        }
    }

    void b() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                File file = new File(a.this.d);
                if (file.delete()) {
                    InstabugSDKLogger.d(this, "Screen recording file deleted");
                }
            }
        });
        thread.start();
    }

    public void c() {
        File file = new File(this.d);
        InstabugSDKLogger.d(this, "Recorded video file size: " + file.length() / 1024L + " KB");
        if (this.f) {
            InternalScreenRecordHelper.getInstance().setAutoScreenRecordingFile(file);
            InternalScreenRecordHelper.getInstance().onRecordingFinished();
        } else {
            InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file);
        }
    }

    void a(final int n) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                File file = new File(a.this.d);
                try {
                    File file2 = InstabugVideoUtils.startTrim(file, AttachmentManager.getAutoScreenRecordingFile(a.this.a), n);
                    InstabugSDKLogger.d(this, "Recorded video file size after trim: " + file2.length() / 1024L + " KB");
                    InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file2);
                }
                catch (IOException | IllegalArgumentException exception) {
                    exception.printStackTrace();
                    InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file);
                }
            }
        });
        thread.start();
    }

    static interface a {
        public void a();

        public void b();
    }
}

