/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.ScreenRecordingFileHolder;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.a.c;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.io.File;

public class InternalScreenRecordHelper
implements ScreenRecordingContract,
c.c {
    private static InternalScreenRecordHelper INSTANCE;
    private final Subject<Boolean> stopSubject = BehaviorSubject.createDefault((Object)false);
    private c fab;
    private Disposable sessionDisposable;
    private boolean canStopRecording;
    private ScreenRecordingFileHolder fileHolder;
    private boolean isCurrentlyRecording = false;
    private Intent resultDataIntent;

    private InternalScreenRecordHelper() {
    }

    public static InternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    public void init() {
        InvocationManager.getInstance().switchOffInvocation();
        this.fileHolder = ScreenRecordingFileHolder.getInstance();
        this.subscribeToSessionEvents();
        if (this.fab == null) {
            this.fab = new c(this);
        }
        this.fab.a();
    }

    private void subscribeToSessionEvents() {
        if (this.sessionDisposable == null || this.sessionDisposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer<Session.SessionState>(){

                public void a(Session.SessionState sessionState) {
                    if (sessionState == Session.SessionState.START && InternalScreenRecordHelper.this.isRecording()) {
                        InternalScreenRecordHelper.this.canStopRecording = true;
                        InternalScreenRecordHelper.this.stop();
                    }
                }

                public /* synthetic */ void accept(Object object) throws Exception {
                    this.a((Session.SessionState)((Object)object));
                }
            });
        }
    }

    @Override
    public void start() {
        this.isCurrentlyRecording = true;
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity != null) {
            activity.startService(ScreenRecordingService.a((Context)activity, -1, this.resultDataIntent));
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (InternalScreenRecordHelper.this.isRecording()) {
                    InternalScreenRecordHelper.this.stopSubject.onNext((Object)true);
                }
            }
        }, 1000L);
    }

    public void pause() {
    }

    @Override
    public void stop() {
        if (this.canStopRecording) {
            ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(1, this.getAutoScreenRecordingFileUri()));
            this.release();
        }
    }

    public void release() {
        if (this.fab != null) {
            this.fab.b();
        }
        this.unsubscribeFromSessionEvents();
        InvocationManager.getInstance().switchOnInvocation();
        com.instabug.library.util.c.b(Instabug.getApplicationContext());
        this.stopSubject.onNext((Object)false);
        this.isCurrentlyRecording = false;
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    @Override
    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        return this.fileHolder.getAutoScreenRecordingFileUri();
    }

    @Override
    public void delete() {
        this.fileHolder.delete();
    }

    @Override
    public void clear() {
        this.isCurrentlyRecording = false;
        this.fileHolder.clear();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.getInstance().autoScreenRecordingEnabled();
    }

    public boolean isRecording() {
        return this.isCurrentlyRecording;
    }

    public void cancel() {
        if (this.isRecording()) {
            this.release();
            InstabugSDKLogger.d(this, "Cancelling screen recording");
        }
    }

    public Observable<Boolean> getIsStoppableObservable() {
        return this.stopSubject.hide().doOnNext((Consumer)new Consumer<Boolean>(){

            public void a(Boolean bl) {
                InternalScreenRecordHelper.this.canStopRecording = bl;
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((Boolean)object);
            }
        });
    }

    public void onRecordingFinished() {
        ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(2, this.getAutoScreenRecordingFileUri()));
    }

    public void setAutoScreenRecordingFile(File file) {
        this.fileHolder.setAutoScreenRecordingFile(file);
    }

    public void startTimerOnRecordingFAB() {
        if (this.fab != null) {
            this.fab.d();
        }
    }

    public void setResultDataIntent(Intent intent) {
        this.resultDataIntent = intent;
    }
}

