/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ScaleImageView
extends ImageView
implements View.OnTouchListener {
    private Context mContext;
    private float MAX_SCALE = 5.0f;
    private Matrix mMatrix;
    private final float[] mMatrixValues = new float[9];
    private int mWidth;
    private int mHeight;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private float mScale;
    private float mMinScale;
    private float mPrevDistance;
    private boolean isScaling;
    private int mPrevMoveX;
    private int mPrevMoveY;
    private GestureDetector mDetector;

    public ScaleImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.initialize();
    }

    public ScaleImageView(Context context) {
        super(context);
        this.mContext = context;
        this.initialize();
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        this.initialize();
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        this.initialize();
    }

    private void initialize() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.mMatrix = new Matrix();
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            this.mIntrinsicWidth = drawable2.getIntrinsicWidth();
            this.mIntrinsicHeight = drawable2.getIntrinsicHeight();
            this.setOnTouchListener(this);
        }
        this.mDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent motionEvent) {
                ScaleImageView.this.maxZoomTo((int)motionEvent.getX(), (int)motionEvent.getY());
                ScaleImageView.this.cutting();
                return super.onDoubleTap(motionEvent);
            }
        });
    }

    protected boolean setFrame(int n, int n2, int n3, int n4) {
        this.mWidth = n3 - n;
        this.mHeight = n4 - n2;
        this.mMatrix.reset();
        int n5 = n3 - n;
        this.mScale = (float)n5 / (float)this.mIntrinsicWidth;
        int n6 = 0;
        int n7 = 0;
        if (this.mScale * (float)this.mIntrinsicHeight > (float)this.mHeight) {
            this.mScale = (float)this.mHeight / (float)this.mIntrinsicHeight;
            this.mMatrix.postScale(this.mScale, this.mScale);
            n7 = (n3 - this.mWidth) / 2;
            n6 = 0;
        } else {
            this.mMatrix.postScale(this.mScale, this.mScale);
            n6 = (n4 - this.mHeight) / 2;
            n7 = 0;
        }
        this.mMatrix.postTranslate((float)n7, (float)n6);
        this.setImageMatrix(this.mMatrix);
        this.mMinScale = this.mScale;
        this.zoomTo(this.mScale, this.mWidth / 2, this.mHeight / 2);
        this.cutting();
        return super.setFrame(n, n2, n3, n4);
    }

    protected float getValue(Matrix matrix, int n) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n];
    }

    protected float getScale() {
        return this.getValue(this.mMatrix, 0);
    }

    public float getTranslateX() {
        return this.getValue(this.mMatrix, 2);
    }

    protected float getTranslateY() {
        return this.getValue(this.mMatrix, 5);
    }

    protected void maxZoomTo(int n, int n2) {
        if (this.mMinScale != this.getScale() && this.getScale() - this.mMinScale > 0.1f) {
            float f2 = this.mMinScale / this.getScale();
            this.zoomTo(f2, n, n2);
        } else {
            float f3 = this.MAX_SCALE / this.getScale();
            this.zoomTo(f3, n, n2);
        }
    }

    public void zoomTo(float f2, int n, int n2) {
        if (this.getScale() * f2 < this.mMinScale) {
            return;
        }
        if (f2 >= 1.0f && this.getScale() * f2 > this.MAX_SCALE) {
            return;
        }
        this.mMatrix.postScale(f2, f2);
        this.mMatrix.postTranslate(-((float)this.mWidth * f2 - (float)this.mWidth) / 2.0f, -((float)this.mHeight * f2 - (float)this.mHeight) / 2.0f);
        this.mMatrix.postTranslate((float)(-(n - this.mWidth / 2)) * f2, 0.0f);
        this.mMatrix.postTranslate(0.0f, (float)(-(n2 - this.mHeight / 2)) * f2);
        this.setImageMatrix(this.mMatrix);
    }

    public void cutting() {
        int n = (int)((float)this.mIntrinsicWidth * this.getScale());
        int n2 = (int)((float)this.mIntrinsicHeight * this.getScale());
        if (this.getTranslateX() < (float)(-(n - this.mWidth))) {
            this.mMatrix.postTranslate(-(this.getTranslateX() + (float)n - (float)this.mWidth), 0.0f);
        }
        if (this.getTranslateX() > 0.0f) {
            this.mMatrix.postTranslate(-this.getTranslateX(), 0.0f);
        }
        if (this.getTranslateY() < (float)(-(n2 - this.mHeight))) {
            this.mMatrix.postTranslate(0.0f, -(this.getTranslateY() + (float)n2 - (float)this.mHeight));
        }
        if (this.getTranslateY() > 0.0f) {
            this.mMatrix.postTranslate(0.0f, -this.getTranslateY());
        }
        if (n < this.mWidth) {
            this.mMatrix.postTranslate((float)(this.mWidth - n) / 2.0f, 0.0f);
        }
        if (n2 < this.mHeight) {
            this.mMatrix.postTranslate(0.0f, (float)(this.mHeight - n2) / 2.0f);
        }
        this.setImageMatrix(this.mMatrix);
    }

    private float distance(float f2, float f3, float f4, float f5) {
        float f6 = f2 - f3;
        float f7 = f4 - f5;
        return (float)Math.sqrt(f6 * f6 + f7 * f7);
    }

    private float dispDistance() {
        return (float)Math.sqrt(this.mWidth * this.mWidth + this.mHeight * this.mHeight);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mDetector.onTouchEvent(motionEvent)) {
            return true;
        }
        int n = motionEvent.getPointerCount();
        switch (motionEvent.getAction()) {
            case 0: 
            case 5: 
            case 261: {
                if (n >= 2) {
                    float f2;
                    this.mPrevDistance = f2 = this.distance(motionEvent.getX(0), motionEvent.getX(1), motionEvent.getY(0), motionEvent.getY(1));
                    this.isScaling = true;
                    break;
                }
                this.mPrevMoveX = (int)motionEvent.getX();
                this.mPrevMoveY = (int)motionEvent.getY();
                break;
            }
            case 2: {
                if (n >= 2 && this.isScaling) {
                    float f3 = this.distance(motionEvent.getX(0), motionEvent.getX(1), motionEvent.getY(0), motionEvent.getY(1));
                    float f4 = (f3 - this.mPrevDistance) / this.dispDistance();
                    this.mPrevDistance = f3;
                    f4 += 1.0f;
                    f4 *= f4;
                    this.zoomTo(f4, this.mWidth / 2, this.mHeight / 2);
                    this.cutting();
                    break;
                }
                if (this.isScaling) break;
                int n2 = this.mPrevMoveX - (int)motionEvent.getX();
                int n3 = this.mPrevMoveY - (int)motionEvent.getY();
                this.mPrevMoveX = (int)motionEvent.getX();
                this.mPrevMoveY = (int)motionEvent.getY();
                this.mMatrix.postTranslate((float)(-n2), (float)(-n3));
                this.cutting();
                break;
            }
            case 1: 
            case 6: 
            case 262: {
                if (motionEvent.getPointerCount() > 1) break;
                this.isScaling = false;
                break;
            }
        }
        return true;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return super.onTouchEvent(motionEvent);
    }
}

