/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.webkit.MimeTypeMap;
import com.instabug.library.internal.storage.cache.Cacheable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment
implements Cacheable,
Serializable {
    static final String KEY_NAME = "name";
    static final String KEY_LOCALE_PATH = "local_path";
    static final String KEY_URL = "url";
    static final String KEY_TYPE = "type";
    static final String KEY_ATTACHMENT_STATE = "attachment_state";
    static final String KEY_VIDEO_ENCODED = "video_encoded";
    static final String KEY_DURATION = "duration";
    private long id = -1L;
    private String name;
    private String localPath;
    private String url;
    private Type type;
    private AttachmentState attachmentState;
    private boolean isVideoEncoded = false;
    private String duration;
    private boolean shouldAnimate = true;

    public Attachment() {
        this.setType(Type.NOT_AVAILABLE);
        this.setAttachmentState(AttachmentState.NOT_AVAILABLE);
    }

    public static JSONArray toJson(List<Attachment> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            jSONArray.put((Object)new JSONObject(list.get(i).toJson()));
        }
        return jSONArray;
    }

    public static List<Attachment> fromJson(JSONArray jSONArray) throws JSONException {
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            Attachment attachment = new Attachment();
            attachment.fromJson(jSONArray.getJSONObject(i).toString());
            arrayList.add(attachment);
        }
        return arrayList;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public Attachment setName(String string2) {
        this.name = string2;
        return this;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public Attachment setLocalPath(String string2) {
        this.localPath = string2;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Attachment setUrl(String string2) {
        this.url = string2;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Attachment setType(Type type) {
        this.type = type;
        return this;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    public void setShouldAnimate(boolean bl) {
        this.shouldAnimate = bl;
    }

    public boolean isVideoEncoded() {
        return this.isVideoEncoded;
    }

    public Attachment setVideoEncoded(boolean bl) {
        this.isVideoEncoded = bl;
        return this;
    }

    public String getFileType() {
        String string2 = MimeTypeMap.getFileExtensionFromUrl((String)this.getName());
        if (string2 != null && !string2.equals("")) {
            String string3 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            return string3 != null && !string3.equals("") ? string3 : this.getType().toString();
        }
        return this.getType().toString();
    }

    public AttachmentState getAttachmentState() {
        return this.attachmentState;
    }

    public Attachment setAttachmentState(AttachmentState attachmentState) {
        this.attachmentState = attachmentState;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String string2) {
        this.duration = string2;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_NAME, (Object)this.getName()).put(KEY_LOCALE_PATH, (Object)this.getLocalPath()).put(KEY_URL, (Object)this.getUrl()).put(KEY_TYPE, (Object)this.getType().toString()).put(KEY_ATTACHMENT_STATE, (Object)this.getAttachmentState().toString()).put(KEY_VIDEO_ENCODED, this.isVideoEncoded()).put(KEY_DURATION, (Object)this.getDuration());
        return jSONObject.toString();
    }

    @Override
    public void fromJson(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject(string2);
        if (jSONObject.has(KEY_NAME)) {
            this.setName(jSONObject.getString(KEY_NAME));
        }
        if (jSONObject.has(KEY_LOCALE_PATH)) {
            this.setLocalPath(jSONObject.getString(KEY_LOCALE_PATH));
        }
        if (jSONObject.has(KEY_URL)) {
            this.setUrl(jSONObject.getString(KEY_URL));
        }
        if (jSONObject.has(KEY_TYPE)) {
            this.setType(Type.get(jSONObject.getString(KEY_TYPE)));
        }
        if (jSONObject.has(KEY_ATTACHMENT_STATE)) {
            this.setAttachmentState(AttachmentState.valueOf(jSONObject.getString(KEY_ATTACHMENT_STATE)));
        }
        if (jSONObject.has(KEY_VIDEO_ENCODED)) {
            this.setVideoEncoded(jSONObject.getBoolean(KEY_VIDEO_ENCODED));
        }
        if (jSONObject.has(KEY_DURATION)) {
            this.setDuration(jSONObject.getString(KEY_DURATION));
        }
    }

    public String toString() {
        return "Name: " + this.getName() + ", Local Path: " + this.getLocalPath() + ", Type: " + (Object)((Object)this.getType()) + ", Duration: " + this.getDuration() + ", Url: " + this.getUrl() + ", Attachment State: " + (Object)((Object)this.getAttachmentState());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Attachment) {
            Attachment attachment = (Attachment)object;
            return String.valueOf(attachment.getName()).equals(String.valueOf(this.getName())) && String.valueOf(attachment.getLocalPath()).equals(String.valueOf(this.getLocalPath())) && String.valueOf(attachment.getUrl()).equals(String.valueOf(this.getUrl())) && attachment.getType() == this.getType() && attachment.getAttachmentState() == this.getAttachmentState() && attachment.isVideoEncoded() == this.isVideoEncoded() && String.valueOf(attachment.getDuration()).equals(String.valueOf(this.getDuration()));
        }
        return false;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return -1;
    }

    public static enum AttachmentState {
        OFFLINE,
        SYNCED,
        NOT_AVAILABLE;

    }

    public static enum Type {
        MAIN_SCREENSHOT("main-screenshot"),
        AUDIO("audio"),
        EXTRA_IMAGE("extra_image"),
        EXTRA_VIDEO("extra_video"),
        GALLERY_IMAGE("image_gallery"),
        GALLERY_VIDEO("video_gallery"),
        ATTACHMENT_FILE("attachment-file"),
        VIEW_HIERARCHY("view-hierarchy"),
        NOT_AVAILABLE("not-available"),
        VISUAL_USER_STEPS("user-repro-steps"),
        AUTO_SCREEN_RECORDING("auto-screen-recording");

        private final String name;
        private static final Map<String, Type> lookup;

        private Type(String string3) {
            this.name = string3;
        }

        public String toString() {
            return this.name;
        }

        public static Type get(String string2) {
            Type type = lookup.get(string2);
            return type == null ? NOT_AVAILABLE : type;
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }
    }
}

