/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import com.instabug.library._InstabugActivity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PresentationManager {
    private static PresentationManager INSTANCE;
    ArrayList<Runnable> screensList = new ArrayList();
    WeakReference<Activity> currentActivity;
    private String lastRunnableName;
    private boolean isNotificationShowing = false;
    private boolean isInInstabugContext = false;

    private PresentationManager() {
    }

    public static PresentationManager getInstance() {
        return INSTANCE != null ? INSTANCE : (INSTANCE = new PresentationManager());
    }

    public void show(Runnable runnable) {
        if (runnable == null || this.hasPreviousRunnable(this.screensList)) {
            return;
        }
        this.screensList.add(runnable);
        if (!(this.screensList.size() != 1 || this.currentActivity == null || this.currentActivity.get() == null || this.currentActivity.get() instanceof _InstabugActivity || this.isNotificationShowing || this.isInInstabugContext)) {
            this.notifyActivityChanged();
        }
    }

    private boolean hasPreviousRunnable(ArrayList<Runnable> arrayList) {
        for (Runnable runnable : arrayList) {
            if (!runnable.getClass().getName().equals(this.lastRunnableName)) continue;
            return true;
        }
        return false;
    }

    public void notifyActivityChanged() {
        if (this.screensList.size() > 0) {
            this.lastRunnableName = this.screensList.get(0).getClass().getName();
            this.screensList.get(0).run();
            this.screensList.remove(0);
        }
    }

    public void setCurrentActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    public String getCurrentActivityName() {
        Activity activity;
        if (this.currentActivity != null && (activity = (Activity)this.currentActivity.get()) != null) {
            return activity.getLocalClassName();
        }
        return "";
    }

    public void setNotificationShowing(boolean bl) {
        this.isNotificationShowing = bl;
    }

    public void setInInstabugContext(boolean bl) {
        this.isInInstabugContext = bl;
    }
}

