/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.support.v4.os.ConfigurationCompat;
import android.support.v4.os.LocaleListCompat;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.instabug.library.e;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.device.a;
import com.instabug.library.tracking.d;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class DeviceStateProvider {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public DeviceStateProvider() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[0] = true;
    }

    public static String getDevice() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[1] = true;
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        try {
            if (a.a()) {
                blArray[2] = true;
                return blArray[2];
            }
        }
        catch (Exception exception) {
            blArray[3] = true;
            blArray[4] = true;
            blArray[5] = true;
            InstabugSDKLogger.e("DeviceStateProvider", "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            blArray[6] = true;
            return false;
        }
        blArray[7] = true;
        return false;
    }

    public static String getOS() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[8] = true;
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        try {
            blArray[9] = true;
            blArray[10] = true;
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            blArray[11] = true;
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get Carrier", exception);
            blArray[12] = true;
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[13] = true;
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[14] = true;
        return InstabugDeviceProperties.getAppVersion(context);
    }

    public static int getBatteryLevel(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            blArray[15] = true;
            Intent intent = context.registerReceiver(null, intentFilter);
            blArray[16] = true;
            if ($assertionsDisabled) {
                blArray[17] = true;
            } else if (intent != null) {
                blArray[18] = true;
            } else {
                blArray[19] = true;
                throw new AssertionError();
            }
            int n = intent.getIntExtra("level", -1);
            blArray[20] = true;
            int n2 = intent.getIntExtra("scale", -1);
            float f2 = (float)n / (float)n2;
            blArray[21] = true;
            return (int)(f2 * 100.0f);
        }
        catch (Exception exception) {
            blArray[22] = true;
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery level", exception);
            blArray[23] = true;
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String getBatteryState(Context var0) {
        var1_1 = DeviceStateProvider.$jacocoInit();
        try {
            block18: {
                var2_2 = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                var1_1[24] = true;
                var3_4 = var0.registerReceiver(null, var2_2);
                var1_1[25] = true;
                if (DeviceStateProvider.$assertionsDisabled) {
                    var1_1[26] = true;
                } else if (var3_4 != null) {
                    var1_1[27] = true;
                } else {
                    var1_1[28] = true;
                    throw new AssertionError();
                }
                var4_5 = var3_4.getIntExtra("status", -1);
                if (var4_5 != 2) break block18;
                var1_1[29] = true;
                ** GOTO lbl22
            }
            if (var4_5 == 5) {
                var1_1[30] = true;
lbl22:
                // 2 sources

                v0 = var1_1[31] = true;
            } else {
                v0 = false;
                var1_1[32] = true;
            }
            var5_6 = v0;
            var1_1[33] = true;
            var6_7 = var3_4.getIntExtra("plugged", -1);
            if (var6_7 == 2) {
                v1 = var1_1[34] = true;
            } else {
                v1 = false;
                var1_1[35] = true;
            }
            var7_8 = v1;
            if (var6_7 == 1) {
                v2 = var1_1[36] = true;
            } else {
                v2 = false;
                var1_1[37] = true;
            }
            var8_9 = v2;
            var1_1[38] = true;
            if (var5_6) {
                v3 = new StringBuilder().append("Charging");
                if (var8_9) {
                    v4 = " through AC Charger";
                    var1_1[39] = true;
                } else if (var7_8) {
                    v4 = " through USB cable";
                    var1_1[40] = true;
                } else {
                    v4 = "";
                    var1_1[41] = true;
                }
                v5 = v3.append(v4).toString();
                var1_1[42] = true;
            } else {
                v5 = "Unplugged";
                var1_1[43] = true;
            }
            var1_1[44] = true;
        }
        catch (Exception var2_3) {
            var1_1[45] = true;
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery state", var2_3);
            var1_1[46] = true;
            return "Unknown";
        }
        return v5;
    }

    public static boolean getWifiState(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        try {
            blArray[47] = true;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            blArray[48] = true;
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            blArray[49] = true;
            blArray[50] = true;
            return networkInfo.isConnected();
        }
        catch (Exception exception) {
            blArray[51] = true;
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get wifi state", exception);
            blArray[52] = true;
            return false;
        }
    }

    public static String getWifiSSID(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (DeviceStateProvider.getWifiState(context)) {
            String string2;
            try {
                blArray[53] = true;
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                blArray[54] = true;
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                blArray[55] = true;
                string2 = wifiInfo.getSSID();
            }
            catch (SecurityException securityException) {
                blArray[57] = true;
                InstabugSDKLogger.e("DeviceStateProvider", "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                blArray[58] = true;
                return "Connected";
            }
            blArray[56] = true;
            return string2;
        }
        blArray[59] = true;
        return "Not Connected";
    }

    public static long getFreeMemory(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        blArray[60] = true;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        blArray[61] = true;
        activityManager.getMemoryInfo(memoryInfo);
        blArray[62] = true;
        return memoryInfo.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        blArray[63] = true;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        blArray[64] = true;
        activityManager.getMemoryInfo(memoryInfo);
        blArray[65] = true;
        long l = DeviceStateProvider.calculateTotalMemory(context) - memoryInfo.availMem;
        blArray[66] = true;
        return l / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        long l = DeviceStateProvider.calculateTotalMemory(context);
        if (l == 0L) {
            blArray[67] = true;
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total memory");
            blArray[68] = true;
            return -1L;
        }
        blArray[69] = true;
        return l / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (Build.VERSION.SDK_INT >= 16) {
            blArray[70] = true;
            blArray[71] = true;
            return DeviceStateProvider.calculateTotalMemoryApi16(context);
        }
        blArray[72] = true;
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        blArray[73] = true;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        blArray[74] = true;
        activityManager.getMemoryInfo(memoryInfo);
        blArray[75] = true;
        return memoryInfo.totalMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long calculateTotalMemoryPreApi16() {
        long l;
        RandomAccessFile randomAccessFile;
        block13: {
            block12: {
                boolean[] blArray = DeviceStateProvider.$jacocoInit();
                randomAccessFile = null;
                blArray[76] = true;
                randomAccessFile = new RandomAccessFile("/proc/meminfo", "r");
                blArray[77] = true;
                String string2 = randomAccessFile.readLine();
                blArray[78] = true;
                String[] stringArray = string2.split(":");
                blArray[79] = true;
                string2 = stringArray[1].trim();
                blArray[80] = true;
                string2 = string2.substring(0, string2.length() - 3).trim();
                blArray[81] = true;
                randomAccessFile.close();
                blArray[82] = true;
                l = Long.parseLong(string2) * 1024L;
                if (randomAccessFile != null) break block12;
                blArray[83] = true;
                break block13;
            }
            try {
                blArray[84] = true;
                randomAccessFile.close();
                blArray[85] = true;
            }
            catch (IOException iOException) {
                blArray[86] = true;
                iOException.printStackTrace();
                blArray[87] = true;
            }
        }
        blArray[88] = true;
        return l;
        catch (IOException iOException) {
            block14: {
                try {
                    blArray[89] = true;
                    iOException.printStackTrace();
                    if (randomAccessFile != null) break block14;
                    blArray[90] = true;
                }
                catch (Throwable throwable) {
                    if (randomAccessFile == null) {
                        blArray[95] = true;
                    } else {
                        try {
                            blArray[96] = true;
                            randomAccessFile.close();
                            blArray[97] = true;
                        }
                        catch (IOException iOException2) {
                            blArray[98] = true;
                            iOException2.printStackTrace();
                            blArray[99] = true;
                        }
                    }
                    blArray[100] = true;
                    throw throwable;
                }
            }
            try {
                blArray[91] = true;
                randomAccessFile.close();
                blArray[92] = true;
            }
            catch (IOException iOException3) {
                blArray[93] = true;
                iOException3.printStackTrace();
                blArray[94] = true;
            }
        }
        blArray[101] = true;
        return 0L;
    }

    public static long getFreeStorage() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (DeviceStateProvider.externalMemoryAvailable()) {
            blArray[102] = true;
            long l = Environment.getExternalStorageDirectory().getUsableSpace();
            blArray[103] = true;
            return l / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate free storage");
        blArray[104] = true;
        return -1L;
    }

    public static long getUsedStorage() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (DeviceStateProvider.externalMemoryAvailable()) {
            blArray[105] = true;
            blArray[106] = true;
            long l = Environment.getExternalStorageDirectory().getTotalSpace() - Environment.getExternalStorageDirectory().getFreeSpace();
            blArray[107] = true;
            return l / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate used storage");
        blArray[108] = true;
        return -1L;
    }

    public static long getTotalStorage() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (DeviceStateProvider.externalMemoryAvailable()) {
            blArray[109] = true;
            long l = Environment.getExternalStorageDirectory().getTotalSpace();
            blArray[110] = true;
            return (int)(l / 0x100000L);
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total storage");
        blArray[111] = true;
        return -1L;
    }

    private static boolean externalMemoryAvailable() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[112] = true;
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getScreenDensity(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        DisplayMetrics displayMetrics = DeviceStateProvider.getDisplayMetrics(context);
        if (displayMetrics.densityDpi < 160) {
            blArray[113] = true;
            return "ldpi";
        }
        if (displayMetrics.densityDpi < 240) {
            blArray[114] = true;
            return "mdpi";
        }
        if (displayMetrics.densityDpi < 320) {
            blArray[115] = true;
            return "hdpi";
        }
        if (displayMetrics.densityDpi < 480) {
            blArray[116] = true;
            return "xhdpi";
        }
        if (displayMetrics.densityDpi < 640) {
            blArray[117] = true;
            return "xxhdpi";
        }
        blArray[118] = true;
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        DisplayMetrics displayMetrics = DeviceStateProvider.getDisplayMetrics(context);
        blArray[119] = true;
        blArray[120] = true;
        return String.format("%sx%s", displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[121] = true;
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        blArray[122] = true;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        blArray[123] = true;
        display.getMetrics(displayMetrics);
        if (Build.VERSION.SDK_INT < 17) {
            blArray[124] = true;
        } else {
            blArray[125] = true;
            display.getRealMetrics(displayMetrics);
            blArray[126] = true;
        }
        blArray[127] = true;
        return displayMetrics;
    }

    public static String getScreenOrientation(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (context.getResources().getConfiguration().orientation == 2) {
            blArray[128] = true;
            return "landscape";
        }
        blArray[129] = true;
        return "portrait";
    }

    public static String getCurrentView() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[130] = true;
        return d.a().b();
    }

    public static String getSdkVersion() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[131] = true;
        return "8.0.11";
    }

    public static String getLocale(Context context) {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        LocaleListCompat localeListCompat = ConfigurationCompat.getLocales((Configuration)context.getResources().getConfiguration());
        blArray[132] = true;
        if (localeListCompat.size() > 0) {
            blArray[133] = true;
            blArray[134] = true;
            return ConfigurationCompat.getLocales((Configuration)context.getResources().getConfiguration()).get(0).getLanguage();
        }
        blArray[135] = true;
        return context.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        blArray[136] = true;
        return e.a().b();
    }

    static {
        boolean bl;
        boolean[] blArray = DeviceStateProvider.$jacocoInit();
        if (!DeviceStateProvider.class.desiredAssertionStatus()) {
            bl = blArray[137] = true;
        } else {
            bl = false;
            blArray[138] = true;
        }
        $assertionsDisabled = bl;
        blArray[139] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-8027781131759736219L, (String)"com/instabug/library/util/DeviceStateProvider", (int)140);
        }
        return blArray;
    }
}

