/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.instabug.library.R;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class CircularImageView
extends ImageView {
    private static final ImageView.ScaleType SCALE_TYPE;
    private static final Bitmap.Config BITMAP_CONFIG;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_FILL_COLOR = 0;
    private static final boolean DEFAULT_BORDER_OVERLAY = false;
    private final RectF mDrawableRect;
    private final RectF mBorderRect;
    private final Matrix mShaderMatrix;
    private final Paint mBitmapPaint;
    private final Paint mBorderPaint;
    private final Paint mFillPaint;
    private int mBorderColor;
    private int mBorderWidth;
    private int mFillColor;
    private Bitmap mBitmap;
    private BitmapShader mBitmapShader;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private float mDrawableRadius;
    private float mBorderRadius;
    private ColorFilter mColorFilter;
    private boolean mReady;
    private boolean mSetupPending;
    private boolean mBorderOverlay;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public CircularImageView(Context context) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super(context);
        blArray[0] = true;
        this.mDrawableRect = new RectF();
        blArray[1] = true;
        this.mBorderRect = new RectF();
        blArray[2] = true;
        this.mShaderMatrix = new Matrix();
        blArray[3] = true;
        this.mBitmapPaint = new Paint();
        blArray[4] = true;
        this.mBorderPaint = new Paint();
        blArray[5] = true;
        this.mFillPaint = new Paint();
        this.mBorderColor = -16777216;
        this.mBorderWidth = 0;
        this.mFillColor = 0;
        blArray[6] = true;
        this.init();
        blArray[7] = true;
    }

    public CircularImageView(Context context, AttributeSet attributeSet) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        this(context, attributeSet, 0);
        blArray[8] = true;
    }

    public CircularImageView(Context context, AttributeSet attributeSet, int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super(context, attributeSet, n);
        blArray[9] = true;
        this.mDrawableRect = new RectF();
        blArray[10] = true;
        this.mBorderRect = new RectF();
        blArray[11] = true;
        this.mShaderMatrix = new Matrix();
        blArray[12] = true;
        this.mBitmapPaint = new Paint();
        blArray[13] = true;
        this.mBorderPaint = new Paint();
        blArray[14] = true;
        this.mFillPaint = new Paint();
        this.mBorderColor = -16777216;
        this.mBorderWidth = 0;
        this.mFillColor = 0;
        blArray[15] = true;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CircleImageView, n, 0);
        blArray[16] = true;
        this.mBorderWidth = typedArray.getDimensionPixelSize(R.styleable.CircleImageView_ibg_civ_border_width, 0);
        blArray[17] = true;
        this.mBorderColor = typedArray.getColor(R.styleable.CircleImageView_ibg_civ_border_color, -16777216);
        blArray[18] = true;
        this.mBorderOverlay = typedArray.getBoolean(R.styleable.CircleImageView_ibg_civ_border_overlay, false);
        blArray[19] = true;
        this.mFillColor = typedArray.getColor(R.styleable.CircleImageView_ibg_civ_fill_color, 0);
        blArray[20] = true;
        typedArray.recycle();
        blArray[21] = true;
        this.init();
        blArray[22] = true;
    }

    private void init() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super.setScaleType(SCALE_TYPE);
        this.mReady = true;
        if (!this.mSetupPending) {
            blArray[23] = true;
        } else {
            blArray[24] = true;
            this.setup();
            this.mSetupPending = false;
            blArray[25] = true;
        }
        blArray[26] = true;
    }

    public ImageView.ScaleType getScaleType() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        blArray[27] = true;
        return SCALE_TYPE;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (scaleType != SCALE_TYPE) {
            blArray[28] = true;
            blArray[29] = true;
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
        blArray[30] = true;
    }

    public void setAdjustViewBounds(boolean bl) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (bl) {
            blArray[31] = true;
            blArray[32] = true;
            throw new IllegalArgumentException("adjustViewBounds not supported.");
        }
        blArray[33] = true;
    }

    protected void onDraw(Canvas canvas) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (this.mBitmap == null) {
            blArray[34] = true;
            return;
        }
        if (this.mFillColor == 0) {
            blArray[35] = true;
        } else {
            blArray[36] = true;
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mDrawableRadius, this.mFillPaint);
            blArray[37] = true;
        }
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mDrawableRadius, this.mBitmapPaint);
        if (this.mBorderWidth == 0) {
            blArray[38] = true;
        } else {
            blArray[39] = true;
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mBorderRadius, this.mBorderPaint);
            blArray[40] = true;
        }
        blArray[41] = true;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super.onSizeChanged(n, n2, n3, n4);
        blArray[42] = true;
        this.setup();
        blArray[43] = true;
    }

    public int getBorderColor() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        blArray[44] = true;
        return this.mBorderColor;
    }

    public void setBorderColor(@ColorInt int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (n == this.mBorderColor) {
            blArray[45] = true;
            return;
        }
        this.mBorderColor = n;
        blArray[46] = true;
        this.mBorderPaint.setColor(this.mBorderColor);
        blArray[47] = true;
        this.invalidate();
        blArray[48] = true;
    }

    public void setBorderColorResource(@ColorRes int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        this.setBorderColor(this.getContext().getResources().getColor(n));
        blArray[49] = true;
    }

    public int getFillColor() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        blArray[50] = true;
        return this.mFillColor;
    }

    public void setFillColor(@ColorInt int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (n == this.mFillColor) {
            blArray[51] = true;
            return;
        }
        this.mFillColor = n;
        blArray[52] = true;
        this.mFillPaint.setColor(n);
        blArray[53] = true;
        this.invalidate();
        blArray[54] = true;
    }

    public void setFillColorResource(@ColorRes int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        this.setFillColor(this.getContext().getResources().getColor(n));
        blArray[55] = true;
    }

    public int getBorderWidth() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        blArray[56] = true;
        return this.mBorderWidth;
    }

    public void setBorderWidth(int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (n == this.mBorderWidth) {
            blArray[57] = true;
            return;
        }
        this.mBorderWidth = n;
        blArray[58] = true;
        this.setup();
        blArray[59] = true;
    }

    public boolean isBorderOverlay() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        blArray[60] = true;
        return this.mBorderOverlay;
    }

    public void setBorderOverlay(boolean bl) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (bl == this.mBorderOverlay) {
            blArray[61] = true;
            return;
        }
        this.mBorderOverlay = bl;
        blArray[62] = true;
        this.setup();
        blArray[63] = true;
    }

    public void setImageBitmap(Bitmap bitmap) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super.setImageBitmap(bitmap);
        this.mBitmap = bitmap;
        blArray[64] = true;
        this.setup();
        blArray[65] = true;
    }

    public void setImageDrawable(Drawable drawable2) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super.setImageDrawable(drawable2);
        blArray[66] = true;
        this.mBitmap = this.getBitmapFromDrawable(drawable2);
        blArray[67] = true;
        this.setup();
        blArray[68] = true;
    }

    public void setImageResource(@DrawableRes int n) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        super.setImageResource(n);
        blArray[69] = true;
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        blArray[70] = true;
        this.setup();
        blArray[71] = true;
    }

    public void setImageURI(Uri uri) {
        Bitmap bitmap;
        boolean[] blArray = CircularImageView.$jacocoInit();
        super.setImageURI(uri);
        blArray[72] = true;
        if (uri != null) {
            bitmap = this.getBitmapFromDrawable(this.getDrawable());
            blArray[73] = true;
        } else {
            bitmap = null;
            blArray[74] = true;
        }
        this.mBitmap = bitmap;
        blArray[75] = true;
        this.setup();
        blArray[76] = true;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (colorFilter == this.mColorFilter) {
            blArray[77] = true;
            return;
        }
        this.mColorFilter = colorFilter;
        blArray[78] = true;
        this.mBitmapPaint.setColorFilter(this.mColorFilter);
        blArray[79] = true;
        this.invalidate();
        blArray[80] = true;
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (drawable2 == null) {
            blArray[81] = true;
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            blArray[83] = true;
            blArray[84] = true;
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        blArray[82] = true;
        try {
            Bitmap bitmap;
            if (drawable2 instanceof ColorDrawable) {
                blArray[85] = true;
                bitmap = Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG);
                blArray[86] = true;
            } else {
                bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
                blArray[87] = true;
            }
            Canvas canvas = new Canvas(bitmap);
            blArray[88] = true;
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            blArray[89] = true;
            drawable2.draw(canvas);
            blArray[90] = true;
            return bitmap;
        }
        catch (Exception exception) {
            blArray[91] = true;
            exception.printStackTrace();
            blArray[92] = true;
            return null;
        }
    }

    private void setup() {
        boolean[] blArray = CircularImageView.$jacocoInit();
        if (!this.mReady) {
            this.mSetupPending = true;
            blArray[93] = true;
            return;
        }
        if (this.getWidth() != 0) {
            blArray[94] = true;
        } else if (this.getHeight() != 0) {
            blArray[95] = true;
        } else {
            blArray[96] = true;
            return;
        }
        if (this.mBitmap == null) {
            blArray[97] = true;
            this.invalidate();
            blArray[98] = true;
            return;
        }
        this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        blArray[99] = true;
        this.mBitmapPaint.setAntiAlias(true);
        blArray[100] = true;
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        blArray[101] = true;
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        blArray[102] = true;
        this.mBorderPaint.setAntiAlias(true);
        blArray[103] = true;
        this.mBorderPaint.setColor(this.mBorderColor);
        blArray[104] = true;
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        blArray[105] = true;
        this.mFillPaint.setStyle(Paint.Style.FILL);
        blArray[106] = true;
        this.mFillPaint.setAntiAlias(true);
        blArray[107] = true;
        this.mFillPaint.setColor(this.mFillColor);
        blArray[108] = true;
        this.mBitmapHeight = this.mBitmap.getHeight();
        blArray[109] = true;
        this.mBitmapWidth = this.mBitmap.getWidth();
        blArray[110] = true;
        this.mBorderRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        blArray[111] = true;
        this.mBorderRadius = Math.min((this.mBorderRect.height() - (float)this.mBorderWidth) / 2.0f, (this.mBorderRect.width() - (float)this.mBorderWidth) / 2.0f);
        blArray[112] = true;
        this.mDrawableRect.set(this.mBorderRect);
        if (this.mBorderOverlay) {
            blArray[113] = true;
        } else {
            blArray[114] = true;
            this.mDrawableRect.inset((float)this.mBorderWidth, (float)this.mBorderWidth);
            blArray[115] = true;
        }
        this.mDrawableRadius = Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f);
        blArray[116] = true;
        this.updateShaderMatrix();
        blArray[117] = true;
        this.invalidate();
        blArray[118] = true;
    }

    private void updateShaderMatrix() {
        float f2;
        boolean[] blArray = CircularImageView.$jacocoInit();
        float f3 = 0.0f;
        float f4 = 0.0f;
        blArray[119] = true;
        this.mShaderMatrix.set(null);
        blArray[120] = true;
        if ((float)this.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)this.mBitmapHeight) {
            blArray[121] = true;
            f2 = this.mDrawableRect.height() / (float)this.mBitmapHeight;
            blArray[122] = true;
            f3 = (this.mDrawableRect.width() - (float)this.mBitmapWidth * f2) * 0.5f;
            blArray[123] = true;
        } else {
            f2 = this.mDrawableRect.width() / (float)this.mBitmapWidth;
            blArray[124] = true;
            f4 = (this.mDrawableRect.height() - (float)this.mBitmapHeight * f2) * 0.5f;
            blArray[125] = true;
        }
        this.mShaderMatrix.setScale(f2, f2);
        blArray[126] = true;
        this.mShaderMatrix.postTranslate((float)((int)(f3 + 0.5f)) + this.mDrawableRect.left, (float)((int)(f4 + 0.5f)) + this.mDrawableRect.top);
        blArray[127] = true;
        this.mBitmapShader.setLocalMatrix(this.mShaderMatrix);
        blArray[128] = true;
    }

    static {
        boolean[] blArray = CircularImageView.$jacocoInit();
        SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
        BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
        blArray[129] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)1884765937808695441L, (String)"com/instabug/library/ui/custom/CircularImageView", (int)130);
        }
        return blArray;
    }
}

