/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.c;
import com.instabug.library.user.a;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONException;

public class NetworkManager {
    public static final String APP_TOKEN = "application_token";
    public static final String UUID = "uuid";
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final int DEFAULT_CONNECTION_TIME_OUT = 15000;
    private OnDoRequestListener onDoRequestListener;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public NetworkManager() {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[0] = true;
    }

    public static boolean isOnline(Context context) {
        block6: {
            block7: {
                boolean[] blArray = NetworkManager.$jacocoInit();
                try {
                    if (context == null) {
                        blArray[1] = true;
                        break block6;
                    }
                    blArray[2] = true;
                    ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager == null) {
                        blArray[3] = true;
                        break block6;
                    }
                    blArray[4] = true;
                    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                    blArray[5] = true;
                    if (networkInfo == null) {
                        blArray[6] = true;
                        break block6;
                    }
                    if (networkInfo.isConnectedOrConnecting()) break block7;
                    blArray[7] = true;
                    break block6;
                }
                catch (SecurityException securityException) {
                    blArray[10] = true;
                    blArray[11] = true;
                    blArray[12] = true;
                    InstabugSDKLogger.w(NetworkManager.class, "Could not read network state. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>\n" + securityException.getMessage());
                    blArray[13] = true;
                }
                catch (Exception exception) {
                    blArray[14] = true;
                    InstabugSDKLogger.e(NetworkManager.class, "Something went wrong while checking network state", exception);
                    blArray[15] = true;
                }
            }
            blArray[8] = true;
            return blArray[8];
        }
        blArray[9] = true;
        blArray[16] = true;
        return false;
    }

    public void setOnDoRequestListener(OnDoRequestListener onDoRequestListener) {
        boolean[] blArray = NetworkManager.$jacocoInit();
        this.onDoRequestListener = onDoRequestListener;
        blArray[17] = true;
    }

    public Observable<RequestResponse> doRequest(@NonNull Request request) {
        boolean[] blArray = NetworkManager.$jacocoInit();
        if (this.onDoRequestListener == null) {
            blArray[18] = true;
        } else {
            blArray[19] = true;
            this.onDoRequestListener.onRequestStarted(request);
            blArray[20] = true;
        }
        blArray[21] = true;
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<RequestResponse>(this, request){
            final /* synthetic */ Request a;
            final /* synthetic */ NetworkManager b;
            private static transient /* synthetic */ boolean[] c;
            {
                boolean[] blArray = 1.a();
                this.b = networkManager;
                this.a = request;
                blArray[0] = true;
            }

            /*
             * Unable to fully structure code
             */
            public void subscribe(ObservableEmitter<RequestResponse> var1_1) {
                block23: {
                    var2_2 = 1.a();
                    if (NetworkManager.access$000(this.b) != null) break block23;
                    var2_2[1] = true;
                    ** GOTO lbl10
                }
                var2_2[2] = true;
                NetworkManager.access$000(this.b).onStart();
                try {
                    var2_2[3] = true;
lbl10:
                    // 2 sources

                    InstabugSDKLogger.v(NetworkManager.class, "Starting do request");
                    var2_2[4] = true;
                    var2_2[5] = true;
                    var2_2[6] = true;
                    InstabugSDKLogger.v(NetworkManager.class, "Request Url: " + this.a.getRequestUrl());
                    var2_2[7] = true;
                    var2_2[8] = true;
                    var2_2[9] = true;
                    InstabugSDKLogger.v(NetworkManager.class, "Request Type: " + this.a.getRequestMethod().toString());
                    var2_2[10] = true;
                    var2_2[11] = true;
                    var2_2[12] = true;
                    InstabugSDKLogger.v(NetworkManager.class, "Request Body: " + this.a.getRequestBody());
                    var3_3 = null;
                    var2_2[13] = true;
                    switch (2.a[this.a.getRequestType().ordinal()]) {
                        default: {
                            var2_2[14] = true;
                            break;
                        }
                        case 1: {
                            var3_3 = NetworkManager.access$100(this.b, this.a);
                            var2_2[15] = true;
                            break;
                        }
                        case 2: {
                            var3_3 = NetworkManager.access$200(this.b, this.a);
                            var2_2[16] = true;
                            break;
                        }
                        case 3: {
                            var3_3 = NetworkManager.access$300(this.b, this.a);
                            var2_2[17] = true;
                        }
                    }
                    if (var3_3 == null) {
                        var2_2[18] = true;
                    } else {
                        var2_2[19] = true;
                        var4_6 = var3_3.getResponseCode();
                        if (var4_6 < 300) {
                            var2_2[20] = true;
                        } else {
                            var2_2[21] = true;
                            InstabugSDKLogger.e(NetworkManager.class, "Network request got error");
                            var2_2[22] = true;
                            NetworkManager.access$400(this.b, var3_3);
                            var2_2[23] = true;
                        }
                        InstabugSDKLogger.v(NetworkManager.class, "Network request completed successfully");
                        var2_2[24] = true;
                        switch (2.a[this.a.getRequestType().ordinal()]) {
                            default: {
                                var2_2[25] = true;
                                break;
                            }
                            case 1: {
                                var1_1.onNext((Object)NetworkManager.access$500(this.b, var3_3));
                                var2_2[26] = true;
                                break;
                            }
                            case 2: {
                                var1_1.onNext((Object)NetworkManager.access$600(this.b, this.a, var3_3));
                                var2_2[27] = true;
                                break;
                            }
                            case 3: {
                                var1_1.onNext((Object)NetworkManager.access$700(this.b, var3_3));
                                var2_2[28] = true;
                            }
                        }
                    }
                    if (NetworkManager.access$000(this.b) == null) {
                        var2_2[29] = true;
                    } else {
                        var2_2[30] = true;
                        NetworkManager.access$000(this.b).onComplete();
                        var2_2[31] = true;
                    }
                    var1_1.onComplete();
                    var2_2[32] = true;
                }
                catch (InterruptedIOException var3_4) {
                    var2_2[33] = true;
                    var2_2[34] = true;
                    var2_2[35] = true;
                    InstabugSDKLogger.e(NetworkManager.class, "Request got error: " + this.a.getRequestUrl(), var3_4);
                    try {
                        var2_2[36] = true;
                        var1_1.onError((Throwable)var3_4);
                        var2_2[37] = true;
                    }
                    catch (Exception var4_7) {
                        var2_2[38] = true;
                        RxJavaPlugins.onError((Throwable)var4_7);
                        var2_2[39] = true;
                    }
                    var2_2[40] = true;
                }
                catch (IOException var3_5) {
                    var2_2[41] = true;
                    var2_2[42] = true;
                    var2_2[43] = true;
                    InstabugSDKLogger.e(NetworkManager.class, "Request got error: " + this.a.getRequestUrl(), var3_5);
                    try {
                        var2_2[44] = true;
                        var1_1.onError((Throwable)var3_5);
                        var2_2[45] = true;
                    }
                    catch (Exception var4_8) {
                        var2_2[46] = true;
                        RxJavaPlugins.onError((Throwable)var4_8);
                        var2_2[47] = true;
                    }
                }
                var2_2[48] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = c;
                if (c == null) {
                    blArray = c = Offline.getProbes((long)-7718908702356357920L, (String)"com/instabug/library/network/NetworkManager$1", (int)49);
                }
                return blArray;
            }
        });
    }

    public Request buildRequest(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod) throws JSONException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[22] = true;
        return this.buildRequest(context, endpoint, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod, RequestType requestType) throws JSONException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        Request request = new Request(endpoint, requestType);
        blArray[23] = true;
        request.setRequestMethod(requestMethod);
        blArray[24] = true;
        blArray[25] = true;
        return this.buildRequest(context, request);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String string2, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[26] = true;
        return this.buildRequest(context, string2, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String string2, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        Request request = new Request(string2, requestType);
        blArray[27] = true;
        request.setRequestMethod(requestMethod);
        blArray[28] = true;
        blArray[29] = true;
        return this.buildRequest(context, request);
    }

    public Request buildRequestWithoutUUID(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod) throws JSONException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        Request request = new Request(endpoint, RequestType.NORMAL);
        blArray[30] = true;
        request.setRequestMethod(requestMethod);
        blArray[31] = true;
        request.addParameter(APP_TOKEN, Instabug.getAppToken());
        blArray[32] = true;
        return request;
    }

    private Request buildRequest(@NonNull Context context, Request request) throws JSONException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        request.addParameter(APP_TOKEN, Instabug.getAppToken());
        blArray[33] = true;
        request.addParameter(UUID, a.f());
        blArray[34] = true;
        return request;
    }

    public HttpURLConnection buildConnection(Request request) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        URL uRL = new URL(request.getRequestUrl());
        blArray[35] = true;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        blArray[36] = true;
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        blArray[37] = true;
        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
        blArray[38] = true;
        httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
        blArray[39] = true;
        Iterator<Request.RequestParameter> iterator = request.getHeaders().iterator();
        blArray[40] = true;
        while (iterator.hasNext()) {
            Request.RequestParameter requestParameter = iterator.next();
            blArray[41] = true;
            httpURLConnection.setRequestProperty(requestParameter.getKey(), (String)requestParameter.getValue());
            blArray[42] = true;
        }
        httpURLConnection.setDoInput(true);
        blArray[43] = true;
        return httpURLConnection;
    }

    private HttpURLConnection setURLConnectionDefaultTimeOut(HttpURLConnection httpURLConnection) {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[44] = true;
        return this.setURLConnectionTimeOut(httpURLConnection, 10000, 15000);
    }

    public HttpURLConnection setURLConnectionTimeOut(HttpURLConnection httpURLConnection, int n, int n2) {
        boolean[] blArray = NetworkManager.$jacocoInit();
        httpURLConnection.setReadTimeout(n);
        blArray[45] = true;
        httpURLConnection.setConnectTimeout(n2);
        blArray[46] = true;
        return httpURLConnection;
    }

    /*
     * Unable to fully structure code
     */
    private HttpURLConnection connectWithNormalType(Request var1_1) throws IOException {
        block2: {
            var2_2 = NetworkManager.$jacocoInit();
            InstabugSDKLogger.v(this, "Connect to: " + var1_1.getRequestUrl() + " with normal type");
            var2_2[47] = true;
            var3_3 = this.buildConnection(var1_1);
            var2_2[48] = true;
            this.setURLConnectionDefaultTimeOut(var3_3);
            var2_2[49] = true;
            var3_3.setRequestMethod(var1_1.getRequestMethod().toString());
            var2_2[50] = true;
            if (var1_1.getRequestMethod() != Request.RequestMethod.Post) break block2;
            var2_2[51] = true;
            ** GOTO lbl20
        }
        var2_2[52] = true;
        if (var1_1.getRequestMethod() != Request.RequestMethod.put) {
            var2_2[53] = true;
        } else {
            var2_2[54] = true;
lbl20:
            // 2 sources

            var3_3.setDoOutput(true);
            var2_2[55] = true;
            this.writeRequestBody(var3_3.getOutputStream(), var1_1.getRequestBody());
            var2_2[56] = true;
        }
        var2_2[57] = true;
        return var3_3;
    }

    private void writeRequestBody(OutputStream outputStream, String string2) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        blArray[58] = true;
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        blArray[59] = true;
        gZIPOutputStream.write(string2.getBytes(Charset.forName("UTF8")));
        blArray[60] = true;
        gZIPOutputStream.close();
        blArray[61] = true;
        outputStream.write(byteArrayOutputStream.toByteArray());
        blArray[62] = true;
        byteArrayOutputStream.close();
        blArray[63] = true;
    }

    private HttpURLConnection connectWithFileDownloadType(Request request) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with fileDownload type");
        blArray[64] = true;
        blArray[65] = true;
        return this.connectWithNormalType(request);
    }

    private HttpURLConnection connectWithMultiPartType(Request request) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with multiPart type");
        blArray[66] = true;
        HttpURLConnection httpURLConnection = this.buildConnection(request);
        blArray[67] = true;
        httpURLConnection.setRequestMethod(request.getRequestMethod().toString());
        blArray[68] = true;
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        blArray[69] = true;
        httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
        blArray[70] = true;
        httpURLConnection.setRequestProperty("Content-Encoding", "");
        blArray[71] = true;
        c c2 = new c(httpURLConnection);
        blArray[72] = true;
        blArray[73] = true;
        Object object = request.getRequestBodyParameters().iterator();
        blArray[74] = true;
        while (object.hasNext()) {
            Request.RequestParameter requestParameter = object.next();
            blArray[75] = true;
            blArray[76] = true;
            blArray[77] = true;
            c2.a(requestParameter.getKey(), requestParameter.getValue().toString());
            blArray[78] = true;
        }
        object = request.getFileToUpload();
        blArray[79] = true;
        blArray[80] = true;
        blArray[81] = true;
        c2.a(((Request.FileToUpload)object).getFilePartName(), new File(((Request.FileToUpload)object).getFilePath()), ((Request.FileToUpload)object).getFileName(), ((Request.FileToUpload)object).getFileType());
        blArray[82] = true;
        c2.a();
        blArray[83] = true;
        return httpURLConnection;
    }

    private RequestResponse handleRequestResponse(HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        RequestResponse requestResponse = new RequestResponse();
        blArray[84] = true;
        int n = httpURLConnection.getResponseCode();
        blArray[85] = true;
        requestResponse.setResponseCode(n);
        blArray[86] = true;
        InstabugSDKLogger.v(this, "Request response code: " + n);
        blArray[87] = true;
        String string2 = this.convertStreamToString(httpURLConnection.getInputStream());
        blArray[88] = true;
        requestResponse.setResponseBody(string2);
        blArray[89] = true;
        InstabugSDKLogger.v(this, "Request response: " + string2);
        blArray[90] = true;
        httpURLConnection.disconnect();
        blArray[91] = true;
        return requestResponse;
    }

    private RequestResponse handleMultipartRequestResponse(HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[92] = true;
        return this.handleRequestResponse(httpURLConnection);
    }

    private RequestResponse handleFileDownloadRequestResponse(Request request, HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        RequestResponse requestResponse = new RequestResponse();
        blArray[93] = true;
        int n = httpURLConnection.getResponseCode();
        blArray[94] = true;
        requestResponse.setResponseCode(n);
        blArray[95] = true;
        InstabugSDKLogger.v(this, "File downloader request response code: " + n);
        blArray[96] = true;
        this.copyStream(httpURLConnection.getInputStream(), new FileOutputStream(request.getDownloadedFile()));
        blArray[97] = true;
        requestResponse.setResponseBody(request.getDownloadedFile());
        blArray[98] = true;
        blArray[99] = true;
        blArray[100] = true;
        InstabugSDKLogger.v(this, "File downloader request response: " + request.getDownloadedFile().getPath());
        blArray[101] = true;
        httpURLConnection.disconnect();
        blArray[102] = true;
        return requestResponse;
    }

    private void handleServerConnectionError(HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        InputStream inputStream = httpURLConnection.getErrorStream();
        blArray[103] = true;
        blArray[104] = true;
        blArray[105] = true;
        InstabugSDKLogger.e(this, "Error getting Network request response: " + this.convertStreamToString(inputStream));
        blArray[106] = true;
    }

    private String convertStreamToString(InputStream inputStream) {
        String string2;
        boolean[] blArray = NetworkManager.$jacocoInit();
        Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
        blArray[107] = true;
        if (scanner.hasNext()) {
            string2 = scanner.next();
            blArray[108] = true;
        } else {
            string2 = "";
            blArray[109] = true;
        }
        blArray[110] = true;
        return string2;
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        boolean[] blArray = NetworkManager.$jacocoInit();
        while ((n = inputStream.read()) != -1) {
            blArray[111] = true;
            outputStream.write(n);
            blArray[112] = true;
        }
        blArray[113] = true;
    }

    static /* synthetic */ OnDoRequestListener access$000(NetworkManager networkManager) {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[114] = true;
        return networkManager.onDoRequestListener;
    }

    static /* synthetic */ HttpURLConnection access$100(NetworkManager networkManager, Request request) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[115] = true;
        return networkManager.connectWithNormalType(request);
    }

    static /* synthetic */ HttpURLConnection access$200(NetworkManager networkManager, Request request) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[116] = true;
        return networkManager.connectWithFileDownloadType(request);
    }

    static /* synthetic */ HttpURLConnection access$300(NetworkManager networkManager, Request request) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[117] = true;
        return networkManager.connectWithMultiPartType(request);
    }

    static /* synthetic */ void access$400(NetworkManager networkManager, HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        networkManager.handleServerConnectionError(httpURLConnection);
        blArray[118] = true;
    }

    static /* synthetic */ RequestResponse access$500(NetworkManager networkManager, HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[119] = true;
        return networkManager.handleRequestResponse(httpURLConnection);
    }

    static /* synthetic */ RequestResponse access$600(NetworkManager networkManager, Request request, HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[120] = true;
        return networkManager.handleFileDownloadRequestResponse(request, httpURLConnection);
    }

    static /* synthetic */ RequestResponse access$700(NetworkManager networkManager, HttpURLConnection httpURLConnection) throws IOException {
        boolean[] blArray = NetworkManager.$jacocoInit();
        blArray[121] = true;
        return networkManager.handleMultipartRequestResponse(httpURLConnection);
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)4472767249223136859L, (String)"com/instabug/library/network/NetworkManager", (int)122);
        }
        return blArray;
    }

    public static interface OnDoRequestListener {
        public void onRequestStarted(Request var1);

        public void onStart();

        public void onComplete();
    }

    public static final class RequestType
    extends Enum<RequestType> {
        public static final /* enum */ RequestType NORMAL;
        public static final /* enum */ RequestType MULTI_PART;
        public static final /* enum */ RequestType FILE_DOWNLOAD;
        private static final /* synthetic */ RequestType[] $VALUES;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public static RequestType[] values() {
            boolean[] blArray = RequestType.$jacocoInit();
            blArray[0] = true;
            return (RequestType[])$VALUES.clone();
        }

        public static RequestType valueOf(String string2) {
            boolean[] blArray = RequestType.$jacocoInit();
            blArray[1] = true;
            return Enum.valueOf(RequestType.class, string2);
        }

        private RequestType() {
            boolean[] blArray = RequestType.$jacocoInit();
            blArray[2] = true;
        }

        static {
            boolean[] blArray = RequestType.$jacocoInit();
            NORMAL = new RequestType();
            MULTI_PART = new RequestType();
            FILE_DOWNLOAD = new RequestType();
            $VALUES = new RequestType[]{NORMAL, MULTI_PART, FILE_DOWNLOAD};
            blArray[3] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-4083640297759713069L, (String)"com/instabug/library/network/NetworkManager$RequestType", (int)4);
            }
            return blArray;
        }
    }
}

