/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.b;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class InstabugUserEventLogger {
    private static final long DELAY = 1L;
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 10000;
    private List<UserEvent> userEvents;
    private ConcurrentHashMap<String, Integer> userEventsCount;
    private ScheduledExecutorService insertionExecutor;
    private static transient /* synthetic */ boolean[] $jacocoData;

    private InstabugUserEventLogger() {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        blArray[0] = true;
        this.userEvents = new ArrayList<UserEvent>();
        blArray[1] = true;
        this.userEventsCount = new ConcurrentHashMap();
        blArray[2] = true;
    }

    public static InstabugUserEventLogger getInstance() {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        if (instabugUserEventLogger != null) {
            blArray[3] = true;
        } else {
            blArray[4] = true;
            instabugUserEventLogger = new InstabugUserEventLogger();
            blArray[5] = true;
        }
        blArray[6] = true;
        return instabugUserEventLogger;
    }

    public synchronized void logUserEvent(@NonNull String string2, UserEventParam ... userEventParamArray) throws IllegalStateException {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        Api.Parameter[] parameterArray = new Api.Parameter[2];
        blArray[7] = true;
        parameterArray[0] = new Api.Parameter().setName("eventIdentifier").setType(String.class);
        blArray[8] = true;
        parameterArray[1] = new Api.Parameter().setName("userEventParams").setType(UserEventParam.class);
        blArray[9] = true;
        AnalyticsObserver.getInstance().catchApiUsage(parameterArray);
        blArray[10] = true;
        if (b.a().b(Feature.USER_EVENTS) != Feature.State.ENABLED) {
            blArray[11] = true;
        } else {
            blArray[12] = true;
            blArray[13] = true;
            blArray[14] = true;
            UserEvent userEvent = new UserEvent().setEventIdentifier(string2).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
            Object object = userEventParamArray;
            int n = ((UserEventParam[])object).length;
            blArray[15] = true;
            for (int i = 0; i < n; ++i) {
                UserEventParam userEventParam = object[i];
                blArray[16] = true;
                userEvent.addParam(userEventParam);
                blArray[17] = true;
            }
            if (this.userEvents.size() < 10000) {
                blArray[18] = true;
            } else {
                blArray[19] = true;
                this.userEvents.remove(0);
                blArray[20] = true;
            }
            this.userEvents.add(userEvent);
            blArray[21] = true;
            object = this.userEventsCount.get(string2);
            if (object != null) {
                blArray[22] = true;
                object = (Integer)object + 1;
                this.userEventsCount.put(string2, (Integer)object);
                blArray[23] = true;
            } else {
                this.userEventsCount.put(string2, 1);
                blArray[24] = true;
            }
        }
        this.runInsertionHandler();
        blArray[25] = true;
    }

    private void runInsertionHandler() {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        if (this.insertionExecutor != null) {
            blArray[26] = true;
        } else {
            blArray[27] = true;
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            blArray[28] = true;
            scheduledExecutorService.schedule(new Runnable(this){
                final /* synthetic */ InstabugUserEventLogger a;
                private static transient /* synthetic */ boolean[] b;
                {
                    boolean[] blArray = 1.a();
                    this.a = instabugUserEventLogger;
                    blArray[0] = true;
                }

                @Override
                public void run() {
                    boolean[] blArray = 1.a();
                    Iterator iterator = InstabugUserEventLogger.access$000(this.a).entrySet().iterator();
                    blArray[1] = true;
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        blArray[2] = true;
                        InstabugUserEventLogger.access$100(this.a, (String)entry.getKey(), (Integer)entry.getValue());
                        blArray[3] = true;
                    }
                    InstabugUserEventLogger.access$000(this.a).clear();
                    blArray[4] = true;
                    InstabugUserEventLogger.access$202(this.a, null);
                    blArray[5] = true;
                }

                private static /* synthetic */ boolean[] a() {
                    boolean[] blArray = b;
                    if (b == null) {
                        blArray = b = Offline.getProbes((long)4285620002308883839L, (String)"com/instabug/library/logging/InstabugUserEventLogger$1", (int)6);
                    }
                    return blArray;
                }
            }, 1L, TimeUnit.SECONDS);
            blArray[29] = true;
        }
        blArray[30] = true;
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String string2) throws IllegalStateException {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        Api.Parameter[] parameterArray = new Api.Parameter[1];
        blArray[31] = true;
        parameterArray[0] = new Api.Parameter().setName("userEventIdentifier").setType(String.class);
        blArray[32] = true;
        AnalyticsObserver.getInstance().catchApiUsage(parameterArray);
        blArray[33] = true;
        blArray[34] = true;
        return this.getEventLoggingCount(string2);
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        blArray[35] = true;
        return this.userEvents;
    }

    public void clearAll() throws IllegalStateException {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        blArray[36] = true;
        this.userEvents.clear();
        blArray[37] = true;
    }

    public void clearLoggingData() throws IllegalStateException {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        blArray[38] = true;
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        blArray[39] = true;
        sQLiteDatabaseWrapper.delete("user_events_logs", null, null);
        blArray[40] = true;
    }

    private void incrementEventLoggingCount(@NonNull String string2, int n) {
        boolean bl;
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        int n2 = this.getEventLoggingCount(string2);
        if (n2 > 0) {
            bl = blArray[41] = true;
        } else {
            bl = false;
            blArray[42] = true;
        }
        boolean bl2 = bl;
        blArray[43] = true;
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        blArray[44] = true;
        ContentValues contentValues = new ContentValues();
        blArray[45] = true;
        contentValues.put("event_identifier", string2);
        blArray[46] = true;
        contentValues.put("event_logging_count", Integer.valueOf(n2 += n));
        if (bl2) {
            blArray[47] = true;
            InstabugSDKLogger.d(this, "update: " + sQLiteDatabaseWrapper.update("user_events_logs", contentValues, "event_identifier=?", new String[]{string2}));
            blArray[48] = true;
        } else {
            InstabugSDKLogger.d(this, "insert: " + sQLiteDatabaseWrapper.insert("user_events_logs", null, contentValues));
            blArray[49] = true;
        }
        sQLiteDatabaseWrapper.close();
        blArray[50] = true;
    }

    private int getEventLoggingCount(@NonNull String string2) {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        blArray[51] = true;
        Cursor cursor = sQLiteDatabaseWrapper.query("user_events_logs", new String[]{"event_logging_count"}, "event_identifier =?", new String[]{string2}, null, null, null);
        int n = 0;
        blArray[52] = true;
        if (cursor.getCount() <= 0) {
            blArray[53] = true;
        } else {
            blArray[54] = true;
            cursor.moveToFirst();
            blArray[55] = true;
            int n2 = cursor.getColumnIndex("event_logging_count");
            blArray[56] = true;
            n = cursor.getInt(n2);
            blArray[57] = true;
        }
        cursor.close();
        blArray[58] = true;
        sQLiteDatabaseWrapper.close();
        blArray[59] = true;
        return n;
    }

    static /* synthetic */ ConcurrentHashMap access$000(InstabugUserEventLogger instabugUserEventLogger) {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        blArray[60] = true;
        return instabugUserEventLogger.userEventsCount;
    }

    static /* synthetic */ void access$100(InstabugUserEventLogger instabugUserEventLogger, String string2, int n) {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        instabugUserEventLogger.incrementEventLoggingCount(string2, n);
        blArray[61] = true;
    }

    static /* synthetic */ ScheduledExecutorService access$202(InstabugUserEventLogger instabugUserEventLogger, ScheduledExecutorService scheduledExecutorService) {
        boolean[] blArray = InstabugUserEventLogger.$jacocoInit();
        instabugUserEventLogger.insertionExecutor = scheduledExecutorService;
        blArray[62] = true;
        return instabugUserEventLogger.insertionExecutor;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-942759572266314005L, (String)"com/instabug/library/logging/InstabugUserEventLogger", (int)63);
        }
        return blArray;
    }
}

