/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class CacheManager {
    public static final String DEFAULT_IN_MEMORY_CACHE_KEY = "DEFAULT_IN_MEMORY_CACHE_KEY";
    private final List<Cache> caches;
    private static CacheManager INSTANCE;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public CacheManager() {
        boolean[] blArray = CacheManager.$jacocoInit();
        blArray[0] = true;
        this.caches = new ArrayList<Cache>();
        blArray[1] = true;
        InMemoryCache inMemoryCache = new InMemoryCache(DEFAULT_IN_MEMORY_CACHE_KEY);
        blArray[2] = true;
        this.caches.add(inMemoryCache);
        blArray[3] = true;
    }

    public static synchronized CacheManager getInstance() {
        boolean[] blArray = CacheManager.$jacocoInit();
        if (INSTANCE != null) {
            blArray[4] = true;
        } else {
            blArray[5] = true;
            INSTANCE = new CacheManager();
            blArray[6] = true;
        }
        blArray[7] = true;
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Cache getCache(String string2) {
        boolean[] blArray = CacheManager.$jacocoInit();
        List<Cache> list = this.caches;
        synchronized (list) {
            try {
                blArray[8] = true;
                Iterator<Cache> iterator = this.caches.iterator();
                blArray[9] = true;
                while (iterator.hasNext()) {
                    Cache cache = iterator.next();
                    blArray[10] = true;
                    if (cache.getId().equals(string2)) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                        blArray[12] = true;
                        return cache;
                    }
                    blArray[11] = true;
                    blArray[13] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[14] = true;
                throw throwable;
            }
        }
        InstabugSDKLogger.d(this, "No cache with this ID was found " + string2 + " returning null");
        blArray[15] = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache addCache(Cache cache) {
        boolean[] blArray = CacheManager.$jacocoInit();
        Cache cache2 = this.getCache(cache.getId());
        if (cache2 != null) {
            blArray[16] = true;
            return cache2;
        }
        List<Cache> list = this.caches;
        synchronized (list) {
            try {
                blArray[17] = true;
                this.caches.add(cache);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                blArray[18] = true;
                throw throwable;
            }
        }
        blArray[19] = true;
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCache(String string2) {
        boolean[] blArray = CacheManager.$jacocoInit();
        Cache cache = this.getCache(string2);
        if (cache != null) {
            List<Cache> list = this.caches;
            synchronized (list) {
                try {
                    blArray[20] = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                    blArray[21] = true;
                    return this.caches.remove(cache);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                    blArray[22] = true;
                    throw throwable;
                }
            }
        }
        InstabugSDKLogger.d(this, "No cache was this ID was found " + string2 + " to be deleted");
        blArray[23] = true;
        return false;
    }

    public boolean cacheExists(String string2) {
        boolean bl;
        boolean[] blArray = CacheManager.$jacocoInit();
        if (this.getCache(string2) != null) {
            bl = blArray[24] = true;
        } else {
            bl = false;
            blArray[25] = true;
        }
        blArray[26] = true;
        return bl;
    }

    public boolean subscribe(String string2, CacheChangedListener cacheChangedListener) {
        boolean[] blArray = CacheManager.$jacocoInit();
        if (this.cacheExists(string2)) {
            blArray[27] = true;
            Cache cache = this.getCache(string2);
            blArray[28] = true;
            blArray[29] = true;
            return cache.addOnCacheChangedListener(cacheChangedListener);
        }
        blArray[30] = true;
        throw new IllegalArgumentException("No cache exists with this ID to subscribe to");
    }

    public boolean unSubscribe(String string2, CacheChangedListener cacheChangedListener) {
        boolean[] blArray = CacheManager.$jacocoInit();
        if (this.cacheExists(string2)) {
            blArray[31] = true;
            Cache cache = this.getCache(string2);
            blArray[32] = true;
            blArray[33] = true;
            return cache.removeOnCacheChangedListener(cacheChangedListener);
        }
        blArray[34] = true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCaches() {
        boolean[] blArray = CacheManager.$jacocoInit();
        List<Cache> list = this.caches;
        synchronized (list) {
            try {
                blArray[35] = true;
                Iterator<Cache> iterator = this.caches.iterator();
                blArray[36] = true;
                while (iterator.hasNext()) {
                    Cache cache = iterator.next();
                    blArray[37] = true;
                    cache.invalidate();
                    blArray[38] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[39] = true;
                throw throwable;
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
        blArray[40] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesForIdentifyingUsers() {
        boolean[] blArray = CacheManager.$jacocoInit();
        List<Cache> list = this.caches;
        synchronized (list) {
            try {
                blArray[41] = true;
                Iterator<Cache> iterator = this.caches.iterator();
                blArray[42] = true;
                while (iterator.hasNext()) {
                    Cache cache = iterator.next();
                    blArray[43] = true;
                    if (cache.getId().equals("user_attributes_memory_cache")) {
                        blArray[44] = true;
                        continue;
                    }
                    blArray[45] = true;
                    if (cache.getId().equals("user_attributes_disk_cache")) {
                        blArray[46] = true;
                        continue;
                    }
                    cache.invalidate();
                    blArray[47] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[48] = true;
                throw throwable;
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated except user attributes cache");
        blArray[49] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesButUserAttributes() {
        boolean[] blArray = CacheManager.$jacocoInit();
        List<Cache> list = this.caches;
        synchronized (list) {
            try {
                blArray[50] = true;
                Iterator<Cache> iterator = this.caches.iterator();
                blArray[51] = true;
                while (iterator.hasNext()) {
                    Cache cache = iterator.next();
                    blArray[52] = true;
                    if (cache.getId().equalsIgnoreCase("attrs")) {
                        blArray[53] = true;
                    } else {
                        blArray[54] = true;
                        if (cache.getId().equalsIgnoreCase("/user_attributes.cache")) {
                            blArray[55] = true;
                        } else {
                            blArray[56] = true;
                            if (cache.getId().equalsIgnoreCase("user_attributes_disk_cache")) {
                                blArray[57] = true;
                            } else {
                                blArray[58] = true;
                                if (cache.getId().equalsIgnoreCase("user_attributes_memory_cache")) {
                                    blArray[59] = true;
                                } else {
                                    blArray[60] = true;
                                    cache.invalidate();
                                    blArray[61] = true;
                                }
                            }
                        }
                    }
                    blArray[62] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl34 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[63] = true;
                throw throwable;
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
        blArray[64] = true;
    }

    public <K, V> void migrateCache(@NonNull String string2, @NonNull String string3, KeyExtractor<K, V> keyExtractor) throws IllegalArgumentException {
        boolean[] blArray = CacheManager.$jacocoInit();
        Cache cache = this.getCache(string2);
        blArray[65] = true;
        InMemoryCache inMemoryCache = this.getCache(string3);
        blArray[66] = true;
        InstabugSDKLogger.v(this, "Caches to be migrated " + cache + " - " + inMemoryCache);
        if (cache == null) {
            blArray[67] = true;
            InstabugSDKLogger.e(this, "Migration exception ", new IllegalArgumentException("No cache with these keys was found to migrate from"));
            blArray[68] = true;
            return;
        }
        if (inMemoryCache != null) {
            blArray[69] = true;
        } else {
            blArray[70] = true;
            inMemoryCache = new InMemoryCache(string3);
            blArray[71] = true;
            this.addCache(inMemoryCache);
            blArray[72] = true;
        }
        this.migrateCache(cache, inMemoryCache, keyExtractor);
        blArray[73] = true;
    }

    public <K, V> void migrateCache(@NonNull Cache<K, V> cache, @NonNull Cache<K, V> cache2, KeyExtractor<K, V> keyExtractor) {
        List<V> list;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                boolean[] blArray = CacheManager.$jacocoInit();
                                InstabugSDKLogger.d(this, "Invalidated migratingTo cache");
                                if (cache2 != null) break block9;
                                blArray[74] = true;
                                break block10;
                            }
                            if (cache != null) break block11;
                            blArray[75] = true;
                        }
                        InstabugSDKLogger.w(CacheManager.class, "cache migration process got failure, migratingToCache: " + cache2 + ", migratingFromCache: " + cache);
                        blArray[76] = true;
                        return;
                    }
                    cache2.invalidate();
                    blArray[77] = true;
                    list = cache.getValues();
                    blArray[78] = true;
                    if (list != null) break block12;
                    blArray[79] = true;
                    break block13;
                }
                if (!list.isEmpty()) break block14;
                blArray[80] = true;
            }
            InstabugSDKLogger.w(this, "Cache to migrate from doesn't contain any elements, not going further with the migration");
            blArray[81] = true;
            return;
        }
        Iterator<V> iterator = list.iterator();
        blArray[82] = true;
        while (iterator.hasNext()) {
            V v = iterator.next();
            if (v == null) {
                blArray[83] = true;
            } else {
                blArray[84] = true;
                blArray[85] = true;
                blArray[86] = true;
                InstabugSDKLogger.v(this, "Adding value " + v + " with key " + keyExtractor.extractKey(v));
                blArray[87] = true;
                cache2.put(keyExtractor.extractKey(v), v);
                blArray[88] = true;
            }
            blArray[89] = true;
        }
        blArray[90] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)7740956933111322313L, (String)"com/instabug/library/internal/storage/cache/CacheManager", (int)91);
        }
        return blArray;
    }

    public static abstract class KeyExtractor<K, V> {
        private static transient /* synthetic */ boolean[] $jacocoData;

        public KeyExtractor() {
            boolean[] blArray = KeyExtractor.$jacocoInit();
            blArray[0] = true;
        }

        public abstract K extractKey(V var1);

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-146220614628196971L, (String)"com/instabug/library/internal/storage/cache/CacheManager$KeyExtractor", (int)1);
            }
            return blArray;
        }
    }
}

